/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWBASE_H
#define _XWBASE_H

#include <ctype.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#ifndef tzSpace
#define tzSpace      0
#endif
#ifndef tzPipe
#define tzPipe       1
#endif

#ifndef baseSpace
#define baseSpace    "                                                                                "
#endif

/* Sleep Implementation */
/* 1/1.000.000 Sekunden warten */
void newSleep(int delay);

/*
   ##########################################################################
   # Datenkonvertieren                                                      #
   ##########################################################################
*/

/* Convert mm To Inch */
char *mmTOi(int a);
/* Convert Inch To mm */
int iTOmm(char *source);
/* mm -> 1/10 mm */
int xwMM(void);
/* Convert Integer To String */
char *IntStr(int a);
/* Convert Float To String */
char *DoubleStr(float a,int b);
/* Convert Float To Int */
int IRound(float a);

/*
   ##########################################################################
   # Stringverarbeitung                                                     #
   ##########################################################################
*/

/*
  Syntax  : strmids(String,Position,Length);
  Funktion: Teilbereich eines Strings ausschneiden.
*/
const char *strMids(char *source,int a,int b);
const char *strLength(const char *source,int len);
const char *strLLength(const char *source,int len);
void strTrim(char *source);
/*
  Syntax  : strnorem(string1,string2)
  Funktion: entfernt alle Zeichen ab dem Kommentarzeichen.
*/
char *strNoRem(char *source,char *rem);
/* String in Grossbuchstaben wandeln */
void strUpper(char *source);
/* Neue Version von StrTok !!! Diese Version untersttzt Anfhrungszeichen */
char *StrGet(char *source);
/* Trennzeichen setzen */
void SetStrGet(char *astr);
/*
   ##########################################################################
   # Dateiverwaltung                                                        #
   ##########################################################################
*/

/* berprfen ob Datei vorhanden 
      0 - True / -1 - False      */
int xwExist(char *file);

/*
   ##########################################################################
   # Programm                                                               #
   ##########################################################################
*/

/* Execute an Program */
void xwExec(char *command,int runmode,char *output);

#endif