/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "base.h"

#include "default.h"
#include "limits.h"

static char          bChar[4]="";     /* break character */


/* Sleep Implementation */
/* 1/1.000.000 Sekunden warten */
void newSleep(int delay)
{
  struct timeval tval;

  tval.tv_usec = delay % 1000000;
  tval.tv_sec = delay / 1000000;
  select(1,0,0,0,&tval);

  return;
}

/*
   ##########################################################################
   # Datenkonvertieren                                                      #
   ##########################################################################
*/

/* Convert mm To Inch */
char *mmTOi(int a) /*fold00*/
{
   static char       buf[30];
   float             inch;

   inch=(float) a/25.4;
   sprintf(buf,"%.2f",inch);

   return(buf);
}

/* Convert Inch To mm */
int iTOmm(char *source) /*fold00*/
{
   float             b;
   char              as[40];

   strcpy(as,source);
   b=atof(source);
   b=b*25.4;

   return(IRound(b));
}

/* mm -> 1/10 mm */
int xwMM(void) /*fold00*/
{
   return(xwGetPrefValue(xwgMM));
}

/* Convert Integer To String */
char *IntStr(int a) /*fold00*/
{
  static char buf[40];
  sprintf(buf,"%d",a);
  return(buf);
}

/* Convert Float To String */
char *DoubleStr(float a,int b) /*fold00*/
{
  static char buf[40];
  if (b==0) sprintf(buf,"%f",a);
  else if (b==1) sprintf(buf,"%.1f",a);
  else if (b==2) sprintf(buf,"%.2f",a);
  return(buf);
}

/* Convert Float To Int */
int IRound(float a) /*fold00*/
{
   int         aa;
   float       af;

   aa=(int) a;
   af=a- (float) aa;

   if (af >= 0.5)
   {
      aa++;
   }

   return(aa);
}

/*
   ##########################################################################
   # Stringverarbeitung                                                     #
   ##########################################################################
*/
 
/*
  Syntax  : strmids(String,Position,Length);
  Funktion: Teilbereich eines Strings ausschneiden.
*/
const char *strMids(char *source,int a,int b)
{
   static char tex[1024];
   const char *strdef;

   strcpy(tex,source);

   if (strlen(tex)>=0)
   {
      tex[(a+b)-1]='\0';

      strdef=tex;
      strdef=strdef+(a-1);
   }

   return(strdef);
}

const char *strLength(const char *source,int len)
{
   static char tex[4100];
   int         pos;
   char        *strptr;

   strcpy(tex,"");
   if ((len>1) && (len<4097) && (strlen(source)<4096))
   {
      strcpy(tex,source);
      pos=strlen(tex);
      
      while (pos<=len)
      {
         strptr=tex;
         strptr[pos]=0x20;
         pos++;
      }
      strptr[pos]=0x00;
   }
   
   return(tex);
}

const char *strLLength(const char *source,int len)
{
   static char tex[4100];
   int         pos;
   int         az;

   if (strlen(source)<4096)
   {
      strcpy(tex,source);
   }
   else
   {
      strcpy(tex,"");
   }
   
   pos=len-strlen(source);
   if ((pos>0) && (len<4096))
   {      
      strcpy(tex,"");
   
      /* create first string */
      for (az=1 ; az<=pos ; az++)
      {
         strcat(tex," ");
      }
      
      /* merge strings */
      strcat(tex,source);
   }

   return(tex);
}

void strTrim(char *source)
{
  static char tex[1024]="";
  const char *strdef;

  /* front */
  int a=1;
  strcpy(tex,source);
  while ( ( (strcmp(strMids(tex,a,1)," ") == 0) && (a <= (int) strlen(tex)) ) ||
          ( (strcmp(strMids(tex,a,1),"\t") == 0) && (a <= (int) strlen(tex)) ) )
    {
      a++;
    }
  strdef = strMids(tex,a,(strlen(tex)-a)+1);
  strcpy(tex,strdef);

  /* back */
  a = strlen(tex);
  while ( ( (strcmp(strMids(tex,a,1)," ") == 0) && (a > 0) ) ||
          ( (strcmp(strMids(tex,a,1),"\t") == 0) && (a > 0) ) )
    {
      a--;
    }
  strdef = strMids(tex,1,a);
  strcpy(source,strdef);

  return;
}
 /*fold00*/
/*
  Syntax  : strnorem(string1,string2)
  Funktion: entfernt alle Zeichen ab dem Kommentarzeichen.
*/
char *strNoRem(char *source,char *rem) /*fold00*/
{
  static char tex[1024]="";
  char aas[4]="";
  const char *strdef;
  int a=1;
  int b=0;

  strcpy(tex,source);
  if (strlen(tex) > 0)
    {
      strdef = strMids(tex,1,1);
      strcpy(aas,strdef);
      if ( (strcmp(aas,rem) == 0) && (a == 1) )
        {
          strcpy(tex,"");
        }
      else
        {
          while (a < (int) strlen(tex))
            {
              a++;
              strdef = strMids(tex,a,1);
              strcpy(aas,strdef);

              if (strcmp(aas,rem) == 0)
                {
                  b=a-1;
                }

            }
          if (b>0)
            {
              strdef = strMids(tex,1,b-1);
              strcpy(tex,strdef);
            }
        }
    }
  else
    {
      strcpy(tex,"");
    }
  return(tex);
}


/* String in Grossbuchstaben wandeln */
void strUpper(char *source) /*fold00*/
{
  static char tex[1024]="";
  int a;

  a=1;
  strcpy(tex,source);
  if ( strlen(tex) > 0)
    {
      for ( a=1 ; a <= (int) strlen(tex) ; a++ )
        {
          tex[a-1] = toupper(tex[a-1]);
        }
    }
  strcpy(source,tex);

  return;
}

/* Neue Version von StrTok !!! Diese Version untersttzt Anfhrungszeichen */
char *StrGet(char *source) /*fold00*/
{
   static char          buffer[1028];   
   static char          dest[1028];

   int            countA,countB;
   int            flag;

   /* Flag
            0 = bis zum ersten Zeichen scannen
            1 = ersten Anfhrungszeichen gefunden,
                jetzt bis zum zweiten scannen
            2 = bis zum nchsten Leerzeichen scannen
   */

   if ( (source != NULL) && (strlen(source)<1025) )
   {
      strcpy(buffer,source);
      /*printf("StrGet: %s\n",buffer);*/
   }

/*
   strcpy(dest," ");
   for (countA=32 ; countA<128 ; countA++)
   {
      dest[0]=countA;
      printf("%i=%s ",countA,dest);
   }
*/

   countA=0;
   countB=0;
   strcpy(dest,"");
   flag=0;
   if (strlen(buffer)>0)
   {
      while (flag>-1)
      {
         /* Tabulator -> Space conversation */
         if ( (buffer[countA]==0x09) ) buffer[countA]=0x20;

         /* End of String */
         if ( (buffer[countA]==0x00) )
         {
            flag=-2;
         }

         /* Comment */
         else if ( (buffer[countA]==0x23) && (flag==0) )
         {
          flag=-2;
         }

         /* Normale Trennzeichen */
         if (strlen(bChar)==0)
         {
            /* Leerzeichen bergehen bis erstes Zeichen gefunden > |:< */
            if ( ( (buffer[countA]==0x20) || (buffer[countA]==0x7c) || (buffer[countA]==0x3a) ) && (flag==0) )
            {
               countA++;
            }

            /*
                  Normal String Scan
            */

            /* Zeichen gefunden, umschalten auf Zeichen scannen */
            else if ( (buffer[countA]!=0x20) && (buffer[countA]!=0x22) && (buffer[countA]!=0x7c) && (buffer[countA]!=0x3a) && (flag==0) )
            {
               flag=2;
               dest[countB]=buffer[countA];
               countA++;
               countB++;
            }

            /* Zeichen gefunden, weiter scannen bis zum nchsten Leerzeichen */
            else if ( (buffer[countA]!=0x20) && (buffer[countA]!=0x22) && (buffer[countA]!=0x7c) && (buffer[countA]!=0x3a) && (flag==2) )
            {
               dest[countB]=buffer[countA];
               countA++;
               countB++;
            }

            /* Leerzeichen gefunden - beenden */
            else if ( ( (buffer[countA]==0x20) || (buffer[countA]==0x7c) || (buffer[countA]==0x3a) ) && (flag==2) )
            {
               flag=-1;
            }

            /*
                  Spezial Scan
            */

            /* erstes Anfhrungszeichen gefunden  */
            else if ( (buffer[countA]==0x22) && (flag!=1) )
            {
               flag=1;
               countA++;
            }

            /* Zeichen kopieren ( innerhalb der Anfhrungszeichen ) */
            else if ( (buffer[countA]!=0x22) && (flag==1) )
            {
               dest[countB]=buffer[countA];
               countA++;
               countB++;
            }

            /* zweites Anfhrungszeichen gefunden  */
            else if ( (buffer[countA]==0x22) && (flag==1) )
            {
               flag=2;
               countA++;
            }

         }
         else
         {
            /* Leerzeichen bergehen bis erstes Zeichen gefunden > |:< */
            if ( (buffer[countA]==bChar[0]) && (flag==0) )
            {
               countA++;
            }

            /*
                  Normal String Scan
            */

            /* Zeichen gefunden, umschalten auf Zeichen scannen */
            else if ( (buffer[countA]!=bChar[0]) && (flag==0) )
            {
               flag=2;
               dest[countB]=buffer[countA];
               countA++;
               countB++;
            }

            /* Zeichen gefunden, weiter scannen bis zum nchsten Leerzeichen */
            else if ( (buffer[countA]!=bChar[0]) && (flag==2) )
            {
               dest[countB]=buffer[countA];
               countA++;
               countB++;
            }

            /* Leerzeichen gefunden - beenden */
            else if ( (buffer[countA]==bChar[0]) && (flag==2) )
            {
               flag=-1;
            }
         }
      }

      if (flag==-1) strcpy(buffer,&buffer[countA]);
      if (flag==-2) strcpy(buffer,"");

      dest[countB]=0x00;

      if (countB==0) return("");
   }

   return(dest);
}

/* Trennzeichen setzen */
void SetStrGet(char *astr) /*fold00*/
{
   if (strlen(astr)<2)
   {
      strcpy(bChar,astr);
   }
   else if (strlen(astr)==0)
   {
      strcpy(bChar,"");
   }

   return;
}


/*
   ##########################################################################
   # Dateiverwaltung                                                        #
   ##########################################################################
*/

/* berprfen ob Datei vorhanden */
int xwExist(char *file) /*fold00*/
{
   FILE           *fh;

   /* Check Setting File */
   fh=fopen(file,"r");
   if (fh!= NULL)
   {
      fclose(fh);
      return(xwTrue);
   }

   return(xwFalse);
}

/*
   ##########################################################################
   # Programm                                                               #
   ##########################################################################
*/

/* Execute an Program */
void xwExec(char *command,int runmode,char *output) /*fold00*/
{
   /* Exec Datas */
   char           cmdD[2048];
   static long    pid;
   static int     status;
   static char    args[100][80]; /* Arg Array */
   static char    *argv[100];
   int            prtA,prtB;
   int            bug;

   char           *strptr;

   if ( (strlen(command)>0) && (strlen(command)<2048) )
   {
      strcpy(cmdD,command);

      /* Build ArgList */
      prtA=0;
      prtB=0;
      SetStrGet("");
      strptr = StrGet(cmdD);
      while (strlen(strptr)>0)
      {
         strcpy(args[prtA],strptr);

         if (prtA>-1)
         {
            argv[prtB] = args[prtA];
            prtB++;
            argv[prtB]=NULL;
         }
         prtA++;

         strptr = StrGet(NULL);
      }
   
      pid=0;
      bug=0;
      /* create Process */
      if ( (pid=fork()) == 0)
      {
         if (strlen(output)>0)
         {
            freopen(output,"a",stderr);
            freopen(output,"a",stdout);
         }
         
         bug=execvp(args[0],argv);
         
         if (strlen(output)>0)
         {
            freopen("/dev/tty","a",stderr);
            freopen("/dev/tty","a",stdout);
         }
         
         exit(0);
      }
      
      /* wait for process end */
      if (runmode==-1)
      {
         while (waitpid(pid,&status,WNOHANG)!=-1)
         {
            usleep(100000);
         }
         usleep(100000);
      }
   }

   return;
}