/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWASSISTENT_H
#define _XWASSISTENT_H

#include <forms.h>

#include <ctype.h>
#include <dirent.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#define assNone            0
#define assMain            1
#define assExit            2

#define assBorderline      0.5
#define assBordersize      2.0

typedef struct assistentform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *info;
   
   FL_OBJECT         *frame;

   FL_OBJECT         *print;
   FL_OBJECT         *visitingcard;
   FL_OBJECT         *cover;
   FL_OBJECT         *contactprint;

   FL_OBJECT         *about;
   FL_OBJECT         *pref;
   FL_OBJECT         *mtink;
   
   FL_OBJECT         *xwgui;
   FL_OBJECT         *exit;
   
   FL_OBJECT         *message;

   FL_OBJECT         *remark[20];
} assistentform;

typedef struct assprintform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *printer;
   
   FL_OBJECT         *dpiout;
   FL_OBJECT         *sheets;
   
   FL_OBJECT         *tofile;
   FL_OBJECT         *file;
   
   FL_OBJECT         *print;
   FL_OBJECT         *cancel;
   
   int               paperXSize;             /* PaperSize */
   int               paperYSize;
   int               fileSize;
} assprintform;

/* Display Help Messages */
int xwAssHelp(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev);

/* Assistent GUI */
int xwAssistent(int mo);
/* Hide Main GUI */
void xwHideAssistent(void);
/* Show Main GUI */
void xwShowAssistent(void);
/* Show Preview */
void xwPreviewAssistent(void);
/* Print */
void xwPrintAssistent(int mo);
/* Get Print Flag */
int xwCheckPrintAbort(void);
/* Remove Object */
void xwRemoveObject(FL_OBJECT *obj);

#endif

