/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "assistent.h"

#include "pbcache.h"

#include "about.h"
#include "ass-contactprint.h"
#include "ass-cover.h"
#include "ass-picture.h"
#include "ass-pref.h"
#include "ass-visitingcard.h"
#include "base.h"
#include "default.h"
#include "error.h"
#include "frame.h"
#include "gfx.h"
#include "handler.h"
#include "limits.h"
#include "lowlevel.h"
#include "main.h"
#include "main_gui.h"
#include "paper.h"
#include "picture.h"
#include "pref_printer.h"
#include "printer.h"
#include "render.h"
#include "resource.h"
#include "wysiwyg.h"
#include "x11.h"

/* Picture View */
/*#include "pixmaps/as-empty.xpm"*/

#include "pixmaps/as-picture.xpm"
#include "pixmaps/as-visitingcard.xpm"
#include "pixmaps/as-cover.xpm"
#include "pixmaps/as-contactprint.xpm"
#include "pixmaps/as-about.xpm"
#include "pixmaps/as-pref.xpm"
#include "pixmaps/as-mtink.xpm"
#include "pixmaps/as-xwgui.xpm"
#include "pixmaps/as-exit.xpm"


static struct assprintform       prf;        /* Print GUI */

static struct assistentform      af;

static int                       afMain;     /* Main GUI Flag */

static int                       afPrtAbort; /* Abort Print Flag */


extern Atom             xwGUIAtom;
extern Window           xwGUIWindow;

/* Display Help Messages */
int xwAssHelp(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key,void *xev)
{
   if (event == FL_ENTER)
   {
      if (obj==af.print) fl_set_object_label(af.message,xwGR(1,"ass.HMPrintPicture","With this function you can print an picture."));
      else if (obj==af.visitingcard) fl_set_object_label(af.message,xwGR(1,"ass.HMVisitingCard","You can print any visitingcards with this fuction."));
      else if (obj==af.cover) fl_set_object_label(af.message,xwGR(1,"ass.HMCover","You can print an cover for CD, DVD or other."));
      else if (obj==af.contactprint) fl_set_object_label(af.message,xwGR(1,"ass.HMContactPrint","Print an Picture Overview from selected Directory."));
      else if (obj==af.about) fl_set_object_label(af.message,xwGR(1,"ass.HMAbout","Gives information about the peoples behind from xwGUI."));
      else if (obj==af.pref) fl_set_object_label(af.message,xwGR(1,"ass.HMPrefs","You can modify any settings from xwGUI at this point.\nAn example: you can modify the printer settings."));
      else if (obj==af.mtink) fl_set_object_label(af.message,xwGR(1,"ass.HMMTInk","You can start MTInk with this Button.\nMTInk is an Statusmonitor for EPSON-Printers."));
      else if (obj==af.xwgui) fl_set_object_label(af.message,xwGR(1,"ass.HMxwGUI","Here you can chnage to the Main-GUI from xwGUI."));
      else if (obj==af.exit) fl_set_object_label(af.message,xwGR(1,"ass.HMQuitAssistent","With this function you canm quit the assistent.")); 
   }
   
   return(0);
}

/* /usr/openwin/lib/X11/fonts */

/* Assistent GUI */
int xwAssistent(int mo)
{
   int            exitMode=0;
   int            wyA,wyB;
   
   wyA=xwAskRealMode();
   xwSetRealMode();
   wyB=xwGetPrefValue(xwgWYSIWYG);
   xwSetPrefValue(xwgWYSIWYG,wmHWYSIWYG);

   afMain=mo;

   af.form = NULL;

   af.form = fl_bgn_form(FL_UP_BOX,690,468+42); /*534);*/

   fl_set_border_width(1);

   /* Titlebar */
   af.info = fl_add_box(FL_DOWN_BOX,3,3,684,30,xwGR(1,"ass.Title","xwGraphicsUserInterface - Assistent"));
   fl_set_object_lstyle(af.info,FL_EMBOSSED_STYLE);
   fl_set_object_lsize(af.info,FL_HUGE_SIZE); /* LARGE */
   fl_set_object_lcol(af.info,FL_BLUE);

   af.message = fl_add_box(FL_DOWN_BOX,3,466,684,40,"");

   /* Frame 489 */
   af.frame = fl_add_frame(FL_DOWN_FRAME,5,40,680,424,"");

   fl_set_border_width(2);

   /* 7 / 15 ( 75 ) / 8 */

   af.print = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((1-1)*115),42+((1-1)*140),100,100,xwGR(1,"ass.PrintPicture","Print\nPicture"));
   fl_set_pixmap_data(af.print,as_picture_xpm);
   fl_set_object_color(af.print,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.print,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.print,xwAssHelp);

   af.visitingcard = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((2-1)*115),42+((1-1)*140),100,100,xwGR(1,"ass.VisitingCard","Visiting\nCard"));
   fl_set_pixmap_data(af.visitingcard,as_visitingcard_xpm);
   fl_set_object_color(af.visitingcard,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.visitingcard,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.visitingcard,xwAssHelp);

   af.cover = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((3-1)*115),42+((1-1)*140),100,100,xwGR(1,"ass.Cover","Covers"));
   fl_set_pixmap_data(af.cover,as_cover_xpm);
   fl_set_object_color(af.cover,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.cover,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.cover,xwAssHelp);

   af.contactprint = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((4-1)*115),42+((1-1)*140),100,100,xwGR(1,"ass.ContactPrint","Contact\nPrints"));
   fl_set_pixmap_data(af.contactprint,as_contactprint_xpm);
   fl_set_object_color(af.contactprint,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.contactprint,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.contactprint,xwAssHelp);

   af.about = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((1-1)*115),42+((3-1)*140),100,100,xwGR(1,"ass.Info","Info's\nabout\nxwGUI"));
   fl_set_pixmap_data(af.about,as_about_xpm);
   fl_set_object_color(af.about,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.about,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.about,xwAssHelp);
    
   af.pref = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((2-1)*115),42+((3-1)*140),100,100,xwGR(1,"ass.Prefs","Settings"));
   fl_set_pixmap_data(af.pref,as_pref_xpm);
   fl_set_object_color(af.pref,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.pref,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.pref,xwAssHelp);

   if (strlen(xwGetPrefName(xwgMTInk))>0)
   {   
      af.mtink = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((3-1)*115),42+((3-1)*140),100,100,xwGR(1,"ass.MTInk","MTInk"));
      fl_set_pixmap_data(af.mtink,as_mtink_xpm);
      fl_set_object_color(af.mtink,FL_BLACK,FL_MCOL);
      fl_set_object_gravity(af.mtink,FL_NorthWest,FL_NorthWest);
      fl_set_object_posthandler(af.mtink,xwAssHelp);
   }

   if (afMain==1)
   {      
      af.xwgui = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((5-1)*115),42+((3-1)*140),100,100,xwGR(1,"ass.xwGUI","exchange\nto\nxwGUI"));
      fl_set_pixmap_data(af.xwgui,as_xwgui_xpm);
      fl_set_object_color(af.xwgui,FL_BLACK,FL_MCOL);
      fl_set_object_gravity(af.xwgui,FL_NorthWest,FL_NorthWest);
      fl_set_object_posthandler(af.xwgui,xwAssHelp);
   }
   
   af.exit = fl_add_pixmapbutton(FL_NORMAL_BUTTON,7+((6-1)*115),42+((3-1)*140),100,100,xwGR(1,"ass.QuitAssistent","Quit\nAssistent"));
   fl_set_pixmap_data(af.exit,as_exit_xpm);
   fl_set_object_color(af.exit,FL_BLACK,FL_MCOL);
   fl_set_object_gravity(af.exit,FL_NorthWest,FL_NorthWest);
   fl_set_object_posthandler(af.exit,xwAssHelp);

   /* 462+2 */

   /* Remarked Panels */
   /*af.remark[1] = fl_add_box(FL_DOWN_BOX,7+((1-1)*115),42+((1-1)*140),100,100,"");*/
   /*af.remark[2] = fl_add_box(FL_DOWN_BOX,7+((2-1)*115),42+((1-1)*140),100,100,"");*/
   /*af.remark[3] = fl_add_box(FL_DOWN_BOX,7+((3-1)*115),42+((1-1)*140),100,100,"");*/
   /*af.remark[4] = fl_add_box(FL_DOWN_BOX,7+((4-1)*115),42+((1-1)*140),100,100,"");*/
   af.remark[5] = fl_add_box(FL_DOWN_BOX,7+((5-1)*115),42+((1-1)*140),100,100,"");
   af.remark[6] = fl_add_box(FL_DOWN_BOX,7+((6-1)*115),42+((1-1)*140),100,100,"");
   af.remark[7] = fl_add_box(FL_DOWN_BOX,7+((1-1)*115),42+((2-1)*140),100,100,"");
   af.remark[8] = fl_add_box(FL_DOWN_BOX,7+((2-1)*115),42+((2-1)*140),100,100,"");
   af.remark[9] = fl_add_box(FL_DOWN_BOX,7+((3-1)*115),42+((2-1)*140),100,100,"");
   af.remark[10] = fl_add_box(FL_DOWN_BOX,7+((4-1)*115),42+((2-1)*140),100,100,"");
   af.remark[11] = fl_add_box(FL_DOWN_BOX,7+((5-1)*115),42+((2-1)*140),100,100,"");
   af.remark[12] = fl_add_box(FL_DOWN_BOX,7+((6-1)*115),42+((2-1)*140),100,100,"");
   /*af.remark[13] = fl_add_box(FL_DOWN_BOX,7+((1-1)*115),42+((3-1)*140),100,100,"");*/
   /*af.remark[14] = fl_add_box(FL_DOWN_BOX,7+((2-1)*115),42+((3-1)*140),100,100,"");*/
   if (strlen(xwGetPrefName(xwgMTInk))==0)
   { 
      af.remark[15] = fl_add_box(FL_DOWN_BOX,7+((3-1)*115),42+((3-1)*140),100,100,"");
   }
   af.remark[16] = fl_add_box(FL_DOWN_BOX,7+((4-1)*115),42+((3-1)*140),100,100,"");
   if (afMain==0) af.remark[17] = fl_add_box(FL_DOWN_BOX,7+((5-1)*115),42+((3-1)*140),100,100,"");
   /*af.remark[18] = fl_add_box(FL_DOWN_BOX,7+((6-1)*115),42+((3-1)*140),100,100,"");*/
  
   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(af.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwInfoA);
   }
   else
   {
      fl_prepare_form_window(af.form,FL_PLACE_CENTER,FL_TRANSIENT,xwInfoA);
   }   
   
   /* Display Window */
   fl_show_form_window(af.form);
   
   fl_set_app_mainform(af.form);
   
   /* Exit Handler */
   fl_set_form_atclose(af.form,nclose_cb,(void *) "1");

   if (afMain==1)
   {  
      /* xwGUIAtom */
      XSetSelectionOwner(fl_get_display(),xwGUIAtom,af.form->window,CurrentTime);
   }

   af.ready=0;
   while (af.ready==0)
   {
      af.obj=fl_do_forms();

      /* Exit */
      if (af.obj==af.exit)
      {
         af.ready=1;
         exitMode=assExit;
      }
      
      /* Exit to xwGUI */
      else if (af.obj==af.xwgui)
      {
         af.ready=1;
         exitMode=assMain;
      }

      else if (af.obj==af.about)
      {
         fl_deactivate_form(af.form);
         xwAbout();      
         fl_activate_form(af.form);
      }
      
      else if (af.obj==af.pref) assPref(af.form);

      else if (af.obj==af.mtink) xwExec(xwGetPrefName(xwgMTInk),0,"");

      /* ########## Assistent Calls ########## */
      
      /* Print Picture */
      else if (af.obj==af.print) assPrintPicture(af.form);

      /* VisitingCard */
      else if (af.obj==af.visitingcard) assVisitingCard(af.form);
      
      /* Print Cover */
      else if (af.obj==af.cover) assPrintCover(af.form);

      /* Print ContactPrint */
      else if (af.obj==af.contactprint) assPrintContactPrint(af.form);

   }

   fl_hide_form(af.form);

   fl_free_pixmapbutton_pixmap(af.print);
   fl_free_pixmapbutton_pixmap(af.visitingcard);
   fl_free_pixmapbutton_pixmap(af.cover);
   fl_free_pixmapbutton_pixmap(af.contactprint);
   
   fl_free_pixmapbutton_pixmap(af.about);
   fl_free_pixmapbutton_pixmap(af.pref);
   if (strlen(xwGetPrefName(xwgMTInk))>0)
   { 
      fl_free_pixmapbutton_pixmap(af.mtink);
   }
   if (afMain==1) fl_free_pixmapbutton_pixmap(af.xwgui);
   fl_free_pixmapbutton_pixmap(af.exit);

   fl_free_form(af.form);
   af.form=NULL;

   if (afMain==0) xwAppMainGui();

   if (wyA==0) xwUnSetRealMode();
   xwSetPrefValue(xwgWYSIWYG,wyB);
   
   return(exitMode);
}

/* Hide Main GUI */
void xwHideAssistent(void)
{
   fl_hide_object(af.print);
   fl_hide_object(af.visitingcard);
   fl_hide_object(af.cover);
   fl_hide_object(af.contactprint);
   
   fl_hide_object(af.about);
   fl_hide_object(af.pref);
   if (strlen(xwGetPrefName(xwgMTInk))>0)
   { 
      fl_hide_object(af.mtink);
   }

   if (afMain==1) fl_hide_object(af.xwgui);
   fl_hide_object(af.exit);

   /*fl_hide_object(af.remark[1]);*/ 
   /*fl_hide_object(af.remark[2]);*/
   /*fl_hide_object(af.remark[3]);*/
   /*fl_hide_object(af.remark[4]);*/
   fl_hide_object(af.remark[5]);
   fl_hide_object(af.remark[6]);
   fl_hide_object(af.remark[7]);
   fl_hide_object(af.remark[8]);
   fl_hide_object(af.remark[9]);
   fl_hide_object(af.remark[10]);
   fl_hide_object(af.remark[11]);
   fl_hide_object(af.remark[12]);
   /*fl_hide_object(af.remark[13]);*/
   /*fl_hide_object(af.remark[14]);*/
   if (strlen(xwGetPrefName(xwgMTInk))==0)
   { 
      fl_hide_object(af.remark[15]);
   }
   fl_hide_object(af.remark[16]);
   if (afMain==0) fl_hide_object(af.remark[17]);
   /*fl_hide_object(af.remark[18]);*/

   return;
}

/* Show Main GUI */
void xwShowAssistent(void)
{
   fl_show_object(af.print);
   fl_show_object(af.visitingcard);
   fl_show_object(af.cover);
   fl_show_object(af.contactprint);
   
   fl_show_object(af.about);
   fl_show_object(af.pref);
   if (strlen(xwGetPrefName(xwgMTInk))>0)
   { 
      fl_show_object(af.mtink);
   }
   if (afMain==1) fl_show_object(af.xwgui);
   fl_show_object(af.exit);

   /*fl_show_object(af.remark[1]);*/ 
   /*fl_show_object(af.remark[2]);*/
   /*fl_show_object(af.remark[3]);*/
   /*fl_show_object(af.remark[4]);*/
   fl_show_object(af.remark[5]);
   fl_show_object(af.remark[6]);
   fl_show_object(af.remark[7]);
   fl_show_object(af.remark[8]);
   fl_show_object(af.remark[9]);
   fl_show_object(af.remark[10]);
   fl_show_object(af.remark[11]);
   fl_show_object(af.remark[12]);
   /*fl_show_object(af.remark[13]);*/
   /*fl_show_object(af.remark[14]);*/
   if (strlen(xwGetPrefName(xwgMTInk))==0)
   { 
      fl_show_object(af.remark[15]);
   }
   fl_show_object(af.remark[16]);
   if (afMain==0) fl_show_object(af.remark[17]);
   /*fl_show_object(af.remark[18]);*/
   
   return;
}

/* Show Preview */
void xwPreviewAssistent(void)
{
   float             zoom;
   float             dpii;

   xwUnSetRealMode();

   /* Pictures available for print */
   if ( (xwGetPictureCount()>-1) || (xwGetFrameCount()>-1) )
   {   
      zoom=xwGetZoom();
      xwSetZoom(1);
      /* Set Pixel Size */
      xwSetPixelSize(xwGetPaperXSize(),xwGetPaperYSize());

      /* DPI Calculation */
      dpii=( ( (float) xwGetPaperXB() * (float) xwGetPixelSize() ) / ((float) xwGetPaperXB()/25.4) )*xwMM();

      if (xwIsPaperLS()==xwPortrait)
      {
         xwGFXLandscape(0);
      }
      else
      {
         xwGFXLandscape(1);
      }

      if ((int) xwRender(dpii,10,xwGetPaperXB(),xwGetPaperYB())!=-1)
      {
         xwSetZoom(zoom);
         /* Set Pixel Size */
         xwSetPixelSize(xwGetPaperXSize(),xwGetPaperYSize());
         xwGFXPreview(dpii);
      }
      else
      {
         xwSetZoom(zoom);
         /* Set Pixel Size */
         xwSetPixelSize(xwGetPaperXSize(),xwGetPaperYSize());
      }
   }
   else
   {
      xwDisplayMessage(NULL,xwGR(1,"err.CantDisplayError","No Pictures or Frame available for display !!!"));
   }

   xwSetRealMode();

   return;
}

/* Print */
void xwPrintAssistent(int mo)
{
   int            dpiPixel;
   int            dpiMM;
   int            dpiCount;
   int            dpiAct;

   int            dpis;
   static int     dpi;
   static int     sheets;

   static int     prtfile;

   char           astr[256];
   char           bstr[256];
   float          xwDPI;

   xwUnSetRealMode();

   xwDPI=(25.4*(float) xwMM());

   /* Check Print Driver */
   if ( (strlen(xwGetPrefDriver())>0) && (strlen(xwGetPrefPrinter())>0) && (strlen(xwGetPrefSetting())>0) )
   {
      /* Pictures available for print */
      if ( (xwGetPictureCount()>-1) || (xwGetFrameCount()>-1) )
      {
      
         /* Print Modus with GUI */
         if (mo==0)
         {      
            /* Abort Prining */
            afPrtAbort=0; 
         
            /* get max. DPI */
            dpi=180;
            dpiCount=xwGetPictureCount();
            for (dpiAct=0 ; dpiAct<=dpiCount; dpiAct++)
            {
               dpiPixel=xwGetPictureRW(dpiAct);
               dpiMM=xwGetPictureW(dpiAct);
               dpis=(int) ( (((float) dpiPixel/(float) dpiMM)*xwMM())*25.4);
               if (dpis>dpi) dpi=dpis;
            }
            if (dpi>360) dpi=360;

            if (xwIsPaperLS()==xwPortrait)
            {
               xwGFXLandscape(0);
            }
            else
            {
               xwGFXLandscape(1);
            }

            /* Print in File */
            prtfile=0;

            /* count of prints */
            sheets=1;

            prf.form = NULL;
            prf.ready = 0;

            prf.form = fl_bgn_form(FL_UP_BOX, 400,105+30);
            fl_set_border_width(1);

            prf.printer = fl_add_box(FL_DOWN_BOX,5,5,390,50,"");
            strcpy(astr,xwGetPrefDriver());
            strcat(astr,"\n");
            strcat(astr,xwGetPrefPrinter());
            strcat(astr,"\n");
            strcat(astr,xwGetPrefSetting());
            fl_set_object_label(prf.printer,astr);

            if (xwGetPrefValue(xwgExpert)==0)
            {
               prf.sheets = fl_add_input(FL_INT_INPUT,200,5+55,50,20,xwGR(1,"prtf.Sheets","Count of Copys:"));
               fl_set_input_return(prf.sheets,FL_RETURN_CHANGED);
               sprintf(astr,"%i",sheets);
               fl_set_input(prf.sheets,astr);
   #ifdef xwWhiteInput
               fl_set_object_color(prf.sheets,FL_WHITE,FL_WHITE);
   #endif
            }
            else
            {
               prf.sheets = fl_add_input(FL_INT_INPUT,145,5+55,50,20,xwGR(1,"prtf.Sheets","Count of Copys:"));
               fl_set_input_return(prf.sheets,FL_RETURN_CHANGED);
               sprintf(astr,"%i",sheets);
               fl_set_input(prf.sheets,astr);
   #ifdef xwWhiteInput
               fl_set_object_color(prf.sheets,FL_WHITE,FL_WHITE);
   #endif

               prf.dpiout = fl_add_input(FL_INT_INPUT,345,5+55,50,20,xwGR(1,"prtf,DPI","DPI:"));
               fl_set_input_return(prf.dpiout,FL_RETURN_CHANGED);
               sprintf(astr,"%i",dpi);
               fl_set_input(prf.dpiout,astr);
   #ifdef xwWhiteInput
               fl_set_object_color(prf.dpiout,FL_WHITE,FL_WHITE);
   #endif
            }

            prf.tofile = fl_add_lightbutton(FL_PUSH_BUTTON,5,55+30,100,20,xwGR(1,"prtf.ToFile","Print in File"));
            fl_set_button(prf.tofile,0);

            prf.file = fl_add_box(FL_DOWN_BOX,105,55+30,290,20,xwGetFile("","prtout.png"));

            prf.print = fl_add_button(FL_NORMAL_BUTTON,5,80+30,190,20,xwGR(1,"prtf.OK","Print"));
            prf.cancel = fl_add_button(FL_NORMAL_BUTTON,205,80+30,190,20,xwGR(1,"prtf.Cancel","Cancel"));

            fl_end_form();

            if (xwGetPrefValue(xwgWinPos)==0)
            {
               fl_prepare_form_window(prf.form,FL_PLACE_MOUSE,FL_TRANSIENT,xwGR(1,"prtf.Print","Printing..."));
            }
            else
            {
               fl_prepare_form_window(prf.form,FL_PLACE_CENTER,FL_TRANSIENT,xwGR(1,"prtf.Print","Printing..."));
            }

            fl_set_form_dblbuffer(prf.form,0);
            fl_show_form_window(prf.form);

            fl_set_app_mainform(prf.form);

            /* Exit Handler */
            fl_set_form_atclose(prf.form,nclose_cb,(void *) "1");

            prf.ready=0;
            while (prf.ready==0)
            {
               prf.obj= fl_do_forms();

               /* Exit */
               if (prf.obj==prf.cancel)
               {
                  /* Abort Prining */
                  afPrtAbort=1;
                  
                  prf.ready=1;
               }
               
               /* Sheet */
               else if (prf.obj==prf.sheets)
               {
                  sheets=atoi(fl_get_input(prf.sheets));
                  if (sheets<1)
                  {
                     sheets=1;
                     sprintf(astr,"%i",sheets);
                     fl_set_input(prf.sheets,astr);
                  }
                  if (sheets>50)
                  {
                     sheets=50;
                     sprintf(astr,"%i",sheets);
                     fl_set_input(prf.sheets,astr);
                  }
               }

               /* DPI */
               else if (prf.obj==prf.dpiout)
               {
                  dpi=atoi(fl_get_input(prf.dpiout));
               }

               /* Print In File */
               else if (prf.obj==prf.tofile)
               {
                  prtfile=fl_get_button(prf.tofile);
               }

               /* Print */
               else if (prf.obj==prf.print) prf.ready=-1;
            }

            fl_hide_form(prf.form);
            fl_free_form(prf.form);
            prf.form=NULL;
         }
         else
         {
            prf.ready=-1;
         }

         /* Print Now */
         if (prf.ready==-1)
         {
            if ((int) xwRender(dpi,10,xwGetPaperXB(),xwGetPaperYB())>-1)
            {

               /* Convert PPM->PNG */
               if (prtfile==1)
               {
                  /* Print Now - as PNG File */
                  strcpy(astr,xwGetFile("","prtout.ppm"));
                  strcpy(bstr,xwGetFile("","prtout.png"));
                  xwPrintOut(-1,astr,bstr);
               }
               else
               {
                  /* Print now !!! */
                  strcpy(astr,xwGetFile("","prtout.ppm"));
                  xwPrintOut(sheets,astr,"");
               }

               /*unlink(xwGetFile("","prtout.ppm"));*/
            }
            else
            {
               printf("xwGUI II:Render failure !!!\n");
            }
         }
      }
      else
      {
         xwDisplayMessage(NULL,xwGR(1,"err.CantPrintError","No Pictures or Frame available for output !!!"));
      }
   }
   else
   {
      /* No Printer selected */
      xwDisplayMessage(NULL,xwGR(1,"err.NoPrinterSelected","Can't printing !!!\nYou must select an printer, please."));
   }

   xwSetRealMode();

   return;
}

/* Get Print Flag */
int xwCheckPrintAbort(void)
{
   if (afPrtAbort==1)
   {
      return(xwTrue);  
   }
   
   return(xwFalse);
}

/* Remove Object */
void xwRemoveObject(FL_OBJECT *obj)
{
   fl_hide_object(obj);
   fl_delete_object(obj);
   return;
}

