/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWASSVISITINGCARD_H
#define _XWASSVISITINGCARD_H

#include <forms.h>

#include <strings.h>
#include <unistd.h>

typedef struct assvisitingcardform
{
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *frame;
   
   FL_OBJECT         *frameD;       /* Preview Frame */
   FL_OBJECT         *frameE;       /* Layout */
   
   FL_OBJECT         *vcard01;
   FL_OBJECT         *vcard02;
   FL_OBJECT         *vcard03;
   
   FL_OBJECT         *frameA;
   FL_OBJECT         *frameB;       /* Picture Frame */
   
   FL_OBJECT         *browser;
   FL_OBJECT         *remove;
   FL_OBJECT         *left;
   FL_OBJECT         *right;
   
   FL_OBJECT         *noborder;
   FL_OBJECT         *pictureborder;
   FL_OBJECT         *frameborder;
   
   FL_OBJECT         *frameC;       /* Text Frame */
   
   FL_OBJECT         *title;
   FL_OBJECT         *titleFont;
   FL_OBJECT         *titleCol;
   FL_OBJECT         *name;
   FL_OBJECT         *nameFont;
   FL_OBJECT         *nameCol;

   FL_OBJECT         *visitFont;
   FL_OBJECT         *visitCol;

   FL_OBJECT         *street;
   FL_OBJECT         *city;
   FL_OBJECT         *phone;
   FL_OBJECT         *handy;
   FL_OBJECT         *fax;
   FL_OBJECT         *email;
   FL_OBJECT         *url;
      
   FL_OBJECT         *preview;
   FL_OBJECT         *print;
   FL_OBJECT         *menu;
} assvisitingcardform;

/* Display About Box */
void assVisitingCard(FL_FORM *form);
/* Refreshing GUI */
int assRefreshVisitingCard(XEvent *ev,void *data);
/* Draw VisitingCard */
void assDrawVisitingCard(void);
/* Refresh Handler */
int assVisitingCardHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev);
/* Create Pixmap */
void assVisitingCardCreatePixmap(void);
/* Create Page */
void assVisitingCardPage(void);


#endif