/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ass-visitingcard.h"

#include "assistent.h"
#include "base.h"
#include "color.h"
#include "font.h"
#include "frame.h"
#include "gfx.h"
#include "limits.h"
#include "paper.h"
#include "picture.h"
#include "picbrowser.h"
#include "progress.h"
#include "resource.h"
#include "wysiwyg.h"
#include "x11.h"

#include "pixmaps/as-noborder.xpm"
#include "pixmaps/as-frameborder.xpm"
#include "pixmaps/as-pictureborder.xpm"
#include "pixmaps/as-vcard01.xpm"
#include "pixmaps/as-vcard02.xpm"
#include "pixmaps/as-vcard03.xpm"

static struct assvisitingcardform      af;

static char             afPicture[1024]="";
static int              afPictureFlag=0;
static Pixmap           afPicturePixmap;
static int              afPicturePixmapW,afPicturePixmapH;
static int              afVCFlag=0;
static Pixmap           afVCPixmap;
static int              afRotation=0;
static int              afPaper=1;                                /* Paperorientation 0 - landscape / 1 - portrait */
static int              afBorder=0;

static char             afTitle[256]="";
static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=12;
static int              afTitleFontUnderline=0;
static int              afTitleCol=0;
static char             afName[256]="";
static char             afNameFont[1024]="Courier";
static int              afNameFontSize=10;
static int              afNameFontUnderline=0;
static int              afNameCol=0;

static char             afVisitFont[1024]="Courier";
static int              afVisitFontSize=8;
static int              afVisitFontUnderline=0;
static int              afVisitCol=0;
static char             afStreet[256]="";
static char             afCity[256]="";
static char             afPhone[256]="";
static char             afHandy[156]="";
static char             afFAX[256]="";
static char             afEMail[256]="";
static char             afURL[256]="";

static int              afLayout=0;

static int              assID=0;

/* Handler Lock */
static int              assHandlerLock=0;

static FL_FORM          *assForm;

/* Print Picture GUI */
void assVisitingCard(FL_FORM *form)
{
   char              *strptr;
   int               ypos;

   /* Set Paper in Portrait Mode */
   xwGFXLandscape(0);

   assForm=form;

   afVCFlag=0;

   xwHideAssistent();

   /* Geometry 5 40 680 424 / 7 42 */

   fl_addto_form(assForm);

   fl_set_border_width(1);

   af.frame = fl_add_frame(FL_DOWN_FRAME,5,40,680,424,"");
   fl_set_object_posthandler(af.frame,assVisitingCardHandler);

   /* 8,48,674,164 */
   af.frameD = fl_add_labelframe(FL_DOWN_FRAME,8,48,250,164,xwGR(1,"ass.vcPreview","preview"));

   af.frameE = fl_add_labelframe(FL_DOWN_FRAME,262,48,420,164,xwGR(1,"ass.vcLayout","layout"));

   fl_set_border_width(-2);

   /* 80 x 48 */

   af.vcard01 = fl_add_pixmapbutton(FL_PUSH_BUTTON,264,53,84,52,"");
   fl_set_pixmap_data(af.vcard01,as_vcard01_xpm);
   fl_set_object_color(af.vcard01,FL_BLACK,FL_MCOL);
   fl_set_object_lalign(af.vcard01,FL_ALIGN_LEFT);

   /* +81 */
   af.vcard02= fl_add_pixmapbutton(FL_PUSH_BUTTON,264,106,84,52,"");
   fl_set_pixmap_data(af.vcard02,as_vcard02_xpm);
   fl_set_object_color(af.vcard02,FL_BLACK,FL_MCOL);
   fl_set_object_lalign(af.vcard02,FL_ALIGN_LEFT);

   af.vcard03= fl_add_pixmapbutton(FL_PUSH_BUTTON,264,159,84,52,"");
   fl_set_pixmap_data(af.vcard03,as_vcard03_xpm);
   fl_set_object_color(af.vcard03,FL_BLACK,FL_MCOL);
   fl_set_object_lalign(af.vcard03,FL_ALIGN_LEFT);

   if (afLayout==0)
   {
      fl_set_button(af.vcard01,1);
      fl_set_button(af.vcard02,0);
      fl_set_button(af.vcard03,0);
   }
   else if (afLayout==1)
   {
      fl_set_button(af.vcard01,0);
      fl_set_button(af.vcard02,1);
      fl_set_button(af.vcard03,0);
   }
   else if (afLayout==2)
   {
      fl_set_button(af.vcard01,0);
      fl_set_button(af.vcard02,0);
      fl_set_button(af.vcard03,1);
   }

   fl_set_border_width(1);

   /* 8,48,674,164 */
   af.frameA = fl_add_labelframe(FL_DOWN_FRAME,8,220,335,190,xwGR(1,"ass.PictureFrame","picture settings"));

   af.frameB = fl_add_frame(FL_DOWN_FRAME,11,228,154,154,"");
/*   fl_set_object_posthandler(af.frameB,assVisitingCardHandler); */

   af.browser = fl_add_button(FL_NORMAL_BUTTON,171,228,170,20,xwGR(1,"ass.LoadPicture","load picture"));
   af.remove =  fl_add_button(FL_NORMAL_BUTTON,171,248,170,20,xwGR(1,"ass.RemovePicture","remove picture"));

   af.left = fl_add_button(FL_NORMAL_BUTTON,171,273,170,20,xwGR(1,"ass.RotateLeft","rotate picture in left direction"));
   af.right = fl_add_button(FL_NORMAL_BUTTON,171,293,170,20,xwGR(1,"ass.RotateRight","rotate picture in right direction"));

   fl_set_border_width(-2);

   af.noborder = fl_add_pixmapbutton(FL_PUSH_BUTTON,241,318,30,30,xwGR(1,"ass.Borders","Borders:"));
   fl_set_pixmap_data(af.noborder,as_noborder_xpm);
   fl_set_object_color(af.noborder,FL_BLACK,FL_MCOL);
   fl_set_object_lalign(af.noborder,FL_ALIGN_LEFT);

   af.pictureborder = fl_add_pixmapbutton(FL_PUSH_BUTTON,241+35,318,30,30,"");
   fl_set_pixmap_data(af.pictureborder,as_pictureborder_xpm);
   fl_set_object_color(af.pictureborder,FL_BLACK,FL_MCOL);

   af.frameborder = fl_add_pixmapbutton(FL_PUSH_BUTTON,241+70,318,30,30,"");
   fl_set_pixmap_data(af.frameborder,as_frameborder_xpm);
   fl_set_object_color(af.frameborder,FL_BLACK,FL_MCOL);

   if (afBorder==0)
   {
      fl_set_button(af.noborder,1);
      fl_set_button(af.pictureborder,0);
      fl_set_button(af.frameborder,0);
   }
   else if (afBorder==1)
   {
      fl_set_button(af.noborder,0);
      fl_set_button(af.pictureborder,1);
      fl_set_button(af.frameborder,0);
   }
   else if (afBorder==2)
   {
      fl_set_button(af.noborder,0);
      fl_set_button(af.pictureborder,0);
      fl_set_button(af.frameborder,1);
   }

   fl_set_border_width(1);

   /* 8,220,674,190 */
   af.frameC = fl_add_labelframe(FL_DOWN_FRAME,347,220,335,190,xwGR(1,"ass.TextFrame","text settings"));

   af.title = fl_add_input(FL_NORMAL_INPUT,407,228,190-20,18,xwGR(1,"ass.vcTitles","Title:"));
   af.titleCol = fl_add_button(FL_NORMAL_BUTTON,577,228,20,20,"");
   xwSetRGBC(26,afTitleCol);
   fl_set_object_color(af.titleCol,26,26);
   af.titleFont = fl_add_button(FL_NORMAL_BUTTON,597,228,80,18,xwGR(1,"ass.Font","Font"));
   fl_set_input_maxchars(af.title,255);
   fl_set_input_return(af.title,FL_RETURN_CHANGED);
   fl_set_input(af.title,afTitle);

   af.name = fl_add_input(FL_NORMAL_INPUT,407,247,190-20,18,xwGR(1,"ass.vcName","Name:"));
   af.nameCol = fl_add_button(FL_NORMAL_BUTTON,577,247,20,20,"");
   xwSetRGBC(27,afNameCol);
   fl_set_object_color(af.nameCol,27,27);
   af.nameFont = fl_add_button(FL_NORMAL_BUTTON,597,247,80,18,xwGR(1,"ass.Font","Font"));
   fl_set_input_maxchars(af.name,255);
   fl_set_input_return(af.name,FL_RETURN_CHANGED);
   fl_set_input(af.name,afName);

   ypos=266;
   af.visitFont = fl_add_button(FL_NORMAL_BUTTON,597,ypos,80,126,xwGR(1,"ass.Font","Font"));
   af.visitCol = fl_add_button(FL_NORMAL_BUTTON,577,ypos,20,126,"");
   xwSetRGBC(28,afVisitCol);
   fl_set_object_color(af.visitCol,28,28);
   
   af.street = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcStreet","Street:"));
   fl_set_input_maxchars(af.street,255);
   fl_set_input_return(af.street,FL_RETURN_CHANGED);
   fl_set_input(af.street,afStreet);
   ypos=ypos+18;
   af.city = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcCity","City:"));
   fl_set_input_maxchars(af.city,255);
   fl_set_input_return(af.city,FL_RETURN_CHANGED);
   fl_set_input(af.city,afCity);
   ypos=ypos+18;
   af.phone = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcPhone","Phone:"));
   fl_set_input_maxchars(af.phone,255);
   fl_set_input_return(af.phone,FL_RETURN_CHANGED);
   fl_set_input(af.phone,afPhone);
   ypos=ypos+18;
   af.handy = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcHandy","Handy:"));
   fl_set_input_maxchars(af.handy,255);
   fl_set_input_return(af.handy,FL_RETURN_CHANGED);
   fl_set_input(af.handy,afHandy);
   ypos=ypos+18;
   af.fax = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcFAX","Fax:"));
   fl_set_input_maxchars(af.fax,255);
   fl_set_input_return(af.fax,FL_RETURN_CHANGED);
   fl_set_input(af.fax,afFAX);
   ypos=ypos+18;
   af.email = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcEMail","EMail:"));
   fl_set_input_maxchars(af.email,255);
   fl_set_input_return(af.email,FL_RETURN_CHANGED);
   fl_set_input(af.email,afEMail);
   ypos=ypos+18;
   af.url = fl_add_input(FL_NORMAL_INPUT,407,ypos,190-20,18,xwGR(1,"ass.vcURL","URL:"));
   fl_set_input_maxchars(af.url,255);
   fl_set_input_return(af.url,FL_RETURN_CHANGED);
   fl_set_input(af.url,afURL);

   af.preview = fl_add_button(FL_NORMAL_BUTTON,7,417,224,45,xwGR(1,"ass.Preview","Preview\nPage"));
   fl_set_object_lsize(af.preview,FL_NORMAL_SIZE);
   af.print = fl_add_button(FL_NORMAL_BUTTON,233,417,224,45,xwGR(1,"ass.Print","Print\nPage"));
   fl_set_object_lsize(af.print,FL_NORMAL_SIZE);
   af.menu = fl_add_button(FL_NORMAL_BUTTON,459,417,224,45,xwGR(1,"ass.Menu","Return\nto\nMenu"));
   fl_set_object_lsize(af.menu,FL_NORMAL_SIZE);

   fl_end_form();

   if (strlen(afPicture)>0)
   {
      assVisitingCardCreatePixmap();
   }

   assDrawVisitingCard();

   assID=0;
   af.ready=0;
   while (af.ready==0)
   {
      af.obj=fl_do_forms();

      /* Menu */
      if (af.obj==af.menu)
      {
         /* create page */
         assVisitingCardPage();

         if (afPaper==0)
         {
            xwGFXLandscape(1);
         }
         else
         {
            xwGFXLandscape(0);
         }

         af.ready=-1;
      }

      /* Preview */
      else if (af.obj==af.preview)
      {
         fl_deactivate_form(assForm);

         if (assID>0)
         {
            fl_remove_timeout(assID);
            assID=0;
         }

         /* create page */
         assVisitingCardPage();

         if (afPaper==0)
         {
            xwGFXLandscape(1);
         }
         else
         {
            xwGFXLandscape(0);
         }

         xwPreviewAssistent();

         fl_activate_form(assForm);
      }

      /* Print */
      else if (af.obj==af.print)
      {
         fl_deactivate_form(assForm);

         xwLockProgress();

         /* create page */
         assVisitingCardPage();

         if (afPaper==0)
         {
            xwGFXLandscape(1);
         }
         else
         {
            xwGFXLandscape(0);
         }

         xwPrintAssistent(0);

         xwUnLockProgress();
         xwCloseProgress();
         
         fl_activate_form(assForm);
      }

      /* ########## Layout Settings ########## */
      else if (af.obj==af.vcard01)
      {
         afLayout=0;
         fl_set_button(af.vcard01,1);
         fl_set_button(af.vcard02,0);
         fl_set_button(af.vcard03,0);
      }
      else if (af.obj==af.vcard02)
      {
         afLayout=1;
         fl_set_button(af.vcard01,0);
         fl_set_button(af.vcard02,1);
         fl_set_button(af.vcard03,0);
      }
      else if (af.obj==af.vcard03)
      {
         afLayout=2;
         fl_set_button(af.vcard01,0);
         fl_set_button(af.vcard02,0);
         fl_set_button(af.vcard03,1);
      }

      /* ########## Picture Settings ########## */

      /* browser */
      else if (af.obj==af.browser)
      {
         strptr=xwPictureBrowser(form);
         if ((strptr!=NULL) && (strlen(strptr)<1024) && (strlen(strptr)>0))
         {
            strcpy(afPicture,strptr);

            afRotation=0;

            assVisitingCardCreatePixmap();
         }
      }

      /* remove picture */
      else if (af.obj==af.remove)
      {
         strcpy(afPicture,"");
         afRotation=0;

         /* remove old picture */
         if (afPictureFlag==1) XFreePixmap(fl_display,afPicturePixmap);
         afPictureFlag=0;

         fl_winset(assForm->window);
         fl_rectf(13,230,150,150,FL_COL1);

         /*assVisitingCardCreatePixmap();*/
      }
      /* noborder */
      else if (af.obj==af.noborder)
      {
         afBorder=0;
         fl_set_button(af.noborder,1);
         fl_set_button(af.pictureborder,0);
         fl_set_button(af.frameborder,0);
      }
      /* pictureborder */
      else if (af.obj==af.pictureborder)
      {
         afBorder=1;
         fl_set_button(af.noborder,0);
         fl_set_button(af.pictureborder,1);
         fl_set_button(af.frameborder,0);
      }
      /* frameborder */
      else if (af.obj==af.frameborder)
      {
         afBorder=2;
         fl_set_button(af.noborder,0);
         fl_set_button(af.pictureborder,0);
         fl_set_button(af.frameborder,1);
      }

      /* rotate left */
      else if (af.obj==af.left)
      {
         afRotation=afRotation-90;
         if (afRotation<-180) afRotation=90;

         if (strlen(afPicture)>0) assVisitingCardCreatePixmap();
      }
      /* rotate right */
      else if (af.obj==af.right)
      {
         afRotation=afRotation+90;
         if (afRotation>180) afRotation=-90;

         if (strlen(afPicture)>0) assVisitingCardCreatePixmap();
      }

      /* ########## Text Settings ########## */

      /* Title */
      else if (af.obj==af.title)
      {
         strcpy(afTitle,fl_get_input(af.title));
      }
      /* Title Color */
      else if (af.obj==af.titleCol)
      {
         afTitleCol=xwColorMixer(assForm,26,afTitleCol);
         fl_redraw_object(af.titleCol);      
      }
      /* Title Font */
      else if (af.obj==af.titleFont)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afTitleFont,&afTitleFontSize,&afTitleFontUnderline);

         fl_activate_form(assForm);
      }

      /* Name */
      else if (af.obj==af.name)
      {
         strcpy(afName,fl_get_input(af.name));
      }
      /* Name Color */
      else if (af.obj==af.nameCol)
      {
         afNameCol=xwColorMixer(assForm,27,afNameCol);
         fl_redraw_object(af.nameCol);      
      }
      /* Name Font */
      else if (af.obj==af.nameFont)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afNameFont,&afNameFontSize,&afNameFontUnderline);

         fl_activate_form(assForm);
      }

      /* Visit Font */
      else if (af.obj==af.visitFont)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afVisitFont,&afVisitFontSize,&afVisitFontUnderline);

         fl_activate_form(assForm);
      }
      /* Visit Color */
      else if (af.obj==af.visitCol)
      {
         afVisitCol=xwColorMixer(assForm,28,afVisitCol);
         fl_redraw_object(af.visitCol);      
      }

      /* Street */
      else if (af.obj==af.street)
      {
         strcpy(afStreet,fl_get_input(af.street));
      }

      /* City */
      else if (af.obj==af.city)
      {
         strcpy(afCity,fl_get_input(af.city));
      }

      /* Phone */
      else if (af.obj==af.phone)
      {
         strcpy(afPhone,fl_get_input(af.phone));
      }

      /* Handy */
      else if (af.obj==af.handy)
      {
         strcpy(afHandy,fl_get_input(af.handy));
      }

      /* FAX */
      else if (af.obj==af.fax)
      {
         strcpy(afFAX,fl_get_input(af.fax));
      }

      /* EMail */
      else if (af.obj==af.email)
      {
         strcpy(afEMail,fl_get_input(af.email));
      }

      /* URL */
      else if (af.obj==af.url)
      {
         strcpy(afURL,fl_get_input(af.url));
      }

      if (assID>0)
      {
         fl_remove_timeout(assID);
         assID=0;
      }
      assID=fl_add_timeout(1500,assRefreshVisitingCard,0);
   }

   if (assID>0)
   {
      fl_remove_timeout(assID);
      assID=0;
   }

   xwRemoveObject(af.frame);
   xwRemoveObject(af.frameD);
   xwRemoveObject(af.frameE);
   xwRemoveObject(af.vcard01);
   xwRemoveObject(af.vcard02);
   xwRemoveObject(af.vcard03);
   
   xwRemoveObject(af.frameA);
   xwRemoveObject(af.frameB);
   xwRemoveObject(af.browser);
   xwRemoveObject(af.remove);
   xwRemoveObject(af.left);
   xwRemoveObject(af.right);
   xwRemoveObject(af.noborder);
   xwRemoveObject(af.pictureborder);
   xwRemoveObject(af.frameborder);
   
   xwRemoveObject(af.frameC);
   xwRemoveObject(af.title);
   xwRemoveObject(af.titleCol);
   xwRemoveObject(af.titleFont);
   xwRemoveObject(af.name);
   xwRemoveObject(af.nameCol);
   xwRemoveObject(af.nameFont);
   xwRemoveObject(af.visitFont);
   xwRemoveObject(af.visitCol);
   xwRemoveObject(af.street);
   xwRemoveObject(af.city);
   xwRemoveObject(af.phone);
   xwRemoveObject(af.handy);
   xwRemoveObject(af.fax);
   xwRemoveObject(af.email);
   xwRemoveObject(af.url);
   
   xwRemoveObject(af.preview);
   xwRemoveObject(af.print);
   xwRemoveObject(af.menu);

   /* clear panel */
   fl_winset(assForm->window);
   fl_rectf(7,42,676,420,FL_COL1);

   /* remove old picture */
   if (afPictureFlag==1)
   {
      XFreePixmap(fl_display,afPicturePixmap);
      afPictureFlag=0;
   }

   /* remove old picture */
   if (afVCFlag==1)
   {
      XFreePixmap(fl_display,afVCPixmap);
   }
   afVCFlag=-1;

   xwShowAssistent();

   return;
}


/* Refreshing GUI */
int assRefreshVisitingCard(XEvent *ev,void *data)
{
   assDrawVisitingCard();

   return(0);
}

/* Draw VisitingCard */
void assDrawVisitingCard(void)
{
   float             dpi;
   int               az;
   int               pixel;
   int               sizeA,sizeB,sizeC;
   int               VerticalLimit;

   int               xpos,ypos;
   int               xsize,ysize;
   int               xpsize,ypsize;
   float             factor;

   char              astr[1024];

   fl_winset(assForm->window);

   /* 86 mm x 54 mm        */
   dpi=(((float) 247/(float) 85)*(float) 25.4);

  /* Count of Adress lines */
   az=0;
   /*if (strlen(afTitle)>0) az++;*/
   if (strlen(afName)>0) az++;
   if (strlen(afStreet)>0) az++;
   if (strlen(afCity)>0) az++;
   if (strlen(afPhone)>0) az++;
   if (strlen(afHandy)>0) az++;
   if (strlen(afFAX)>0) az++;
   if (strlen(afEMail)>0) az++;
   if (strlen(afURL)>0) az++;

   /* Check Text Size */
   if (xwRenderText(xwGetFontID(afTitleFont),afTitleFontSize,360,afTitleFontUnderline,"ABC")==xwTrue)
   {
      pixel=xwGFXGetPictureY();
      xwGFXRemovePicture();
      sizeA=(int) ( ((float) pixel/360)*(25.4*(float) xwMM()) );
      sizeA=(int) (((float) sizeA/25.4)*dpi)/xwMM();
   }
   if (xwRenderText(xwGetFontID(afNameFont),afNameFontSize,360,afNameFontUnderline,"ABC")==xwTrue)
   {
      pixel=xwGFXGetPictureY();
      xwGFXRemovePicture();
      sizeB=(int) ( ((float) pixel/360)*(25.4*(float) xwMM()) );
      sizeB=(int) (((float) sizeB/25.4)*dpi)/xwMM();
   }
   if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,360,afVisitFontUnderline,"ABC")==xwTrue)
   {
      pixel=xwGFXGetPictureY();
      xwGFXRemovePicture();
      sizeC=(int) ( ((float) pixel/360)*(25.4*(float) xwMM()) );
      sizeC=(int) (((float) sizeC/25.4)*dpi)/xwMM();
   }

   VerticalLimit=0;
   if (strlen(afTitle)>0) VerticalLimit=VerticalLimit+sizeA;
   if (strlen(afName)>0) VerticalLimit=VerticalLimit+sizeB;
   if (az>0) VerticalLimit=VerticalLimit+(sizeC*az);

   if (VerticalLimit<155)
   {
      /* create paper */
      if (xwGFXCreatePaper(247,155)==xwTrue)
      {

         if (afLayout==0)
         {
            /* picture */
            if (xwExist(afPicture)==xwTrue)
            {
               xpos=( (int) (((float) 59/25.4)*dpi));
               ypos=( (int) (((float) 2/25.4)*dpi));
               xsize=( (int) (((float) 25/25.4)*dpi));
               ysize=( (int) (((float) 50/25.4)*dpi));

               if (xwGFXCreateTemp(xsize,ysize)==xwTrue)
               {

                  if (afBorder==2)
                  {
                     xwGFXDrawBorder(memTemp,( (int) (((float) assBorderline/25.4)*dpi)),0,0,0);
                     /*
                     xpos=xpos+( (int) (((float) assBordersize/25.4)*dpi));
                     ypos=ypos+( (int) (((float) assBordersize/25.4)*dpi));
                     */
                     xsize=xsize-(( (int) (((float) assBordersize/25.4)*dpi))*2);
                     ysize=ysize-(( (int) (((float) assBordersize/25.4)*dpi))*2);
                  }

                  xwGFXSaveTemp();

                  /* Create Pixmap */
                  strcpy(astr,xwGetRealPicture(afPicture));
                  if (xwGFXImport(astr,xwGetFile("","import.ppm"))==xwTrue)
                  {
                     if (xwGFXLoadPicture(xwGetFile("","import.ppm"))==xwTrue)
                     {
                        if ((afRotation==-90) || (afRotation==90))
                        {
                           factor=(float) xwGFXGetPictureX()/(float) xwGFXGetPictureY();

                           /* Height */
                           if (ysize/factor>xsize)
                           {
                              xpsize=(int) (xsize*factor);
                              ypsize=xsize;
                           }
                           else
                           {
                              xpsize=ysize;
                              ypsize=(int) (ysize/factor);
                           }
                        }
                        else
                        {
                           /* 0 - 180 - -180 */

                           factor=(float) xwGFXGetPictureX()/(float) xwGFXGetPictureY();

                           /* Height */
                           if (xsize/factor>ysize)
                           {
                              xpsize=(int) (ysize*factor);
                              ypsize=ysize;
                           }
                           else
                           {
                              xpsize=xsize;
                              ypsize=(int) (xsize/factor);
                           }
                        }

                        xwGFXScalePicture(memPicture,createTemp,0,0,xpsize,ypsize,afRotation);

                        if (afBorder==1)
                        {
                           xwGFXDrawBorder(memPicture,( (int) (((float) assBordersize/25.4)*dpi)),255,255,255);
                           xwGFXDrawBorder(memPicture,( (int) (((float) assBorderline/25.4)*dpi)),0,0,0);
                        }

                        xwGFXLoadTemp();

                        if (afBorder==2)
                        {
                           xwGFXCopyPicture(memPicture,memTemp,(( (int) (((float) assBordersize/25.4)*dpi))+xsize)-xwGFXGetPictureX(),( (int) (((float) assBordersize/25.4)*dpi)));
                        }
                        else
                        {
                           xwGFXCopyPicture(memPicture,memTemp,(xsize-xwGFXGetPictureX()),0);
                        }

                        xwGFXRemovePicture();

                        xwGFXCopyPicture(memTemp,memPaper,xpos,ypos);
                        xwGFXRemoveTemp();

                        unlink(xwGetFile("","import.ppm"));
                     }
                  }
               }
            }

            xwGFXIgnorePaper(1);

            /* adress */
            if (az>0)
            {
               ypos=155-(az*sizeC)-( (int) (((float) 4/25.4)*dpi));
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afVisitCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));
                           
               if (strlen(afStreet)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afStreet)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afCity)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afCity)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afPhone)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afPhone)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afHandy)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afHandy)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afFAX)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afFAX)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
               if (strlen(afEMail)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afEMail)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
               if (strlen(afURL)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afURL)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
            }

            /* name */
            if (strlen(afName)>0)
            {
               ypos=155-(az*sizeC)-( (int) (((float) 4/25.4)*dpi))-sizeB;
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afNameCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));
 

               if (xwRenderText(xwGetFontID(afNameFont),afNameFontSize,dpi,afNameFontUnderline,afName)==xwTrue)
               {
                  xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                  xwGFXRemovePicture();
               }
            }

            /* titel */
            if (strlen(afTitle)>0)
            {
               ypos=( (int) (((float) 4/25.4)*dpi));
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afTitleCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));
 
               if (xwRenderText(xwGetFontID(afTitleFont),afTitleFontSize,dpi,afTitleFontUnderline,afTitle)==xwTrue)
               {
                  xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                  xwGFXRemovePicture();
               }
            }
            
            xwGFXIgnorePaper(0);
         }
         else if (afLayout==1)
         {
            xwGFXIgnorePaper(1);
            
            /* adress */
            if (az>0)
            {
               ypos=155-(az*sizeC)-( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afVisitCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));
 
               if (strlen(afStreet)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afStreet)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afCity)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afCity)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afPhone)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afPhone)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afHandy)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afHandy)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afFAX)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afFAX)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
               if (strlen(afEMail)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afEMail)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
               if (strlen(afURL)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afURL)==xwTrue)
                  {
                     xpos=(247-xwGFXGetPictureX())/2;
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
            }

            /* name */
            if (strlen(afName)>0)
            {
               ypos=155-(az*sizeC)-( (int) (((float) 4/25.4)*dpi))-sizeB;
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afNameCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));

               if (xwRenderText(xwGetFontID(afNameFont),afNameFontSize,dpi,afNameFontUnderline,afName)==xwTrue)
               {
                  xpos=(247-xwGFXGetPictureX())/2;
                  xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                  xwGFXRemovePicture();
               }
            }

            /* titel */
            if (strlen(afTitle)>0)
            {
               ypos=( (int) (((float) 4/25.4)*dpi));
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afTitleCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));

               if (xwRenderText(xwGetFontID(afTitleFont),afTitleFontSize,dpi,afTitleFontUnderline,afTitle)==xwTrue)
               {
                  xpos=(247-xwGFXGetPictureX())/2;
                  xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                  xwGFXRemovePicture();
               }
            }
            xwGFXIgnorePaper(0);
         }
         else if (afLayout==2)
         {
            /* picture */
            if (xwExist(afPicture)==xwTrue)
            {
               xpos=( (int) (((float) 45/25.4)*dpi));
               ypos=( (int) (((float) 2/25.4)*dpi));
               xsize=( (int) (((float) 39/25.4)*dpi));
               ysize=( (int) (((float) 23/25.4)*dpi));

               if (xwGFXCreateTemp(xsize,ysize)==xwTrue)
               {

                  if (afBorder==2)
                  {
                     xwGFXDrawBorder(memTemp,( (int) (((float) assBorderline/25.4)*dpi)),0,0,0);
                     /*
                     xpos=xpos+( (int) (((float) assBordersize/25.4)*dpi));
                     ypos=ypos+( (int) (((float) assBordersize/25.4)*dpi));
                     */
                     xsize=xsize-(( (int) (((float) assBordersize/25.4)*dpi))*2);
                     ysize=ysize-(( (int) (((float) assBordersize/25.4)*dpi))*2);
                  }

                  xwGFXSaveTemp();

                  /* Create Pixmap */
                  if (xwGFXImport(afPicture,xwGetFile("","import.ppm"))==xwTrue)
                  {
                     if (xwGFXLoadPicture(xwGetFile("","import.ppm"))==xwTrue)
                     {
                        if ((afRotation==-90) || (afRotation==90))
                        {
                           factor=(float) xwGFXGetPictureX()/(float) xwGFXGetPictureY();

                           /* Height */
                           if (ysize/factor>xsize)
                           {
                              xpsize=(int) (xsize*factor);
                              ypsize=xsize;
                           }
                           else
                           {
                              xpsize=ysize;
                              ypsize=(int) (ysize/factor);
                           }
                        }
                        else
                        {
                           /* 0 - 180 - -180 */

                           factor=(float) xwGFXGetPictureX()/(float) xwGFXGetPictureY();

                           /* Height */
                           if (xsize/factor>ysize)
                           {
                              xpsize=(int) (ysize*factor);
                              ypsize=ysize;
                           }
                           else
                           {
                              xpsize=xsize;
                              ypsize=(int) (xsize/factor);
                           }
                        }

                        xwGFXScalePicture(memPicture,createTemp,0,0,xpsize,ypsize,afRotation);

                        if (afBorder==1)
                        {
                           xwGFXDrawBorder(memPicture,( (int) (((float) assBordersize/25.4)*dpi)),255,255,255);
                           xwGFXDrawBorder(memPicture,( (int) (((float) assBorderline/25.4)*dpi)),0,0,0);
                        }

                        xwGFXLoadTemp();

                        if (afBorder==2)
                        {
                           xwGFXCopyPicture(memPicture,memTemp,(( (int) (((float) assBordersize/25.4)*dpi))+xsize)-xwGFXGetPictureX(),( (int) (((float) assBordersize/25.4)*dpi)));
                        }
                        else
                        {
                           xwGFXCopyPicture(memPicture,memTemp,(xsize-xwGFXGetPictureX()),0);
                        }

                        xwGFXRemovePicture();

                        xwGFXCopyPicture(memTemp,memPaper,xpos,ypos);
                        xwGFXRemoveTemp();

                        unlink(xwGetFile("","import.ppm"));
                     }
                  }
               }
            }

            xwGFXIgnorePaper(1);

            /* adress */
            if (az>0)
            {
               xpos=( (int) (((float) 4/25.4)*dpi));
               ypos=78-(2*sizeC)-( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afVisitCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));

               if (strlen(afStreet)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afStreet)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afCity)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afCity)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }

               xpos=( (int) (((float) 43/25.4)*dpi));
               ypos=78+( (int) (((float) 2/25.4)*dpi));
               if (strlen(afPhone)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afPhone)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afHandy)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afHandy)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }
               }
               if (strlen(afFAX)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afFAX)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
               if (strlen(afEMail)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afEMail)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
               if (strlen(afURL)>0)
               {
                  if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,dpi,afVisitFontUnderline,afURL)==xwTrue)
                  {
                     xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                     ypos=ypos+sizeC;
                     xwGFXRemovePicture();
                  }

               }
            }

            /* name */
            if (strlen(afName)>0)
            {
               ypos=78-(2*sizeC)-( (int) (((float) 6/25.4)*dpi))-sizeB;
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afNameCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));

               if (xwRenderText(xwGetFontID(afNameFont),afNameFontSize,dpi,afNameFontUnderline,afName)==xwTrue)
               {
                  xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                  xwGFXRemovePicture();
               }
            }

            /* titel */
            if (strlen(afTitle)>0)
            {
               ypos=( (int) (((float) 40/25.4)*dpi));
               xpos=( (int) (((float) 4/25.4)*dpi));

               xwSplitRGBV(afTitleCol);
               xwGFXSetTextColor(xwGetRGBSV(getRed),xwGetRGBSV(getGreen),xwGetRGBSV(getBlue));

               if (xwRenderText(xwGetFontID(afTitleFont),afTitleFontSize,dpi,afTitleFontUnderline,afTitle)==xwTrue)
               {
                  xwGFXCopyPicture(memPicture,memPaper,xpos,ypos);

                  xwGFXRemovePicture();
               }
            }
            
            xwGFXIgnorePaper(0);
            
         }

         /* remove old picture */
         if (afVCFlag==1)
         {
            XFreePixmap(fl_display,afVCPixmap);
            afVCFlag=0;
         }

         if (afVCFlag>-1)
         {
            afVCPixmap=xwGFXCreatePixmap(memPaper);
            if (afVCPixmap!=-1)
            {
               /* VisitingCard Preview */
               fl_rect(9,55,247,155,FL_BLACK);
               XCopyArea(fl_display,afVCPixmap,assForm->window,fl_get_gc(),0,0,246,154,10,56);
               afVCFlag=1;
               assID=0;
            }
         }

         xwGFXRemovePaper();
      }
   }

   return;
}

/* Refresh Handler */
int assVisitingCardHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev)
{
   if (assHandlerLock==0)
   {
      assHandlerLock=1;

      if (event==FL_DRAW)
      {
         /* Picture View */
         fl_winset(assForm->window);
         fl_rectf(13,230,150,150,FL_COL1);
         if (afPictureFlag!=0)
         {
            XCopyArea(fl_display,afPicturePixmap,assForm->window,fl_get_gc(),0,0,afPicturePixmapW,afPicturePixmapH,13+((150-afPicturePixmapW)/2),230+((150-afPicturePixmapH)/2));
         }

         if (afVCFlag!=0)
         {
            /* VisitingCard Preview */
            fl_rect(9,55,247,155,FL_BLACK);
            XCopyArea(fl_display,afVCPixmap,assForm->window,fl_get_gc(),0,0,246,154,10,56);
         }
      }

      assHandlerLock=0;
   }

   return(0);
}

/* Create Pixmap */
void assVisitingCardCreatePixmap(void)
{
   float             factor;
   char              astr[1024];

   /* remove old picture */
   if (afPictureFlag==1)
   {
      XFreePixmap(fl_display,afPicturePixmap);
      afPictureFlag=0;
   }

   /* Create Pixmap */
   strcpy(astr,xwGetRealPicture(afPicture));
   if (xwGFXImport(astr,xwGetFile("","import.ppm"))==xwTrue)
   {
      if (xwGFXLoadPicture(xwGetFile("","import.ppm"))==xwTrue)
      {
         afPicturePixmapW=xwGFXGetPictureX();
         afPicturePixmapH=xwGFXGetPictureY();

         factor=(float) afPicturePixmapW/(float) afPicturePixmapH;

         /* Height */
         if (150/factor>150)
         {
            afPicturePixmapW=(int) (150*factor);
            afPicturePixmapH=150;
         }
         else
         {
            afPicturePixmapW=150;
            afPicturePixmapH=(int) (150/factor);
         }

         xwGFXScalePicture(memPicture,createTemp,0,0,afPicturePixmapW,afPicturePixmapH,afRotation);

         afPicturePixmap=xwGFXCreatePixmap(memPicture);
         if (afPicturePixmap!=-1)
         {
            afPicturePixmapW=xwGFXGetPictureX();
            afPicturePixmapH=xwGFXGetPictureY();

            fl_winset(assForm->window);
            fl_rectf(13,230,150,150,FL_COL1);
            XCopyArea(fl_display,afPicturePixmap,assForm->window,fl_get_gc(),0,0,afPicturePixmapW,afPicturePixmapH,13+((150-afPicturePixmapW)/2),230+((150-afPicturePixmapH)/2));
            afPictureFlag=1;

         }
         xwGFXRemovePicture();
      }
      unlink(xwGetFile("","import.ppm"));
   }

   return;
}

/* Create Page */
void assVisitingCardPage(void)
{
   int               ax,ay,bx,by;   /* Count of Cards */
   int               az;            /* Line of Adress */
   int               rot;

   int               pixel;
   int               sizeA,sizeB,sizeC;
   int               VerticalLimit;

   char              adress[2048];

   fl_set_cursor(assForm->window,XC_watch);

   /* remove all frames */
   xwFreeFrames(-1);
   xwFreePicture(-1);

   /* Portrait */
   xwSetPaperLS(xwPortrait);

   /* CARD SIZE            */
   /*                      */
   /* 86 mm x 54 mm        */
   /*                      */

   /* Count of Cards */
   ax=( (float) (xwGetPaperXSize()-(xwGetPaperLB()+xwGetPaperRB())) )/ ( (float) (88*xwMM()) );
   ay=( (float) (xwGetPaperYSize()-(xwGetPaperTB()+xwGetPaperBB())) )/ ( (float) (56*xwMM()) );

   /* Count of Adress lines */
   az=0;
   /*if (strlen(afTitle)>0) az++;*/
   if (strlen(afName)>0) az++;
   if (strlen(afStreet)>0) az++;
   if (strlen(afCity)>0) az++;
   if (strlen(afPhone)>0) az++;
   if (strlen(afHandy)>0) az++;
   if (strlen(afFAX)>0) az++;
   if (strlen(afEMail)>0) az++;
   if (strlen(afURL)>0) az++;

   /* Check Text Size */
   if (xwRenderText(xwGetFontID(afTitleFont),afTitleFontSize,360,afTitleFontUnderline,xwfFontTest)==xwTrue)
   {
      pixel=xwGFXGetPictureY()+5;
      xwGFXRemovePicture();
      sizeA=(int) (( ((float) pixel/360)*(25.4*(float) xwMM()) )+0.5);
   }
   if (xwRenderText(xwGetFontID(afNameFont),afNameFontSize,360,afNameFontUnderline,xwfFontTest)==xwTrue)
   {
      pixel=xwGFXGetPictureY()+5;
      xwGFXRemovePicture();
      sizeB=(int) (( ((float) pixel/360)*(25.4*(float) xwMM()) )+0.5);
   }
   if (xwRenderText(xwGetFontID(afVisitFont),afVisitFontSize,360,afVisitFontUnderline,xwfFontTest)==xwTrue)
   {
      pixel=xwGFXGetPictureY()+5;
      xwGFXRemovePicture();
      sizeC=(int) (( ((float) pixel/360)*(25.4*(float) xwMM()) )+0.5);
   }

   VerticalLimit=0;
   if (strlen(afTitle)>0) VerticalLimit=VerticalLimit+sizeA;
   if (strlen(afName)>0) VerticalLimit=VerticalLimit+sizeB;
   if (az>0) VerticalLimit=VerticalLimit+(sizeC*az);

   if (VerticalLimit<54*xwMM())
   {
      for (by=0 ; by<ay ; by++)
      {
         for (bx=0 ; bx<ax ; bx++)
         {
            /* Visitcard Frame */
            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM())),xwGetPaperTB()+(by*(56*xwMM())),86*xwMM(),54*xwMM());
            xwSetFrameB(xwGetFrameCount(),0);
            xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
            xwSetFrameC(xwGetFrameCount(),0);

            if (afLayout==0)
            {
               /* Picture Datas */
               if (xwExist(afPicture)==xwTrue)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM())) +(59*xwMM()),xwGetPaperTB()+(by*(56*xwMM())) +(2*xwMM()),25*xwMM(),50*xwMM());
                  xwSetPicPosition(xwGetFrameCount(),frmNEPos);
                  xwFPLoad(afPicture);
                  rot=afRotation;

                  /* rotateLeft rotateRight */
                  rot=rot; /*-90;*/
                  if (rot<-180) rot=90;

                  if ((rot==-180) || (rot==180))
                  {
                     xwRotatePicInFrame(rotateLeft);
                     xwRotatePicInFrame(rotateLeft);
                  }
                  else if (rot==-90)
                  {
                     xwRotatePicInFrame(rotateLeft);
                  }
                  else if (rot==90)
                  {
                     xwRotatePicInFrame(rotateRight);
                  }

                  /* Picture Borders */
                  if (afBorder==1)
                  {
                     xwSetFramePB(xwGetFrameCount(),assBordersize);
                     xwSetFramePF(xwGetFrameCount(),assBorderline);
                     xwSetFramePC(xwGetFrameCount(),0);
                  }
                  /* Frame Border */
                  else if (afBorder==2)
                  {
                     xwSetFrameB(xwGetFrameCount(),assBordersize);
                     xwSetFrameF(xwGetFrameCount(),assBorderline);
                     xwSetFrameC(xwGetFrameCount(),0);
                  }
               }

               /* adress */
               if (az>0)
               {
                  strcpy(adress,"");
                  if (strlen(afStreet)>0)
                  {
                     strcat(adress,afStreet);
                     strcat(adress,"\n");
                  }
                  if (strlen(afCity)>0)
                  {
                     strcat(adress,afCity);
                     strcat(adress,"\n");
                  }
                  if (strlen(afPhone)>0)
                  {
                     strcat(adress,afPhone);
                     strcat(adress,"\n");
                  }
                  if (strlen(afHandy)>0)
                  {
                     strcat(adress,afHandy);
                     strcat(adress,"\n");
                  }
                  if (strlen(afFAX)>0)
                  {
                     strcat(adress,afFAX);
                     strcat(adress,"\n");
                  }
                  if (strlen(afEMail)>0)
                  {
                     strcat(adress,afEMail);
                     strcat(adress,"\n");
                  }
                  if (strlen(afURL)>0)
                  {
                     strcat(adress,afURL);
                  }

                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+( (54*xwMM())-((sizeC*az)+(2*xwMM())) ),76*xwMM(),(sizeC)*az);
                  xwSetFontName(xwGetFrameCount(),afVisitFont);
                  xwSetFontSize(xwGetFrameCount(),afVisitFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),adress);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afVisitCol);
               }

               /* name */
               if (strlen(afName)>0)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+( (54*xwMM())-((sizeC*az)+ sizeB +(3*xwMM())) ),76*xwMM(),sizeB);
                  xwSetFontName(xwGetFrameCount(),afNameFont);
                  xwSetFontSize(xwGetFrameCount(),afNameFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),afName);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afNameCol);
               }

               /* titel */
               if (strlen(afTitle)>0)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+(4*xwMM()),76*xwMM(),sizeA);
                  xwSetFontName(xwGetFrameCount(),afTitleFont);
                  xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),afTitle);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afTitleCol);
               }
            }
            else if (afLayout==1)
            {
               /* adress */
               if (az>0)
               {
                  strcpy(adress,"");
                  if (strlen(afStreet)>0)
                  {
                     strcat(adress,afStreet);
                     strcat(adress,"\n");
                  }
                  if (strlen(afCity)>0)
                  {
                     strcat(adress,afCity);
                     strcat(adress,"\n");
                  }
                  if (strlen(afPhone)>0)
                  {
                     strcat(adress,afPhone);
                     strcat(adress,"\n");
                  }
                  if (strlen(afHandy)>0)
                  {
                     strcat(adress,afHandy);
                     strcat(adress,"\n");
                  }
                  if (strlen(afFAX)>0)
                  {
                     strcat(adress,afFAX);
                     strcat(adress,"\n");
                  }
                  if (strlen(afEMail)>0)
                  {
                     strcat(adress,afEMail);
                     strcat(adress,"\n");
                  }
                  if (strlen(afURL)>0)
                  {
                     strcat(adress,afURL);
                  }

                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+( (54*xwMM())-((sizeC*az)+(2*xwMM())) ),76*xwMM(),(sizeC)*az);
                  xwSetFontName(xwGetFrameCount(),afVisitFont);
                  xwSetFontSize(xwGetFrameCount(),afVisitFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),adress);
                  xwSetFontMode(xwGetFrameCount(),1);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afVisitCol);
               }

               /* name */
               if (strlen(afName)>0)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+( (54*xwMM())-((sizeC*az)+ sizeB +(3*xwMM())) ),76*xwMM(),sizeB);
                  xwSetFontName(xwGetFrameCount(),afNameFont);
                  xwSetFontSize(xwGetFrameCount(),afNameFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),afName);
                  xwSetFontMode(xwGetFrameCount(),1);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afNameCol);
               }

               /* titel */
               if (strlen(afTitle)>0)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+(4*xwMM()),76*xwMM(),sizeA);
                  xwSetFontName(xwGetFrameCount(),afTitleFont);
                  xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),afTitle);
                  xwSetFontMode(xwGetFrameCount(),1);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afTitleCol);
               }
            }
            else if (afLayout==2)
            {
               /* Picture Datas */
               if (xwExist(afPicture)==xwTrue)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM())) +(45*xwMM()),xwGetPaperTB()+(by*(56*xwMM())) +(2*xwMM()),39*xwMM(),23*xwMM());
                  xwSetPicPosition(xwGetFrameCount(),frmNEPos);
                  xwFPLoad(afPicture);
                  rot=afRotation;

                  /* rotateLeft rotateRight */
                  rot=rot; /*-90;*/
                  if (rot<-180) rot=90;

                  if ((rot==-180) || (rot==180))
                  {
                     xwRotatePicInFrame(rotateLeft);
                     xwRotatePicInFrame(rotateLeft);
                  }
                  else if (rot==-90)
                  {
                     xwRotatePicInFrame(rotateLeft);
                  }
                  else if (rot==90)
                  {
                     xwRotatePicInFrame(rotateRight);
                  }

                  /* Picture Borders */
                  if (afBorder==1)
                  {
                     xwSetFramePB(xwGetFrameCount(),assBordersize);
                     xwSetFramePF(xwGetFrameCount(),assBorderline);
                     xwSetFramePC(xwGetFrameCount(),0);
                  }
                  /* Frame Border */
                  else if (afBorder==2)
                  {
                     xwSetFrameB(xwGetFrameCount(),assBordersize);
                     xwSetFrameF(xwGetFrameCount(),assBorderline);
                     xwSetFrameC(xwGetFrameCount(),0);
                  }
               }

               /* adress */
               if (az>0)
               {
                  strcpy(adress,"");
                  if (strlen(afStreet)>0)
                  {
                     strcat(adress,afStreet);
                     strcat(adress,"\n");
                  }
                  if (strlen(afCity)>0)
                  {
                     strcat(adress,afCity);
                     strcat(adress,"\n");
                  }
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM())) +(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+ ( (27*xwMM())-((sizeC*2)+(2*xwMM())) ),39*xwMM(),(sizeC)*2);
                  xwSetFontName(xwGetFrameCount(),afVisitFont);
                  xwSetFontSize(xwGetFrameCount(),afVisitFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),adress);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afVisitCol);

                  strcpy(adress,"");
                  az=0;
                  if (strlen(afPhone)>0)
                  {
                     strcat(adress,afPhone);
                     strcat(adress,"\n");
                     az++;
                  }
                  if (strlen(afHandy)>0)
                  {
                     strcat(adress,afHandy);
                     strcat(adress,"\n");
                     az++;
                  }
                  if (strlen(afFAX)>0)
                  {
                     strcat(adress,afFAX);
                     strcat(adress,"\n");
                     az++;
                  }
                  if (strlen(afEMail)>0)
                  {
                     strcat(adress,afEMail);
                     strcat(adress,"\n");
                     az++;
                  }
                  if (strlen(afURL)>0)
                  {
                     strcat(adress,afURL);
                     az++;
                  }

                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(43*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+( (27*xwMM())+(2*xwMM()) ),42*xwMM(),sizeC*az);
                  xwSetFontName(xwGetFrameCount(),afVisitFont);
                  xwSetFontSize(xwGetFrameCount(),afVisitFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),adress);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afVisitCol);
               }

               /* name */
               if (strlen(afName)>0)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM())) +(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+ ( (27*xwMM())-((sizeC*2)+(6*xwMM())) ),39*xwMM(),sizeB);
                  xwSetFontName(xwGetFrameCount(),afNameFont);
                  xwSetFontSize(xwGetFrameCount(),afNameFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),afName);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afNameCol);
               }

               /* titel */
               if (strlen(afTitle)>0)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xwGetPaperLB()+(bx*(88*xwMM()))+(4*xwMM()),xwGetPaperTB()+(by*(56*xwMM()))+(40*xwMM()),39*xwMM(),sizeA);
                  xwSetFontName(xwGetFrameCount(),afTitleFont);
                  xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  xwSetFontText(xwGetFrameCount(),afTitle);
                  xwSetFontMode(xwGetFrameCount(),0);
                  xwSetFrameBC(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afTitleCol);
               }
            }



         }
      }
   }

   fl_set_cursor(assForm->window,FL_DEFAULT_CURSOR);

   return;
}
