/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ass-pref.h"

#include "assistent.h"
#include "base.h"
#include "default.h"
#include "fileselect.h"
#include "font.h"
#include "frame.h"
#include "gfx.h"
#include "limits.h"
#include "paper.h"
#include "pbcache.h"
#include "picbrowser.h"
#include "pref_paper.h"
#include "pref_printer.h"
#include "pref_xwgui.h"
#include "resource.h"
#include "variable.h"
#include "wysiwyg.h"
#include "x11.h"

static struct assprefform      af;

/* Handler Lock */
static int              assHandlerLock=0;

static FL_FORM          *assForm;

static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=17;
static int              afTitleFontUnderline=0;

/* Pref GUI */
void assPref(FL_FORM *form)
{
   char              astr[1024],bstr[1024],cstr[1024];
   char              filename[1024];

   assForm=form;

   xwHideAssistent();

   /* Geometry 5 40 680 424 / 7 42 */

   fl_addto_form(form);

   fl_set_border_width(1);
   
   af.paperpref = fl_add_button(FL_NORMAL_BUTTON,7,43,676,60,xwGR(1,"ass.prefPaper","Paper\nSettings"));
   fl_set_object_lsize(af.paperpref,FL_NORMAL_SIZE);

   af.xwguipref = fl_add_button(FL_NORMAL_BUTTON,7,104,676,60,xwGR(1,"ass.prefXWGUI","xwGUI\nSettings"));
   fl_set_object_lsize(af.xwguipref,FL_NORMAL_SIZE);
   
   af.printerpref = fl_add_button(FL_NORMAL_BUTTON,7,165,676,60,xwGR(1,"ass.prefPrinter","Printer\nSettings"));
   fl_set_object_lsize(af.printerpref,FL_NORMAL_SIZE);
   
   af.pbcache = fl_add_button(FL_NORMAL_BUTTON,7,228,676,60,xwGR(1,"ass.prefPBCache","Convert Pictures for Picture Cache.\nThis increase the Speed of xwGUI."));
   fl_set_object_lsize(af.pbcache,FL_NORMAL_SIZE);
   
   af.font = fl_add_button(FL_NORMAL_BUTTON,7,289,676,60,xwGR(1,"ass.prefFont","Font\nSettings"));
   
   af.menu = fl_add_button(FL_NORMAL_BUTTON,7,413,676,50,xwGR(1,"ass.Menu","Return\nto\nMenu"));
   fl_set_object_lsize(af.menu,FL_NORMAL_SIZE);

   fl_end_form();

   af.ready=0;
   while (af.ready==0)
   {
      af.obj=fl_do_forms();

      /* Menu */
      if (af.obj==af.menu)
      {
         af.ready=-1;
      }

      /* Paper Pref */
      else if (af.obj==af.paperpref)
      {
         fl_deactivate_form(assForm);
         if (strcmp(xwGetVarDef("LOCKPAPER"),"ON") != 0)
         {
            xwPrefPaperSetup();
         }
         else
         {
            xwPrefPrinterSetup();
         }
         fl_activate_form(assForm);
      }
      
      /* xwGUI Pref */
      else if (af.obj==af.xwguipref)
      {
         fl_deactivate_form(assForm);
         xwPrefxwGUISetup();
         fl_activate_form(assForm);
      }
      
      /* Printer Pref */
      else if (af.obj==af.printerpref)
      {
         fl_deactivate_form(assForm);
         xwPrefPrinterSetup();
         fl_activate_form(assForm);
      }
      
      /* Convert Pictures for Picture Cache */
      else if (af.obj==af.pbcache)
      {      
         fl_deactivate_form(assForm);
         xwSetFSPattern("");
         strcpy(astr,xwGR(1,"fs.SelectDrawer","Select Drawer, please..."));
         strcpy(bstr,xwGR(1,"fs.OK","OK"));
         strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
         strcpy(filename,xwFileSelect(fsPathAll,"",astr,bstr,cstr));
         if (strlen(filename)>0)
         {  
            xwUnSetRealMode();
            xwCreatePBCache(filename);
            xwSetRealMode();
         }
         fl_activate_form(assForm);
      }
      
      /* Configure Fonts */
      else if (af.obj==af.font)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfConfig,afTitleFont,&afTitleFontSize,&afTitleFontUnderline);

         fl_activate_form(assForm);
      }
   }

   xwRemoveObject(af.paperpref);
   xwRemoveObject(af.xwguipref);
   xwRemoveObject(af.printerpref);
   xwRemoveObject(af.pbcache);
   xwRemoveObject(af.font);
   xwRemoveObject(af.menu);

   /* clear panel */
   fl_winset(assForm->window);
   fl_rectf(7,42,676,420,FL_COL1);

   xwShowAssistent();

   return;
}

/* Refresh Handler */
int assPrefHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev)
{
   if (assHandlerLock==0)
   {
      assHandlerLock=1;

      if (event==FL_DRAW)
      {
         fl_winset(assForm->window);
      }

      assHandlerLock=0;
   }

   return(0);
}