/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWASSPRINTPICTURE_H
#define _XWASSPRINTPICTURE_H

#include <forms.h>

#include <strings.h>
#include <unistd.h>

typedef struct assprintpictureform
{
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *frameA;
   FL_OBJECT         *frameB;       /* Picture Frame */
   
   FL_OBJECT         *browser;
   FL_OBJECT         *left;
   FL_OBJECT         *right;
   
   FL_OBJECT         *noborder;
   FL_OBJECT         *pictureborder;
   FL_OBJECT         *frameborder;
   
   FL_OBJECT         *landscape;
   FL_OBJECT         *portrait;
   
   FL_OBJECT         *frameC;       /* Text Frame */
   
   FL_OBJECT         *title;
   FL_OBJECT         *titleFont;
   FL_OBJECT         *titleCol;
   FL_OBJECT         *rights;
   FL_OBJECT         *rightsFont;
   FL_OBJECT         *rightsCol;
   
   FL_OBJECT         *preview;
   FL_OBJECT         *print;
   FL_OBJECT         *menu;
} assprintpictureform;

/* Display About Box */
void assPrintPicture(FL_FORM *form);
/* Refresh Handler */
int assPrintPictureHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev);
/* Create Pixmap */
void assPrintPictureCreatePixmap(void);
/* Create Page */
void assPrintPicturePage(void);


#endif