/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ass-picture.h"

#include "assistent.h"
#include "base.h"
#include "color.h"
#include "font.h"
#include "frame.h"
#include "gfx.h"
#include "limits.h"
#include "paper.h"
#include "picture.h"
#include "picbrowser.h"
#include "progress.h"
#include "resource.h"
#include "wysiwyg.h"
#include "x11.h"

#include "pixmaps/as-noborder.xpm"
#include "pixmaps/as-frameborder.xpm"
#include "pixmaps/as-pictureborder.xpm"
#include "pixmaps/as-landscape.xpm"
#include "pixmaps/as-portrait.xpm"

static struct assprintpictureform      af;

static char             afPicture[1024]="";
static int              afPictureFlag=0;
static Pixmap           afPicturePixmap;
static int              afPicturePixmapW,afPicturePixmapH;
static int              afRotation=0;
static int              afPaper=0;                                /* Paperorientation 0 - landscape / 1 - portrait */
static int              afBorder=0;

static char             afTitle[256]="";
static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=22;
static int              afTitleFontUnderline=0;
static int              afTitleCol=0;
static char             afRights[256]="(c) 2002 by ";
static char             afRightsFont[1024]="Courier";
static int              afRightsFontSize=10;
static int              afRightsFontUnderline=0;
static int              afRightsCol=0;

/* Handler Lock */
static int              assHandlerLock=0;

static FL_FORM          *assForm;

/* Print Picture GUI */
void assPrintPicture(FL_FORM *form)
{
   char              *strptr;

   if (afPaper==0)
   {
      xwGFXLandscape(1);
   }
   else
   {
      xwGFXLandscape(0);
   }

   assForm=form;

   xwHideAssistent();

   /* Geometry 5 40 680 424 / 7 42 */

   fl_addto_form(form);

   fl_set_border_width(1);

   af.frameA = fl_add_labelframe(FL_DOWN_FRAME,8,48,674,164,xwGR(1,"ass.PictureFrame","picture settings"));

   af.frameB = fl_add_frame(FL_DOWN_FRAME,11,56,154,154,"");
   fl_set_object_posthandler(af.frameB,assPrintPictureHandler);

   af.browser = fl_add_button(FL_NORMAL_BUTTON,166+5,55,506,20,xwGR(1,"ass.Picture","load picture for printing "));

   af.left = fl_add_button(FL_NORMAL_BUTTON,166+5,80,253,20,xwGR(1,"ass.RotateLeft","rotate picture in left direction"));
   af.right = fl_add_button(FL_NORMAL_BUTTON,166+5+253,80,253,20,xwGR(1,"ass.RotateRight","rotate picture in right direction"));

   fl_set_border_width(-2);

   af.noborder = fl_add_pixmapbutton(FL_PUSH_BUTTON,166+5+100,105,30,30,xwGR(1,"ass.Borders","Borders:"));
   fl_set_pixmap_data(af.noborder,as_noborder_xpm);
   fl_set_object_color(af.noborder,FL_BLACK,FL_MCOL);
   fl_set_object_lalign(af.noborder,FL_ALIGN_LEFT);

   af.pictureborder = fl_add_pixmapbutton(FL_PUSH_BUTTON,166+5+100+35,105,30,30,"");
   fl_set_pixmap_data(af.pictureborder,as_pictureborder_xpm);
   fl_set_object_color(af.pictureborder,FL_BLACK,FL_MCOL);

   af.frameborder = fl_add_pixmapbutton(FL_PUSH_BUTTON,166+5+100+70,105,30,30,"");
   fl_set_pixmap_data(af.frameborder,as_frameborder_xpm);
   fl_set_object_color(af.frameborder,FL_BLACK,FL_MCOL);

   if (afBorder==0)
   {
      fl_set_button(af.noborder,1);
      fl_set_button(af.pictureborder,0);
      fl_set_button(af.frameborder,0);
   }
   else if (afBorder==1)
   {
      fl_set_button(af.noborder,0);
      fl_set_button(af.pictureborder,1);
      fl_set_button(af.frameborder,0);
   }
   else if (afBorder==2)
   {
      fl_set_button(af.noborder,0);
      fl_set_button(af.pictureborder,0);
      fl_set_button(af.frameborder,1);
   }

   af.landscape = fl_add_pixmapbutton(FL_PUSH_BUTTON,166+5+100,175,30,30,xwGR(1,"ass.PaperFormat","Paper Format:"));
   fl_set_pixmap_data(af.landscape,as_landscape_xpm);
   fl_set_object_color(af.landscape,FL_BLACK,FL_MCOL);
   fl_set_object_lalign(af.landscape,FL_ALIGN_LEFT);

   af.portrait = fl_add_pixmapbutton(FL_PUSH_BUTTON,166+5+100+35,175,30,30,"");
   fl_set_pixmap_data(af.portrait,as_portrait_xpm);
   fl_set_object_color(af.portrait,FL_BLACK,FL_MCOL);

   fl_set_border_width(1);

   if (afPaper==0)
   {
      fl_set_button(af.landscape,1);
      fl_set_button(af.portrait,0);
   }
   else
   {
      fl_set_button(af.landscape,0);
      fl_set_button(af.portrait,1);
   }

   af.frameC = fl_add_labelframe(FL_DOWN_FRAME,8,220,674,190,xwGR(1,"ass.TextFrame","text settings"));

   af.title = fl_add_input(FL_NORMAL_INPUT,157,228,440-20,20,xwGR(1,"ass.Titles","Picture Title:"));
   af.titleCol = fl_add_button(FL_NORMAL_BUTTON,577,228,20,20,"");
   xwSetRGBC(26,afTitleCol);
   fl_set_object_color(af.titleCol,26,26);
   af.titleFont = fl_add_button(FL_NORMAL_BUTTON,597,228,80,20,xwGR(1,"ass.Font","Font"));
   fl_set_input_maxchars(af.title,255);
   fl_set_input_return(af.title,FL_RETURN_CHANGED);
   fl_set_input(af.title,afTitle);
 
   af.rights = fl_add_input(FL_NORMAL_INPUT,157,253,440-20,20,xwGR(1,"ass.Copyrights","Copyrights:"));
   af.rightsCol = fl_add_button(FL_NORMAL_BUTTON,577,253,20,20,"");
   xwSetRGBC(27,afRightsCol);
   fl_set_object_color(af.rightsCol,27,27);
   af.rightsFont = fl_add_button(FL_NORMAL_BUTTON,597,253,80,20,xwGR(1,"ass.Font","Font"));
   fl_set_input_maxchars(af.rights,255);
   fl_set_input_return(af.rights,FL_RETURN_CHANGED);
   fl_set_input(af.rights,afRights);

   af.preview = fl_add_button(FL_NORMAL_BUTTON,7,417,224,45,xwGR(1,"ass.Preview","Preview\nPage"));
   fl_set_object_lsize(af.preview,FL_NORMAL_SIZE);
   af.print = fl_add_button(FL_NORMAL_BUTTON,233,417,224,45,xwGR(1,"ass.Print","Print\nPage"));
   fl_set_object_lsize(af.print,FL_NORMAL_SIZE);
   af.menu = fl_add_button(FL_NORMAL_BUTTON,459,417,224,45,xwGR(1,"ass.Menu","Return\nto\nMenu"));
   fl_set_object_lsize(af.menu,FL_NORMAL_SIZE);

   fl_end_form();

   if (strlen(afPicture)>0)
   {
      assPrintPictureCreatePixmap();
   }

   af.ready=0;
   while (af.ready==0)
   {
      af.obj=fl_do_forms();

      /* Menu */
      if (af.obj==af.menu)
      {
         /* create page */
         assPrintPicturePage();

         if (afPaper==0)
         {
            xwGFXLandscape(1);
         }
         else
         {
            xwGFXLandscape(0);
         }

         af.ready=-1;
      }

      /* Preview */
      else if (af.obj==af.preview)
      {
         fl_deactivate_form(assForm);

         /* create page */
         assPrintPicturePage();

         if (afPaper==0)
         {
            xwGFXLandscape(1);
         }
         else
         {
            xwGFXLandscape(0);
         }

         xwPreviewAssistent();

         fl_activate_form(assForm);
      }

      /* Print */
      else if (af.obj==af.print)
      {
         fl_deactivate_form(assForm);

         xwLockProgress();

         /* create page */
         assPrintPicturePage();

         if (afPaper==0)
         {
            xwGFXLandscape(1);
         }
         else
         {
            xwGFXLandscape(0);
         }

         xwPrintAssistent(0);

         xwUnLockProgress();
         xwCloseProgress();

         fl_activate_form(assForm);
      }

      /* ########## Picture Settings ########## */

      /* browser */
      else if (af.obj==af.browser)
      {
         strptr=xwPictureBrowser(form);
         if ((strptr!=NULL) && (strlen(strptr)<1024) && (strlen(strptr)>0))
         {
            strcpy(afPicture,strptr);

            afRotation=0;

            assPrintPictureCreatePixmap();
         }
      }

      /* noborder */
      else if (af.obj==af.noborder)
      {
         afBorder=0;
         fl_set_button(af.noborder,1);
         fl_set_button(af.pictureborder,0);
         fl_set_button(af.frameborder,0);
      }
      /* pictureborder */
      else if (af.obj==af.pictureborder)
      {
         afBorder=1;
         fl_set_button(af.noborder,0);
         fl_set_button(af.pictureborder,1);
         fl_set_button(af.frameborder,0);
      }
      /* frameborder */
      else if (af.obj==af.frameborder)
      {
         afBorder=2;
         fl_set_button(af.noborder,0);
         fl_set_button(af.pictureborder,0);
         fl_set_button(af.frameborder,1);
      }

      /* rotate left */
      else if (af.obj==af.left)
      {
         afRotation=afRotation-90;
         if (afRotation<-180) afRotation=90;

         if (strlen(afPicture)>0) assPrintPictureCreatePixmap();
      }
      /* rotate right */
      else if (af.obj==af.right)
      {
         afRotation=afRotation+90;
         if (afRotation>180) afRotation=-90;

         if (strlen(afPicture)>0) assPrintPictureCreatePixmap();
      }


      /* landscape */
      else if (af.obj==af.landscape)
      {
         afPaper=0;
         fl_set_button(af.landscape,1);
         fl_set_button(af.portrait,0);
      }
      /* portrait */
      else if (af.obj==af.portrait)
      {
         afPaper=1;
         fl_set_button(af.landscape,0);
         fl_set_button(af.portrait,1);
      }

      /* ########## Text Settings ########## */

      /* Title */
      else if (af.obj==af.title)
      {
         strcpy(afTitle,fl_get_input(af.title));
      }
      /* Title Color */
      else if (af.obj==af.titleCol)
      {
         afTitleCol=xwColorMixer(assForm,26,afTitleCol);
         fl_redraw_object(af.titleCol);      
      }
      /* Title Font */
      else if (af.obj==af.titleFont)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afTitleFont,&afTitleFontSize,&afTitleFontUnderline);

         fl_activate_form(assForm);
      }

      /* Rights */
      else if (af.obj==af.rights)
      {
         strcpy(afRights,fl_get_input(af.rights));
      }
      /* Rights Color */
      else if (af.obj==af.rightsCol)
      {
         afRightsCol=xwColorMixer(assForm,27,afRightsCol);
         fl_redraw_object(af.rightsCol);      
      }
      /* Title Font */
      else if (af.obj==af.rightsFont)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afRightsFont,&afRightsFontSize,&afRightsFontUnderline);

         fl_activate_form(assForm);
      }

   }

   xwRemoveObject(af.frameA);
   xwRemoveObject(af.frameB);
   
   xwRemoveObject(af.browser);
   xwRemoveObject(af.left);
   xwRemoveObject(af.right);
   
   xwRemoveObject(af.noborder);
   xwRemoveObject(af.pictureborder);
   xwRemoveObject(af.frameborder);
   xwRemoveObject(af.landscape);
   xwRemoveObject(af.portrait);
   
   xwRemoveObject(af.frameC);
   
   xwRemoveObject(af.title);
   xwRemoveObject(af.titleFont);
   xwRemoveObject(af.titleCol);
   xwRemoveObject(af.rights);
   xwRemoveObject(af.rightsFont);
   xwRemoveObject(af.rightsCol);
   
   xwRemoveObject(af.preview);
   xwRemoveObject(af.print);
   xwRemoveObject(af.menu);

   /* clear panel */
   fl_winset(assForm->window);
   fl_rectf(7,42,676,420,FL_COL1);

   /* remove old picture */
   if (afPictureFlag==1)
   {
      XFreePixmap(fl_display,afPicturePixmap);
      afPictureFlag=0;
   }

   xwShowAssistent();

   return;
}

/* Refresh Handler */
int assPrintPictureHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev)
{
   if (assHandlerLock==0)
   {
      assHandlerLock=1;

      if (event==FL_DRAW)
      {
         fl_winset(assForm->window);
         fl_rectf(13,58,150,150,FL_COL1);
         if (afPictureFlag!=0)
         {
            XCopyArea(fl_display,afPicturePixmap,assForm->window,fl_get_gc(),0,0,afPicturePixmapW,afPicturePixmapH,13+((150-afPicturePixmapW)/2),58+((150-afPicturePixmapH)/2));
         }
      }

      assHandlerLock=0;
   }

   return(0);
}

/* Create Pixmap */
void assPrintPictureCreatePixmap(void)
{
   float             factor;
   char              astr[1024];
   
   /* remove old picture */
   if (afPictureFlag==1)
   {
      XFreePixmap(fl_display,afPicturePixmap);
      afPictureFlag=0;
   }

   /* Create Pixmap */
   strcpy(astr,xwGetRealPicture(afPicture));
   if (xwGFXImport(astr,xwGetFile("","import.ppm"))==xwTrue)
   {
      if (xwGFXLoadPicture(xwGetFile("","import.ppm"))==xwTrue)
      {
         afPicturePixmapW=xwGFXGetPictureX();
         afPicturePixmapH=xwGFXGetPictureY();

         factor=(float) afPicturePixmapW/(float) afPicturePixmapH;

         /* Height */
         if (150/factor>150)
         {
            afPicturePixmapW=(int) (150*factor);
            afPicturePixmapH=150;
         }
         else
         {
            afPicturePixmapW=150;
            afPicturePixmapH=(int) (150/factor);
         }

         xwGFXScalePicture(memPicture,createTemp,0,0,afPicturePixmapW,afPicturePixmapH,afRotation);

         afPicturePixmap=xwGFXCreatePixmap(memPicture);
         if (afPicturePixmap!=-1)
         {
            afPicturePixmapW=xwGFXGetPictureX();
            afPicturePixmapH=xwGFXGetPictureY();

            fl_winset(assForm->window);
            fl_rectf(13,58,150,150,FL_COL1);
            XCopyArea(fl_display,afPicturePixmap,assForm->window,fl_get_gc(),0,0,afPicturePixmapW,afPicturePixmapH,13+((150-afPicturePixmapW)/2),58+((150-afPicturePixmapH)/2));
            afPictureFlag=1;

         }
         xwGFXRemovePicture();
      }
      unlink(xwGetFile("","import.ppm"));
   }

   return;
}

/* Create Page */
void assPrintPicturePage(void)
{
   int               brdSize;
   int               ax;
   int               rot;

   /* get highest bordersize */
   brdSize=0;

   ax=xwGetPaperTB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperBB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperLB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperRB();
   if (ax>brdSize) brdSize=ax;

   /* remove all frames */
   xwFreeFrames(-1);
   xwFreePicture(-1);

   /* Portrait */
   xwSetPaperLS(xwPortrait);

   /* landscape */
   if (afPaper==0)
   {
      /* Picture Datas */
      if (xwExist(afPicture)==xwTrue)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,(xwGetPaperXSize()-(2*brdSize))-(10*xwMM()),xwGetPaperYSize()-(2*brdSize));
         xwFPLoad(afPicture);
         rot=afRotation;

         /* rotateLeft rotateRight */
         rot=rot-90;
         if (rot<-180) rot=90;

         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }

         /* Picture Borders */
         if (afBorder==1)
         {
            xwSetFramePB(xwGetFrameCount(),assBordersize);
            xwSetFramePF(xwGetFrameCount(),assBorderline);
            xwSetFramePC(xwGetFrameCount(),0);
         }
         /* Frame Border */
         else if (afBorder==2)
         {
            xwSetFrameB(xwGetFrameCount(),assBordersize);
            xwSetFrameF(xwGetFrameCount(),assBorderline);
            xwSetFrameC(xwGetFrameCount(),0);
         }

      }

      /* Title */
      if (strlen(afTitle)>0)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(xwGetPaperXSize()-(2*brdSize))-(9*xwMM()),brdSize,9*xwMM(),xwGetPaperYSize()-(2*brdSize));
         xwSetFontName(xwGetFrameCount(),afTitleFont);
         xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afTitle);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTitleCol);
      }

      /* Copyrights */
      if (strlen(afRights)>0)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(xwGetPaperXSize()-(2*brdSize))-(9*xwMM()),brdSize,9*xwMM(),(xwGetPaperYSize()-(2*brdSize))/4);
         xwSetFontName(xwGetFrameCount(),afRightsFont);
         xwSetFontSize(xwGetFrameCount(),afRightsFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afRights);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afRightsCol);
      }

   }
   else
   /* portrait */
   {
      /* Picture Datas */
      if (xwExist(afPicture)==xwTrue)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,xwGetPaperXSize()-(2*brdSize),xwGetPaperYSize()-(2*brdSize)-(10*xwMM()));
         xwFPLoad(afPicture);
         rot=afRotation;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }

         /* Picture Borders */
         if (afBorder==1)
         {
            xwSetFramePB(xwGetFrameCount(),assBordersize);
            xwSetFramePF(xwGetFrameCount(),assBorderline);
            xwSetFramePC(xwGetFrameCount(),0);
         }
         /* Frame Border */
         else if (afBorder==2)
         {
            xwSetFrameB(xwGetFrameCount(),assBordersize);
            xwSetFrameF(xwGetFrameCount(),assBorderline);
            xwSetFrameC(xwGetFrameCount(),0);
         }

      }

      /* Title */
      if (strlen(afTitle)>0)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize,xwGetPaperYSize()-(brdSize+(9*xwMM())),xwGetPaperXSize()-(2*brdSize),9*xwMM());
         xwSetFontName(xwGetFrameCount(),afTitleFont);
         xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
         xwSetFontDirection(xwGetFrameCount(),0);
         xwSetFontText(xwGetFrameCount(),afTitle);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTitleCol);
      }

      /* Rights */
      if (strlen(afRights)>0)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(((xwGetPaperXSize()-(2*brdSize))/3)*2),xwGetPaperYSize()-(brdSize+(9*xwMM())),(xwGetPaperXSize()-(2*brdSize))/3,9*xwMM());
         xwSetFontName(xwGetFrameCount(),afRightsFont);
         xwSetFontSize(xwGetFrameCount(),afRightsFontSize);
         xwSetFontDirection(xwGetFrameCount(),0);
         xwSetFontText(xwGetFrameCount(),afRights);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afRightsCol);
      }
   }

   return;
}