/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWASSCOVER_H
#define _XWASSCOVER_H

#include <forms.h>

#include <strings.h>
#include <unistd.h>

typedef struct assprintcoverform
{
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *frameA;
   FL_OBJECT         *covertype;
   
   FL_OBJECT         *frameB;
   FL_OBJECT         *frameBB;
   FL_OBJECT         *browserB;
   FL_OBJECT         *removeB;
   FL_OBJECT         *rotateLB;
   FL_OBJECT         *rotateRB;
   
   FL_OBJECT         *frameC;
   FL_OBJECT         *frameCC;
   FL_OBJECT         *browserC;
   FL_OBJECT         *removeC;
   FL_OBJECT         *rotateLC;
   FL_OBJECT         *rotateRC;
   
   FL_OBJECT         *frameD;
   FL_OBJECT         *title;
   FL_OBJECT         *titleC;
   FL_OBJECT         *titleF;

   FL_OBJECT         *text;
   FL_OBJECT         *textC;
   FL_OBJECT         *textF;   
   
   FL_OBJECT         *preview;
   FL_OBJECT         *print;
   FL_OBJECT         *menu;
} assprintcoverform;

/* Free Cover Mem */
void assFreeCoverMem(void);
/* Display About Box */
void assPrintCover(FL_FORM *form);
/* Refresh Handler */
int assPrintCoverHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev);
/* Create Pixmap */
void assPrintCoverCreatePixmap(int az);
/* Create Page */
void assPrintCoverPage(void);


#endif