/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ass-cover.h"

#include "assistent.h"
#include "base.h"
#include "color.h"
#include "font.h"
#include "frame.h"
#include "gfx.h"
#include "limits.h"
#include "lowlevel.h"
#include "paper.h"
#include "picture.h"
#include "picbrowser.h"
#include "progress.h"
#include "resource.h"
#include "wysiwyg.h"
#include "x11.h"

static struct assprintcoverform      af;

static int              afCoverType=1;

static char             afPictureA[1024]="";
static int              afPictureFlagA=0;
static Pixmap           afPicturePixmapA;
static int              afPicturePixmapWA,afPicturePixmapHA;
static int              afRotationA=0;

static char             afPictureB[1024]="";
static int              afPictureFlagB=0;
static Pixmap           afPicturePixmapB;
static int              afPicturePixmapWB,afPicturePixmapHB;
static int              afRotationB=0;

static char             afTitle[256]="";
static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=15;
static int              afTitleFontUnderline=0;
static int              afTitleColor=0;

static char             *afText=NULL;
static char             afTextFont[1024]="Courier";
static int              afTextFontSize=10;
static int              afTextFontUnderline=0;
static int              afTextColor=0;

/* Handler Lock */
static int              assHandlerLock=0;

static FL_FORM          *assForm;

/* Free Cover Mem */
void assFreeCoverMem(void)
{
   if (afText!=NULL)
   {
      free(afText);
      afText=NULL;
   }

   return;
}

/* Print Picture GUI */
void assPrintCover(FL_FORM *form)
{
   char              *strptr;
   int               az;

   assForm=form;

   xwHideAssistent();

   /* Geometry 5 40 680 424 / 7 42 */

   fl_addto_form(form);

   fl_set_border_width(1);

   af.frameA = fl_add_frame(FL_DOWN_FRAME,8,43,674,24,"");
   af.covertype = fl_add_choice(FL_DROPLIST_CHOICE,208,45,472,20,xwGR(1,"ass.cvCoverType","Covertype:"));
   fl_set_object_boxtype(af.covertype,FL_UP_BOX);
   fl_addto_choice(af.covertype,strLength(xwGR(1,"ass.cvCD","CD"),112));
   fl_addto_choice(af.covertype,strLength(xwGR(1,"ass.cvCDLabel","CD-Label"),112));
   fl_addto_choice(af.covertype,strLength(xwGR(1,"ass.cvDVD","DVD"),112));
   fl_addto_choice(af.covertype,strLength(xwGR(1,"ass.cvVHS","VHS"),112));
   fl_addto_choice(af.covertype,strLength(xwGR(1,"ass.cvZIP","ZIP"),112));

   fl_set_choice(af.covertype,afCoverType);

   /* Front Picture */
   af.frameB = fl_add_labelframe(FL_DOWN_FRAME,8,75,335,134,xwGR(1,"ass.cvFrontPicture","Front Picture"));
   af.frameBB = fl_add_frame(FL_DOWN_FRAME,11,83,124,124,"");
   fl_set_object_posthandler(af.frameBB,assPrintCoverHandler);

   af.browserB = fl_add_button(FL_NORMAL_BUTTON,141,83,200,20,xwGR(1,"ass.LoadPicture","load picture"));
   af.removeB =  fl_add_button(FL_NORMAL_BUTTON,141,103,200,20,xwGR(1,"ass.RemovePicture","remove picture"));
   af.rotateLB = fl_add_button(FL_NORMAL_BUTTON,141,124,200,20,xwGR(1,"ass.RotateLeft","rotate picture in left direction"));
   af.rotateRB = fl_add_button(FL_NORMAL_BUTTON,141,144,200,20,xwGR(1,"ass.RotateRight","rotate picture in right direction"));

   /* Back Picture */
   af.frameC = fl_add_labelframe(FL_DOWN_FRAME,347,75,335,134,xwGR(1,"ass.cvBackPicture","Back Picture"));
   af.frameCC = fl_add_frame(FL_DOWN_FRAME,350,83,124,124,"");
   fl_set_object_posthandler(af.frameCC,assPrintCoverHandler);

   af.browserC = fl_add_button(FL_NORMAL_BUTTON,480,83,200,20,xwGR(1,"ass.LoadPicture","load picture"));
   af.removeC =  fl_add_button(FL_NORMAL_BUTTON,480,103,200,20,xwGR(1,"ass.RemovePicture","remove picture"));
   af.rotateLC = fl_add_button(FL_NORMAL_BUTTON,480,124,200,20,xwGR(1,"ass.RotateLeft","rotate picture in left direction"));
   af.rotateRC = fl_add_button(FL_NORMAL_BUTTON,480,144,200,20,xwGR(1,"ass.RotateRight","rotate picture in right direction"));

   af.frameD = fl_add_labelframe(FL_DOWN_FRAME,8,218,674,196,xwGR(1,"ass.TextFrame","Text Settings"));

   af.title = fl_add_input(FL_NORMAL_INPUT,141,226,440,20,xwGR(1,"ass.cvTitle","Title:"));
   af.titleC = fl_add_button(FL_NORMAL_BUTTON,581,226,20,20,"");
   xwSetRGBC(26,afTitleColor);
   fl_set_object_color(af.titleC,26,26);
   af.titleF = fl_add_button(FL_NORMAL_BUTTON,601,226,80,20,xwGR(1,"ass.Font","Font"));
   fl_set_input_maxchars(af.title,255);
   fl_set_input_return(af.title,FL_RETURN_CHANGED);
   fl_set_input(af.title,afTitle);

   af.text = fl_add_input(FL_MULTILINE_INPUT,141,247,440,165,xwGR(1,"ass.cvRemarks","Remark:"));
   fl_set_input_maxchars(af.text,32768);
   fl_set_input_return(af.text,FL_RETURN_CHANGED);
   if (afText!=NULL)
   {
      fl_set_input(af.text,afText);
   }
   else
   {
      fl_set_input(af.text,"");
   }
   af.textC = fl_add_button(FL_NORMAL_BUTTON,581,247,20,20,"");
   xwSetRGBC(27,afTextColor);
   fl_set_object_color(af.textC,27,27);
   af.textF = fl_add_button(FL_NORMAL_BUTTON,601,247,80,20,xwGR(1,"ass.Font","Font"));

   af.preview = fl_add_button(FL_NORMAL_BUTTON,7,417,224,45,xwGR(1,"ass.Preview","Preview\nPage"));
   fl_set_object_lsize(af.preview,FL_NORMAL_SIZE);
   af.print = fl_add_button(FL_NORMAL_BUTTON,233,417,224,45,xwGR(1,"ass.Print","Print\nPage"));
   fl_set_object_lsize(af.print,FL_NORMAL_SIZE);
   af.menu = fl_add_button(FL_NORMAL_BUTTON,459,417,224,45,xwGR(1,"ass.Menu","Return\nto\nMenu"));
   fl_set_object_lsize(af.menu,FL_NORMAL_SIZE);

   fl_end_form();

   if (strlen(afPictureA)>0) assPrintCoverCreatePixmap(0);
   if (strlen(afPictureB)>0) assPrintCoverCreatePixmap(1);

   af.ready=0;
   while (af.ready==0)
   {
      af.obj=fl_do_forms();

      /* Menu */
      if (af.obj==af.menu)
      {
         /* create page */
         assPrintCoverPage();

         xwGFXLandscape(0);

         af.ready=-1;
      }

      /* Preview */
      else if (af.obj==af.preview)
      {
         fl_deactivate_form(assForm);

         /* create page */
         assPrintCoverPage();

         xwPreviewAssistent();

         fl_activate_form(assForm);
      }

      /* Print */
      else if (af.obj==af.print)
      {
         fl_deactivate_form(assForm);

         xwLockProgress();

         /* create page */
         assPrintCoverPage();

         xwPrintAssistent(0);

         xwUnLockProgress();
         xwCloseProgress();

         fl_activate_form(assForm);
      }

      /* cover selection */
      else if (af.obj==af.covertype)
      {
         az=fl_get_choice(af.covertype);
         if (az!=0) afCoverType=az;
      }

      /* browser A */
      else if (af.obj==af.browserB)
      {
         strptr=xwPictureBrowser(form);
         if ((strptr!=NULL) && (strlen(strptr)<1024) && (strlen(strptr)>0))
         {
            strcpy(afPictureA,strptr);

            afRotationA=0;

            assPrintCoverCreatePixmap(0);
         }
      }
      /* remove A */
      else if (af.obj==af.removeB)
      {
         strcpy(afPictureA,"");
         afRotationA=0;

         /* remove old picture */
         if (afPictureFlagA==1) XFreePixmap(fl_display,afPicturePixmapA);
         afPictureFlagA=0;

         fl_winset(assForm->window);
         fl_rectf(13,85,120,120,FL_COL1);
      }
      /* rotate left */
      else if (af.obj==af.rotateLB)
      {
         afRotationA=afRotationA-90;
         if (afRotationA<-180) afRotationA=90;

         if (strlen(afPictureA)>0) assPrintCoverCreatePixmap(0);
      }
      /* rotate right */
      else if (af.obj==af.rotateRB)
      {
         afRotationA=afRotationA+90;
         if (afRotationA>180) afRotationA=-90;

         if (strlen(afPictureA)>0) assPrintCoverCreatePixmap(0);
      }

      /* browser B */
      else if (af.obj==af.browserC)
      {
         strptr=xwPictureBrowser(form);
         if ((strptr!=NULL) && (strlen(strptr)<1024) && (strlen(strptr)>0))
         {
            strcpy(afPictureB,strptr);

            afRotationB=0;

            assPrintCoverCreatePixmap(1);
         }
      }
      /* remove B */
      else if (af.obj==af.removeC)
      {
         strcpy(afPictureB,"");
         afRotationB=0;

         /* remove old picture */
         if (afPictureFlagB==1) XFreePixmap(fl_display,afPicturePixmapB);
         afPictureFlagB=0;

         fl_winset(assForm->window);
         fl_rectf(352,85,120,120,FL_COL1);
      }
      /* rotate left */
      else if (af.obj==af.rotateLC)
      {
         afRotationB=afRotationB-90;
         if (afRotationB<-180) afRotationB=90;

         if (strlen(afPictureB)>0) assPrintCoverCreatePixmap(1);
      }
      /* rotate right */
      else if (af.obj==af.rotateRC)
      {
         afRotationB=afRotationB+90;
         if (afRotationB>180) afRotationB=-90;

         if (strlen(afPictureB)>0) assPrintCoverCreatePixmap(1);
      }

      /* title */
      else if (af.obj==af.title)
      {
         strcpy(afTitle,fl_get_input(af.title));
      }
      /* title color */
      else if (af.obj==af.titleC)
      {
         afTitleColor=xwColorMixer(assForm,26,afTitleColor);
         fl_redraw_object(af.titleC);
      }
      /* title font */
      else if (af.obj==af.titleF)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afTitleFont,&afTitleFontSize,&afTitleFontUnderline);

         fl_activate_form(assForm);
      }

     /* text */
      else if (af.obj==af.text)
      {
         strptr=fl_get_input(af.text);
         if (afText==NULL)
         {
            afText=malloc(strlen(strptr)+4);
            if (afText!=NULL) strcpy(afText,strptr);
         }
         else
         {
            afText=realloc(afText,strlen(strptr)+4);
            if (afText!=NULL) strcpy(afText,strptr);
         }
      }
      /* text color */
      else if (af.obj==af.textC)
      {
         afTextColor=xwColorMixer(assForm,27,afTextColor);
         fl_redraw_object(af.textC);
      }
      /* text font */
      else if (af.obj==af.textF)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afTextFont,&afTextFontSize,&afTextFontUnderline);

         fl_activate_form(assForm);
      }

   }

   xwRemoveObject(af.preview);
   xwRemoveObject(af.print);
   xwRemoveObject(af.menu);

   xwRemoveObject(af.frameA);
   xwRemoveObject(af.covertype);
   xwRemoveObject(af.frameB);
   xwRemoveObject(af.frameBB);
   xwRemoveObject(af.browserB);
   xwRemoveObject(af.removeB);
   xwRemoveObject(af.rotateLB);
   xwRemoveObject(af.rotateRB);

   xwRemoveObject(af.frameC);
   xwRemoveObject(af.frameCC);
   xwRemoveObject(af.browserC);
   xwRemoveObject(af.removeC);
   xwRemoveObject(af.rotateLC);
   xwRemoveObject(af.rotateRC);

   xwRemoveObject(af.frameD);
   xwRemoveObject(af.title);
   xwRemoveObject(af.titleC);
   xwRemoveObject(af.titleF);

   xwRemoveObject(af.text);
   xwRemoveObject(af.textC);
   xwRemoveObject(af.textF);

   /* clear panel */
   fl_winset(assForm->window);
   fl_rectf(7,42,676,420,FL_COL1);

   /* remove old picture */
   if (afPictureFlagA==1)
   {
      XFreePixmap(fl_display,afPicturePixmapA);
      afPictureFlagA=0;
   }
   if (afPictureFlagB==1)
   {
      XFreePixmap(fl_display,afPicturePixmapB);
      afPictureFlagB=0;
   }

   xwShowAssistent();

   return;
}

/* Refresh Handler */
int assPrintCoverHandler(FL_OBJECT *obj,int event,FL_Coord mx,FL_Coord my,int key,void *xev)
{
   if (assHandlerLock==0)
   {
      assHandlerLock=1;

      if (event==FL_DRAW)
      {
         fl_winset(assForm->window);
         fl_rectf(13,85,120,120,FL_COL1);
         if (afPictureFlagA!=0)
         {
            XCopyArea(fl_display,afPicturePixmapA,assForm->window,fl_get_gc(),0,0,afPicturePixmapWA,afPicturePixmapHA,13+((120-afPicturePixmapWA)/2),85+((120-afPicturePixmapHA)/2));
         }

         fl_winset(assForm->window);
         fl_rectf(352,85,120,120,FL_COL1);
         if (afPictureFlagB!=0)
         {
            XCopyArea(fl_display,afPicturePixmapB,assForm->window,fl_get_gc(),0,0,afPicturePixmapWB,afPicturePixmapHB,352+((120-afPicturePixmapWB)/2),85+((120-afPicturePixmapHB)/2));
         }
      }

      assHandlerLock=0;
   }

   return(0);
}

/* Create Pixmap */
void assPrintCoverCreatePixmap(int az)
{
   float             factor;
   char              astr[1024];


   if (az==0)
   {
      /* remove old picture */
      if (afPictureFlagA==1)
      {
         XFreePixmap(fl_display,afPicturePixmapA);
         afPictureFlagA=0;
      }

      /* Create Pixmap */
      strcpy(astr,xwGetRealPicture(afPictureA));
      if (xwGFXImport(astr,xwGetFile("","import.ppm"))==xwTrue)
      {
         if (xwGFXLoadPicture(xwGetFile("","import.ppm"))==xwTrue)
         {
            afPicturePixmapWA=xwGFXGetPictureX();
            afPicturePixmapHA=xwGFXGetPictureY();

            factor=(float) afPicturePixmapWA/(float) afPicturePixmapHA;

            /* Height */
            if (120/factor>120)
            {
               afPicturePixmapWA=(int) (120*factor);
               afPicturePixmapHA=120;
            }
            else
            {
               afPicturePixmapWA=120;
               afPicturePixmapHA=(int) (120/factor);
            }

            xwGFXScalePicture(memPicture,createTemp,0,0,afPicturePixmapWA,afPicturePixmapHA,afRotationA);

            afPicturePixmapA=xwGFXCreatePixmap(memPicture);
            if (afPicturePixmapA>0)
            {
               afPicturePixmapWA=xwGFXGetPictureX();
               afPicturePixmapHA=xwGFXGetPictureY();

               fl_winset(assForm->window);
               fl_rectf(13,85,120,120,FL_COL1);
               XCopyArea(fl_display,afPicturePixmapA,assForm->window,fl_get_gc(),0,0,afPicturePixmapWA,afPicturePixmapHA,13+((120-afPicturePixmapWA)/2),85+((120-afPicturePixmapHA)/2));
               afPictureFlagA=1;
            }
            xwGFXRemovePicture();
         }
         unlink(xwGetFile("","import.ppm"));
      }
   }
   else if (az==1)
   {
      /* remove old picture */
      if (afPictureFlagB==1)
      {
         XFreePixmap(fl_display,afPicturePixmapB);
         afPictureFlagB=0;
      }

      /* Create Pixmap */
      strcpy(astr,xwGetRealPicture(afPictureB));
      if (xwGFXImport(astr,xwGetFile("","import.ppm"))==xwTrue)
      {
         if (xwGFXLoadPicture(xwGetFile("","import.ppm"))==xwTrue)
         {
            afPicturePixmapWB=xwGFXGetPictureX();
            afPicturePixmapHB=xwGFXGetPictureY();

            factor=(float) afPicturePixmapWB/(float) afPicturePixmapHB;

            /* Height */
            if (120/factor>120)
            {
               afPicturePixmapWB=(int) (120*factor);
               afPicturePixmapHB=120;
            }
            else
            {
               afPicturePixmapWB=120;
               afPicturePixmapHB=(int) (120/factor);
            }

            xwGFXScalePicture(memPicture,createTemp,0,0,afPicturePixmapWB,afPicturePixmapHB,afRotationB);

            afPicturePixmapB=xwGFXCreatePixmap(memPicture);
            if (afPicturePixmapB!=-1)
            {
               afPicturePixmapWB=xwGFXGetPictureX();
               afPicturePixmapHB=xwGFXGetPictureY();

               fl_winset(assForm->window);
               fl_rectf(352,85,120,120,FL_COL1);
               XCopyArea(fl_display,afPicturePixmapB,assForm->window,fl_get_gc(),0,0,afPicturePixmapWB,afPicturePixmapHB,352+((120-afPicturePixmapWB)/2),85+((120-afPicturePixmapHB)/2));
               afPictureFlagB=1;

            }
            xwGFXRemovePicture();
         }
         unlink(xwGetFile("","import.ppm"));
      }
   }
   return;
}

/* Create Page */
void assPrintCoverPage(void)
{
   int               brdSize;
   int               ax;
   int               rot;

   /* get highest bordersize */
   brdSize=0;

   ax=xwGetPaperTB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperBB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperLB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperRB();
   if (ax>brdSize) brdSize=ax;

   /* remove all frames */
   xwFreeFrames(-1);
   xwFreePicture(-1);

   /* Portrait */
   xwSetPaperLS(xwPortrait);

   /* CD Cover */
   if ( (afCoverType==1) && (xwGetPaperXSize()-(2*brdSize)>=152*xwMM()) && (xwGetPaperYSize()-(2*brdSize)>=245*xwMM()) )
   {
      /* Front Cover 12.1 x 12 */
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,121*xwMM(),120*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(5*xwMM()),brdSize+(3*xwMM()),111*xwMM(),7*xwMM());
      xwSetFrameB(xwGetFrameCount(),0);
      xwSetFrameF(xwGetFrameCount(),0); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),0);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(7.5*xwMM()),brdSize+(10*xwMM()),106*xwMM(),105*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.5);
      xwSetFrameF(xwGetFrameCount(),0.5); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      if (xwExist(afPictureA)==xwTrue)
      {
         xwFPLoad(afPictureA);
         rot=afRotationA;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }
      }

      /* Back Cover 15.2 x 11.8 */
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize+(125*xwMM()),7*xwMM(),118*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),3);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(7*xwMM()),brdSize+(125*xwMM()),138*xwMM(),118*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      if (afText!=NULL)
      {
         xwSetFontName(xwGetFrameCount(),afTextFont);
         xwSetFontSize(xwGetFrameCount(),afTextFontSize);
         xwSetFontDirection(xwGetFrameCount(),0);
         xwSetFontText(xwGetFrameCount(),afText);
         xwSetFontMode(xwGetFrameCount(),0);
         xwSetFontColor(xwGetFrameCount(),afTextColor);
      }
      if (xwExist(afPictureB)==xwTrue)
      {
         xwFPLoad(afPictureB);
         rot=afRotationB;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }
      }

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(145*xwMM()),brdSize+(125*xwMM()),7*xwMM(),118*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),1);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);
   }
   /* CD Label */
   else if ( (afCoverType==2) && (xwGetPaperXSize()-(2*brdSize)>=118*xwMM()) && (xwGetPaperYSize()-(2*brdSize)>=118*xwMM()) )
   {
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,118*xwMM(),118*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFrameBT(xwGetFrameCount(),gfxCircle);
   
      if (xwExist(afPictureA)==xwTrue)
      {
         xwFPLoad(afPictureA);
         rot=afRotationA;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }
      }
   
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(40*xwMM()),brdSize+(40*xwMM()),38*xwMM(),38*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFrameBT(xwGetFrameCount(),gfxCircle);
   
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(14*xwMM()),brdSize+(25*xwMM()),90*xwMM(),15*xwMM());
      xwSetFrameB(xwGetFrameCount(),0);
      xwSetFrameBC(xwGetFrameCount(),1);
      xwSetFrameF(xwGetFrameCount(),0);
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),0);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);
   
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(14*xwMM()),brdSize+(81*xwMM()),90*xwMM(),15*xwMM());
      xwSetFrameB(xwGetFrameCount(),0);
      xwSetFrameBC(xwGetFrameCount(),1);
      xwSetFrameF(xwGetFrameCount(),0);
      xwSetFrameC(xwGetFrameCount(),0);
      if (afText!=NULL)
      {
         xwSetFontName(xwGetFrameCount(),afTextFont);
         xwSetFontSize(xwGetFrameCount(),afTextFontSize);
         xwSetFontDirection(xwGetFrameCount(),0);
         xwSetFontText(xwGetFrameCount(),afText);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTextColor);
      }      
   }
   /* DVD Cover Amaray */
   else if ( (afCoverType==3) && (xwGetPaperXSize()-(2*brdSize)>=184*xwMM()) && (xwGetPaperYSize()-(2*brdSize)>=273*xwMM()) )
   {
      /* DVD Cover 273 x 184 - 130 130 13 */
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,184*xwMM(),273*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);

      if (xwExist(afPictureA)==xwTrue)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(6*xwMM()),brdSize+(1*xwMM()),10*xwMM(),128*xwMM());
         xwSetFrameB(xwGetFrameCount(),0);
         xwSetFrameF(xwGetFrameCount(),0);
         xwSetFrameC(xwGetFrameCount(),0);
         xwSetFontName(xwGetFrameCount(),afTitleFont);
         xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afTitle);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTitleColor);
               
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(17*xwMM()),brdSize+(5*xwMM()),162*xwMM(),120*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.4);
         xwSetFrameF(xwGetFrameCount(),0.4);
         xwSetFrameC(xwGetFrameCount(),0);
         xwFPLoad(afPictureA);
         rot=afRotationA;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }

         xwRotatePicInFrame(rotateLeft);
      }
      else
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(90*xwMM()),brdSize+(1*xwMM()),10*xwMM(),128*xwMM());
         xwSetFrameB(xwGetFrameCount(),0);
         xwSetFrameF(xwGetFrameCount(),0);
         xwSetFrameC(xwGetFrameCount(),0);
         xwSetFontName(xwGetFrameCount(),afTitleFont);
         xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afTitle);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTitleColor);
      }

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(130*xwMM()),182*xwMM(),13*xwMM());
      xwSetFrameB(xwGetFrameCount(),0);
      xwSetFrameF(xwGetFrameCount(),0);
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),0);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);

      if (xwExist(afPictureB)==xwTrue)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(144*xwMM()),90*xwMM(),128*xwMM());
         xwSetFrameB(xwGetFrameCount(),0);
         xwSetFrameF(xwGetFrameCount(),0.4);
         xwSetFrameC(xwGetFrameCount(),0);
         if (xwExist(afPictureB)==xwTrue)
         {
            xwFPLoad(afPictureB);
            rot=afRotationB;
            if ((rot==-180) || (rot==180))
            {
               xwRotatePicInFrame(rotateLeft);
               xwRotatePicInFrame(rotateLeft);
            }
            else if (rot==-90)
            {
               xwRotatePicInFrame(rotateLeft);
            }
            else if (rot==90)
            {
               xwRotatePicInFrame(rotateRight);
            }

            xwRotatePicInFrame(rotateLeft);
         }

         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(92*xwMM()),brdSize+(144*xwMM()),91*xwMM(),128*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.4);
         xwSetFrameF(xwGetFrameCount(),0.4);
         xwSetFrameC(xwGetFrameCount(),0);
         if (afText!=NULL)
         {
            xwSetFontName(xwGetFrameCount(),afTextFont);
            xwSetFontSize(xwGetFrameCount(),afTextFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),afText);
            xwSetFontMode(xwGetFrameCount(),0);
            xwSetFontColor(xwGetFrameCount(),afTextColor);
         }
      }
      else
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(144*xwMM()),182*xwMM(),128*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.2);
         xwSetFrameF(xwGetFrameCount(),0.2);
         xwSetFrameC(xwGetFrameCount(),0);
         if (afText!=NULL)
         {
            xwSetFontName(xwGetFrameCount(),afTextFont);
            xwSetFontSize(xwGetFrameCount(),afTextFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),afText);
            xwSetFontMode(xwGetFrameCount(),0);
            xwSetFontColor(xwGetFrameCount(),afTextColor);
         }
      }
   }
   /* VHS Cover */
   else if ( (afCoverType==4) && (xwGetPaperXSize()-(2*brdSize)>=190*xwMM()) && (xwGetPaperYSize()-(2*brdSize)>=266*xwMM()) )
   {
      /* VHS Cover 266 x 190 - 118 118 30 */
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,190*xwMM(),266*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);

      if (xwExist(afPictureA)==xwTrue)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(6*xwMM()),brdSize+(1*xwMM()),10*xwMM(),116*xwMM());
         xwSetFrameB(xwGetFrameCount(),0);
         xwSetFrameF(xwGetFrameCount(),0);
         xwSetFrameC(xwGetFrameCount(),0);
         xwSetFontName(xwGetFrameCount(),afTitleFont);
         xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afTitle);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTitleColor);
               
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(17*xwMM()),brdSize+(5*xwMM()),168*xwMM(),108*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.4);
         xwSetFrameF(xwGetFrameCount(),0.4);
         xwSetFrameC(xwGetFrameCount(),0);
         xwFPLoad(afPictureA);
         rot=afRotationA;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }

         xwRotatePicInFrame(rotateLeft);
      }
      else
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(90*xwMM()),brdSize+(1*xwMM()),10*xwMM(),116*xwMM());
         xwSetFrameB(xwGetFrameCount(),0);
         xwSetFrameF(xwGetFrameCount(),0);
         xwSetFrameC(xwGetFrameCount(),0);
         xwSetFontName(xwGetFrameCount(),afTitleFont);
         xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afTitle);
         xwSetFontMode(xwGetFrameCount(),1);
         xwSetFontColor(xwGetFrameCount(),afTitleColor);
      }

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(123*xwMM()),188*xwMM(),20*xwMM());
      xwSetFrameB(xwGetFrameCount(),0);
      xwSetFrameF(xwGetFrameCount(),0);
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),0);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);

      if (xwExist(afPictureB)==xwTrue)
      {
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(149*xwMM()),90*xwMM(),116*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.4);
         xwSetFrameF(xwGetFrameCount(),0.4);
         xwSetFrameC(xwGetFrameCount(),0);
         if (xwExist(afPictureB)==xwTrue)
         {
            xwFPLoad(afPictureB);
            rot=afRotationB;
            if ((rot==-180) || (rot==180))
            {
               xwRotatePicInFrame(rotateLeft);
               xwRotatePicInFrame(rotateLeft);
            }
            else if (rot==-90)
            {
               xwRotatePicInFrame(rotateLeft);
            }
            else if (rot==90)
            {
               xwRotatePicInFrame(rotateRight);
            }

            xwRotatePicInFrame(rotateLeft);
         }

         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(92*xwMM()),brdSize+(149*xwMM()),97*xwMM(),116*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.4);
         xwSetFrameF(xwGetFrameCount(),0.4);
         xwSetFrameC(xwGetFrameCount(),0);
         if (afText!=NULL)
         {
            xwSetFontName(xwGetFrameCount(),afTextFont);
            xwSetFontSize(xwGetFrameCount(),afTextFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),afText);
            xwSetFontMode(xwGetFrameCount(),0);
            xwSetFontColor(xwGetFrameCount(),afTextColor);
         }
      }
      else
      {/* VHS Cover 266 x 190 - 118 118 30 */
         xwAddFrame();
         xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(149*xwMM()),188*xwMM(),116*xwMM());
         xwSetFrameB(xwGetFrameCount(),0.2);
         xwSetFrameF(xwGetFrameCount(),0.2);
         xwSetFrameC(xwGetFrameCount(),0);
         if (afText!=NULL)
         {
            xwSetFontName(xwGetFrameCount(),afTextFont);
            xwSetFontSize(xwGetFrameCount(),afTextFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),afText);
            xwSetFontMode(xwGetFrameCount(),0);
            xwSetFontColor(xwGetFrameCount(),afTextColor);
         }
      }
   }
   /* ZIP Cover */
   else if ( (afCoverType==5) && (xwGetPaperXSize()-(2*brdSize)>=98*xwMM()) && (xwGetPaperYSize()-(2*brdSize)>=214*xwMM()) )
   {
      /* 116 x 98 - 10 7 99 */
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,98*xwMM(),98*xwMM());
      xwSetFrameB(xwGetFrameCount(),1);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      if (afText!=NULL)
      {
         xwSetFontName(xwGetFrameCount(),afTextFont);
         xwSetFontSize(xwGetFrameCount(),afTextFontSize);
         xwSetFontDirection(xwGetFrameCount(),3);
         xwSetFontText(xwGetFrameCount(),afText);
         xwSetFontMode(xwGetFrameCount(),0);
         xwSetFontColor(xwGetFrameCount(),afTextColor);
      }
      if (xwExist(afPictureB)==xwTrue)
      {
         xwFPLoad(afPictureB);
         rot=afRotationB;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }

         xwRotatePicInFrame(rotateLeft);
      }

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize+(98*xwMM()),98*xwMM(),99*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);
      
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(1*xwMM()),brdSize+(99*xwMM()),10*xwMM(),97*xwMM());
      xwSetFrameB(xwGetFrameCount(),0);
      xwSetFrameF(xwGetFrameCount(),0);
      xwSetFrameC(xwGetFrameCount(),0);
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),3);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);
            
      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize+(11*xwMM()),brdSize+(99*xwMM()),86*xwMM(),97*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);      
      if (xwExist(afPictureA)==xwTrue)
      {
         xwFPLoad(afPictureA);
         rot=afRotationA;
         if ((rot==-180) || (rot==180))
         {
            xwRotatePicInFrame(rotateLeft);
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==-90)
         {
            xwRotatePicInFrame(rotateLeft);
         }
         else if (rot==90)
         {
            xwRotatePicInFrame(rotateRight);
         }

         xwRotatePicInFrame(rotateLeft);
      }

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize+(197*xwMM()),98*xwMM(),7*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0);   
      xwSetFontName(xwGetFrameCount(),afTitleFont);
      xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
      xwSetFontDirection(xwGetFrameCount(),0);
      xwSetFontText(xwGetFrameCount(),afTitle);
      xwSetFontMode(xwGetFrameCount(),1);
      xwSetFontColor(xwGetFrameCount(),afTitleColor);

      xwAddFrame();
      xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize+(204*xwMM()),98*xwMM(),10*xwMM());
      xwSetFrameB(xwGetFrameCount(),0.2);
      xwSetFrameF(xwGetFrameCount(),0.2); /* 0.5 mm line */
      xwSetFrameC(xwGetFrameCount(),0); 
   }

   return;
}