/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWASSCONTACTPRINT_H
#define _XWASSCONTACTPRINT_H

#include <forms.h>

#include <ctype.h>
#include <dirent.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/stat.h>
#include <unistd.h>

typedef struct assprintcontactprintform
{
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;

   FL_OBJECT         *title;
   FL_OBJECT         *titleCol;
   FL_OBJECT         *titleFont;

   FL_OBJECT         *number;

   FL_OBJECT         *page;

   FL_OBJECT         *path;
   FL_OBJECT         *pathSelect;

   FL_OBJECT         *preview;
   FL_OBJECT         *print;
   FL_OBJECT         *menu;
} assprintcontactprintform;

/* Display About Box */
void assPrintContactPrint(FL_FORM *form);
/* Create Page */
void assPrintContactPrintPage(int mo);
/* Compare for Sort */
int assPrintContactPrintSort(const void *Z1,const void *Z2);

#endif