/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ass-contactprint.h"

#include "assistent.h"
#include "base.h"
#include "color.h"
#include "fileio.h"
#include "fileselect.h"
#include "font.h"
#include "frame.h"
#include "gfx.h"
#include "limits.h"
#include "lowlevel.h"
#include "paper.h"
#include "picture.h"
#include "picbrowser.h"
#include "progress.h"
#include "resource.h"
#include "wysiwyg.h"
#include "x11.h"

static struct assprintcontactprintform      af;

static char             afTitle[256]="";
static char             afTitleFont[1024]="Courier";
static int              afTitleFontSize=17;
static int              afTitleFontUnderline=0;
static int              afTitleColor=0;

static int              afNumbers=2;

static int              afPaper=1;

static char             afPath[1024]="";

static FL_FORM          *assForm;

/* Directory Buffer */
static char                *dbuf[4096];
static int                 dentrys=-1;

/* Print Contact Print GUI */
void assPrintContactPrint(FL_FORM *form)
{
   char              astr[1024],bstr[1024],cstr[1024];
   int               az;

   if (strlen(afPath)==0) strcpy(afPath,xwGetFile("//",""));

   assForm=form;

   xwHideAssistent();

   /* Geometry 5 40 680 424 / 7 42 */

   fl_addto_form(form);

   fl_set_border_width(1);

   af.title = fl_add_input(FL_NORMAL_INPUT,141,41,440,20,xwGR(1,"ass.cpTitle","Title:"));
   af.titleCol = fl_add_button(FL_NORMAL_BUTTON,581,41,20,20,"");
   xwSetRGBC(26,afTitleColor);
   fl_set_object_color(af.titleCol,26,26);
   af.titleFont = fl_add_button(FL_NORMAL_BUTTON,601,41,80,20,xwGR(1,"ass.Font","Font"));
   fl_set_input_maxchars(af.title,255);
   fl_set_input_return(af.title,FL_RETURN_CHANGED);
   fl_set_input(af.title,afTitle);

   af.number = fl_add_choice(FL_DROPLIST_CHOICE,141,62,540,20,xwGR(1,"ass.cpPageNumbers","PageNumber:"));
   fl_set_object_boxtype(af.number,FL_UP_BOX);
   fl_addto_choice(af.number,xwGR(1,"ass.cpNoPageNumber","No Page Numbers"));
   fl_addto_choice(af.number,xwGR(1,"ass.cpWithPageNumber","With Page Numbers"));
   fl_set_choice(af.number,afNumbers);

   af.page = fl_add_choice(FL_DROPLIST_CHOICE,141,83,540,20,xwGR(1,"ass.cpPaperOrientation","Paper Orientation:"));
   fl_set_object_boxtype(af.page,FL_UP_BOX);
   fl_addto_choice(af.page,xwGR(1,"ass.cpPortrait","Portrait"));
   fl_addto_choice(af.page,xwGR(1,"ass.cpLandscape","Landscape"));
   fl_set_choice(af.page,afPaper);

   af.path = fl_add_input(FL_NORMAL_INPUT,141,104,440,20,xwGR(1,"ass.cpPicturePath","Picture Path:"));
   fl_set_input_maxchars(af.path,1023);
   fl_set_input_return(af.path,FL_RETURN_CHANGED);
   fl_set_input(af.path,afPath);

   af.pathSelect = fl_add_button(FL_NORMAL_BUTTON,581,104,100,20,xwGR(1,"ass.cpPathSelection","Path Selection"));

   af.preview = fl_add_button(FL_NORMAL_BUTTON,7,417,224,45,xwGR(1,"ass.Preview","Preview\nPage"));
   fl_set_object_lsize(af.preview,FL_NORMAL_SIZE);
   af.print = fl_add_button(FL_NORMAL_BUTTON,233,417,224,45,xwGR(1,"ass.Print","Print\nPage"));
   fl_set_object_lsize(af.print,FL_NORMAL_SIZE);
   af.menu = fl_add_button(FL_NORMAL_BUTTON,459,417,224,45,xwGR(1,"ass.Menu","Return\nto\nMenu"));
   fl_set_object_lsize(af.menu,FL_NORMAL_SIZE);

   fl_end_form();

   af.ready=0;
   while (af.ready==0)
   {
      af.obj=fl_do_forms();

      /* Menu */
      if (af.obj==af.menu)
      {
         /* create page */
         assPrintContactPrintPage(2);

         xwGFXLandscape(0);

         af.ready=-1;
      }

      /* Preview */
      else if (af.obj==af.preview)
      {
         fl_deactivate_form(assForm);

         /* create page */
         assPrintContactPrintPage(0);

         /*xwPreviewAssistent();*/

         fl_activate_form(assForm);
      }

      /* Print */
      else if (af.obj==af.print)
      {
         fl_deactivate_form(assForm);

         /* create page */
         assPrintContactPrintPage(1);

         /*xwPrintAssistent(0);*/

         fl_activate_form(assForm);
      }

      /* Title */
      else if (af.obj==af.title)
      {
         strcpy(afTitle,fl_get_input(af.title));
      }
      /* Title Color */
      else if (af.obj==af.titleCol)
      {
         afTitleColor=xwColorMixer(assForm,26,afTitleColor);
         fl_redraw_object(af.titleCol);
      }
      /* Title Font */
      else if (af.obj==af.titleFont)
      {
         fl_deactivate_form(assForm);

         xwFontSelect(xwfSelect,afTitleFont,&afTitleFontSize,&afTitleFontUnderline);

         fl_activate_form(assForm);
      }

      /* Page Numbers */
      else if (af.obj==af.number)
      {
         az=fl_get_choice(af.number);
         if (az>-1)
         {
            afNumbers=az;
         }
      }

      /* Paper Orientation */
      else if (af.obj==af.page)
      {
         az=fl_get_choice(af.page);
         if (az>-1)
         {
            afPaper=az;
         }
      }

      /* Picture Path */
      else if (af.obj==af.path)
      {
         strcpy(afPath,fl_get_input(af.path));
      }

      /* Path Selection */
      else if (af.obj==af.pathSelect)
      {
         fl_deactivate_form(assForm);
         xwSetFSPath(afPath);
         xwSetFSPattern("");
         strcpy(astr,xwGR(1,"fs.SelectDrawer","Select Drawer, please..."));
         strcpy(bstr,xwGR(1,"fs.OK","OK"));
         strcpy(cstr,xwGR(1,"fs.Abort","Abort"));
         strcpy(astr,xwFileSelect(fsPathAll,"",astr,bstr,cstr));
         if (strlen(astr)>0)
         {
            strcpy(afPath,astr);
            fl_set_input(af.path,afPath);
         }
         fl_activate_form(assForm);
      }
   }

   xwRemoveObject(af.title);
   xwRemoveObject(af.titleCol);
   xwRemoveObject(af.titleFont);
   xwRemoveObject(af.number);
   xwRemoveObject(af.page);
   xwRemoveObject(af.path);
   xwRemoveObject(af.pathSelect);

   xwRemoveObject(af.preview);
   xwRemoveObject(af.print);
   xwRemoveObject(af.menu);

   /* clear panel */
   fl_winset(assForm->window);
   fl_rectf(7,42,676,420,FL_COL1);

   xwShowAssistent();

   return;
}

/* Create Page */
void assPrintContactPrintPage(int mo)
{
   int               brdSize;
   int               ax,ay;

   int               pageNr;
   int               picNr;

   int               xOffset;
   int               yOffset;
   int               xPicCount;
   int               yPicCount;

   DIR               *dirz;
   struct dirent     *direntz;
   struct stat       attribut;
   struct stat       attribB;
   char              path[1024];
   int               pFlag;
   char              *strptr;
   
   if ( (dirz = opendir(afPath)) != NULL )
   {
      while ( (direntz = readdir(dirz)) != NULL)
      {
         if ( strcmp(direntz->d_name,".") && strcmp(direntz->d_name,"..") )
         {
            strcpy(path,afPath);
            strcat(path,"/");
            strcat(path,direntz->d_name);

            pFlag=0;
            if ( stat(path,&attribut) == 0)
            {
               if (lstat(path,&attribB) == 0)
               {
                  if (S_ISLNK(attribB.st_mode))
                  {
                     if (S_ISREG(attribut.st_mode)) pFlag=1;
                  }
                  else
                  {
                     if (S_ISREG(attribut.st_mode)) pFlag=1;;
                  }
               }
            }

            /* write into array */
            if (pFlag==1)
            {
               if ((xwCheckGFXFile(path)==0) && (dentrys<4095))
               {
                  dentrys++;
                  dbuf[dentrys] = (char*) malloc(strlen(path)+1);
                  if (dbuf[dentrys] != NULL) strcpy(dbuf[dentrys],path);
               }
            }
         }
      }

      closedir(dirz);
   }
  /* sort directory */
   if (dentrys > -1) qsort(dbuf,dentrys+1,sizeof(dbuf[0]),assPrintContactPrintSort);

   /* get highest bordersize */
   brdSize=0;

   ax=xwGetPaperTB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperBB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperLB();
   if (ax>brdSize) brdSize=ax;
   ax=xwGetPaperRB();
   if (ax>brdSize) brdSize=ax;

   /* remove all frames */
   xwFreeFrames(-1);
   xwFreePicture(-1);

   /* Portrait */
   xwSetPaperLS(xwPortrait);

   /* page number */
   pageNr=1;
   picNr=-1;

   /* Calculate Picture Count per Page */

   /* landscape */
   if (afPaper==2)
   {
      xPicCount=(int) ((float) (xwGetPaperXSize()-((2*brdSize)+(11*xwMM())))/(float) (36*xwMM()));
      xOffset=brdSize+(11*xwMM());

      yPicCount=(int) ((float) (xwGetPaperYSize()-(2*brdSize))/(float) (31*xwMM()));
      yOffset=( ( xwGetPaperYSize()-(yPicCount*(31*xwMM())) ) -1)/2;
   }
   else
   {
      xPicCount=(int) ((float) (xwGetPaperXSize()-(2*brdSize))/(float) (31*xwMM()));
      xOffset=( ( xwGetPaperXSize()-(xPicCount*(31*xwMM())) )-1)/2;

      yPicCount=(int) ((float) (xwGetPaperYSize()-((2*brdSize)+(11*xwMM())))/(float) (36*xwMM()));
      yOffset=brdSize+(11*xwMM());
   }

   xwLockProgress();

   /* next page */
   while (picNr<dentrys)
   {
      /* remove all frames */
      xwFreeFrames(-1);
      xwFreePicture(-1);

      /* landscape */
      if (afPaper==2)
      {
         /* with page numbers */
         if (afNumbers==2)
         {
            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize+(20*xwMM()),10*xwMM(),(xwGetPaperYSize()-(2*brdSize))-(20*xwMM()));
            xwSetFrameB(xwGetFrameCount(),2.2);
            xwSetFrameF(xwGetFrameCount(),0.5);
            xwSetFrameC(xwGetFrameCount(),0);
            xwSetFontName(xwGetFrameCount(),afTitleFont);
            xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),afTitle);
            xwSetFontMode(xwGetFrameCount(),1);
            xwSetFontColor(xwGetFrameCount(),afTitleColor);

            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,10*xwMM(),(20*xwMM()));
            xwSetFrameB(xwGetFrameCount(),2.0);
            xwSetFrameF(xwGetFrameCount(),0.5);
            xwSetFrameC(xwGetFrameCount(),0);
            xwSetFontName(xwGetFrameCount(),afTitleFont);
            xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),IntStr(pageNr));
            xwSetFontMode(xwGetFrameCount(),1);
            xwSetFontColor(xwGetFrameCount(),afTitleColor);
         }
         else
         {
            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,10*xwMM(),(xwGetPaperYSize()-(2*brdSize)));
            xwSetFrameB(xwGetFrameCount(),2.2);
            xwSetFrameF(xwGetFrameCount(),0.5);
            xwSetFrameC(xwGetFrameCount(),0);
            xwSetFontName(xwGetFrameCount(),afTitleFont);
            xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
            xwSetFontDirection(xwGetFrameCount(),3);
            xwSetFontText(xwGetFrameCount(),afTitle);
            xwSetFontMode(xwGetFrameCount(),1);
            xwSetFontColor(xwGetFrameCount(),afTitleColor);
         }

         /* create picture entrys */
         for (ay=0 ; ay<xPicCount ; ay++)
         {
            for (ax=0 ; ax<yPicCount ; ax++)
            {
               picNr++;
               if (picNr<=dentrys)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xOffset+(ay*(36*xwMM())),(xwGetPaperYSize()-yOffset)-(ax*(31*xwMM()))-(30*xwMM()),30*xwMM(),30*xwMM());
                  xwSetFrameB(xwGetFrameCount(),0.5);
                  xwSetFrameF(xwGetFrameCount(),0.5);
                  xwSetFrameC(xwGetFrameCount(),0);
                  xwFPLoad(dbuf[picNr]);
                  xwRotatePicInFrame(rotateLeft);

                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xOffset+(ay*(36*xwMM()))+(30*xwMM()),(xwGetPaperYSize()-yOffset)-(ax*(31*xwMM()))-(30*xwMM()),5*xwMM(),30*xwMM());
                  xwSetFrameB(xwGetFrameCount(),1.0);
                  xwSetFrameF(xwGetFrameCount(),0.5);
                  xwSetFrameC(xwGetFrameCount(),0);
                  xwSetFontName(xwGetFrameCount(),afTitleFont);
                  xwSetFontSize(xwGetFrameCount(),8);
                  xwSetFontDirection(xwGetFrameCount(),3);
                  strptr=strrchr(dbuf[picNr],'/');
                  strptr=strptr+1;
                  xwSetFontText(xwGetFrameCount(),strptr);
                  xwSetFontMode(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afTitleColor);
               }
               else
               {
                  picNr--;
               }
            }
         }

      }
      else
      {
         /* Portrait */

         /* with page numbers */
         if (afNumbers==2)
         {
            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,(xwGetPaperXSize()-(2*brdSize))-(20*xwMM()),10*xwMM());
            xwSetFrameB(xwGetFrameCount(),2.2);
            xwSetFrameF(xwGetFrameCount(),0.5);
            xwSetFrameC(xwGetFrameCount(),0);
            xwSetFontName(xwGetFrameCount(),afTitleFont);
            xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
            xwSetFontDirection(xwGetFrameCount(),0);
            xwSetFontText(xwGetFrameCount(),afTitle);
            xwSetFontMode(xwGetFrameCount(),1);
            xwSetFontColor(xwGetFrameCount(),afTitleColor);

            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),brdSize+(xwGetPaperXSize()-(2*brdSize))-(20*xwMM()),brdSize,20*xwMM(),10*xwMM());
            xwSetFrameB(xwGetFrameCount(),2.0);
            xwSetFrameF(xwGetFrameCount(),0.5);
            xwSetFrameC(xwGetFrameCount(),0);
            xwSetFontName(xwGetFrameCount(),afTitleFont);
            xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
            xwSetFontDirection(xwGetFrameCount(),0);
            xwSetFontText(xwGetFrameCount(),IntStr(pageNr));
            xwSetFontMode(xwGetFrameCount(),1);
            xwSetFontColor(xwGetFrameCount(),afTitleColor);
         }
         else
         {
            xwAddFrame();
            xwSetFrameGeo(xwGetFrameCount(),brdSize,brdSize,(xwGetPaperXSize()-(2*brdSize)),10*xwMM());
            xwSetFrameB(xwGetFrameCount(),2.2);
            xwSetFrameF(xwGetFrameCount(),0.5);
            xwSetFrameC(xwGetFrameCount(),0);
            xwSetFontName(xwGetFrameCount(),afTitleFont);
            xwSetFontSize(xwGetFrameCount(),afTitleFontSize);
            xwSetFontDirection(xwGetFrameCount(),0);
            xwSetFontText(xwGetFrameCount(),afTitle);
            xwSetFontMode(xwGetFrameCount(),1);
            xwSetFontColor(xwGetFrameCount(),afTitleColor);
         }

         /* create picture entrys */
         for (ay=0 ; ay<yPicCount ; ay++)
         {
            for (ax=0 ; ax<xPicCount ; ax++)
            {
               picNr++;
               if (picNr<=dentrys)
               {
                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xOffset+(ax*(31*xwMM())),yOffset+(ay*(36*xwMM())),30*xwMM(),30*xwMM());
                  xwSetFrameB(xwGetFrameCount(),0.5);
                  xwSetFrameF(xwGetFrameCount(),0.5);
                  xwSetFrameC(xwGetFrameCount(),0);
                  xwFPLoad(dbuf[picNr]);

                  xwAddFrame();
                  xwSetFrameGeo(xwGetFrameCount(),xOffset+(ax*(31*xwMM())),yOffset+(ay*(36*xwMM()))+(30*xwMM()),30*xwMM(),5*xwMM());
                  xwSetFrameB(xwGetFrameCount(),1.0);
                  xwSetFrameF(xwGetFrameCount(),0.5);
                  xwSetFrameC(xwGetFrameCount(),0);
                  xwSetFontName(xwGetFrameCount(),afTitleFont);
                  xwSetFontSize(xwGetFrameCount(),8);
                  xwSetFontDirection(xwGetFrameCount(),0);
                  strptr=strrchr(dbuf[picNr],'/');
                  strptr=strptr+1;
                  xwSetFontText(xwGetFrameCount(),strptr);
                  xwSetFontMode(xwGetFrameCount(),1);
                  xwSetFontColor(xwGetFrameCount(),afTitleColor);
               }
               else
               {
                  picNr--;
               }
            }
         }
      }

      /* first page */
      if (pageNr==1)
      {
         /* Preview */
         if (mo==0)
         {
            xwUnLockProgress();
            xwCloseProgress();
            xwPreviewAssistent();
            picNr=dentrys;
         }
         else if (mo==1)
         {
            xwPrintAssistent(0);
            /* Abort Printing */
            if (xwCheckPrintAbort()==xwTrue) picNr=dentrys;
         }
         else if (mo==2)
         {
            picNr=dentrys;
         }
      }
      else
      {
         xwPrintAssistent(1);
      }
      pageNr++;
   }

   if (mo!=0)
   {
      xwUnLockProgress();
      xwCloseProgress();
   }
   
   /* copy direntrys into browser */
   for (ax=0 ; ax<=dentrys ; ax++)
   {
      free(dbuf[ax]);
      dbuf[ax] = NULL;
   }
   dentrys=-1;

   return;
}


/* Compare for Sort */
int assPrintContactPrintSort(const void *Z1,const void *Z2) /*fold00*/
{
   const char        **z1=(const char **) Z1;
   const char        **z2=(const char **) Z2;
   char              aas[1024],bbs[1024];

   strcpy(aas,*z1);
   strcpy(bbs,*z2);

   return(strcmp(aas,bbs));
}
