/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "about.h"

#include "base.h"
#include "default.h"
#include "resource.h"
#include "handler.h"
#include "limits.h"
#include "main.h"
#include "main_gui.h"

/* Icon Import */
#include "pixmaps/main_about.xpm"
#include "pixmaps/main_about2.xpm"

/* About Datas */
static struct aboutdef aboutdata[]=
{ /* Text */
   {"@c@bContact Adress:\n@cStefan Kraus\n@cLeipzigerstr. 3a\n@c31848 Bad Mnder\n@c-Germany-\n"},
   {"@c@bEMail-Adress:\n@csjk@weserbergland.de\n"},
   {"@c@bHomepage:\n@chttp://www.stefanjkraus1965.de\n"},
   {"@c@bProject-Page:\n@chttp://xwgui.automatix.de\n@c( hosted by Automatix )\n"},
   {"@c---------------------------------------------------------------------------\n"},
   {"@c@bThanks to\n\n@c@bJean-Jacques Sarton\n@c( http://xwtools.automatix.de )"},
   {"@cfor Testing, Bug-Reports, Corrections, Source-Codes, Ideas and his Program"},
   {"@cxw_Tools. The very best printing Tools.\n"},
   {"@c@c@bVasyl Garkusha\n@cfor Icon-Design and HTML-Programming.\n"},
   {"@c@c@bKarl-Heinz Gnster\n@cfor German Documentation, Testing, Bug-Reports and Ideas.\n"},
   {"@c@c@bAlberto Zanoni ( alberto.zanoni@tiscalinet.it )\n@cfor all italian translations.\n"},
   {"@c@bRainer Menzner\n@cfor the T1Lib library.\n"},
   {"@c@bT.C. Zhao & Mark Overmars\n@cfor the xforms library.\n"},
   
   /* Endmark */
   {"END"}
};


FL_FORM           *abForm;
FL_OBJECT         *abPixmap;
FL_OBJECT         *abMessage;
FL_OBJECT         *abOK;
int               abReady;

/* Display Error Message */
void xwAbout(void) /*fold00*/
{
   char                 astr[1024];
   int                  counter;          /* counter for aboutdata array index */
   int                  adEnd;            /* end of aboutdata reached */

   abForm = fl_bgn_form(FL_UP_BOX, 530,530);
   fl_set_border_width(1);

   abPixmap = fl_add_pixmap(FL_NORMAL_PIXMAP,0,0,530,40,"");
   fl_set_pixmap_data(abPixmap,about_xpm);
   if (xwGetPrefValue(xwgDepth)>8)
   {
      fl_set_pixmap_data(abPixmap,about_xpm);
   }
   else
   {
      fl_set_pixmap_data(abPixmap,main_about2_xpm);
   }
   
   abMessage = fl_add_browser(FL_NORMAL_BROWSER,0,40,530,460,"");
   fl_set_browser_fontstyle(abMessage,FL_FIXED_STYLE);
   fl_add_browser_line(abMessage,"@c '98,'99,'00,'01,'02 by Stefan Kraus\n\n@c@bProgram:\n@cxwGUI\n");

   strcpy(astr,"@c@bVersion:\n@c");
   strcat(astr,xwInfoB);
   strcat(astr,"\n\n@c@bAuthor:\n@cStefan Kraus\n");
   fl_add_browser_line(abMessage,astr);
   /*
   strcpy(as,"@cUsed Colors: ");
   strcat(as,IntStr(FL_BUILT_IN_COLS));
   strcat(as,"\n");
   fl_add_browser_line(abMessage,as);
   */
   
   abReady=0;
   counter=0;
   adEnd=xwFalse;
   while (abReady==0)
   {
      strcpy(astr,"aboutline");
      strcat(astr,IntStr(counter));
      if (adEnd==xwFalse)
      {
         if (strcmp(aboutdata[counter].txt,"END") == 0)
         {
             adEnd=xwTrue;
             strcpy(astr,xwGR(1,astr,""));
         }
         else
         {
            strcpy(astr,xwGR(1,astr,aboutdata[counter].txt));
         }
      }
      else
      {
         strcpy(astr,xwGR(1,astr,""));
      }
            
      if (strlen(astr)>0)
      {
         if (strcmp(astr,"END") == 0)
         {
            abReady=-1;
         }
         else
         {
            fl_add_browser_line(abMessage,astr);
         }
      }
      else
      {
         abReady=-1;
      }
      
      counter++;
   }
   
   /*
   fl_add_browser_line(abMessage,xwGR(1,"","@c@bContact Adress:\n@cStefan Kraus\n@cLeipzigerstr. 3a\n@c31848 Bad Mnder\n@c-Germany-\n"));
   fl_add_browser_line(abMessage,xwGR(1,"","@c@bEMail-Adress:\n@csjk@weserbergland.de\n"));
   fl_add_browser_line(abMessage,xwGR(1,"","@c@bHomepage:\n@chttp://www.stefanjkraus1965.de\n"));
   fl_add_browser_line(abMessage,xwGR(1,"","@c@bProject-Page:\n@chttp://xwgui.automatix.de\n@c( hosted by Automatix ))\n");
   fl_add_browser_line(abMessage,xwGR(1,"","@c---------------------------------------------------------------------------\n"));
   fl_add_browser_line(abMessage,"@c@bThanks to\n\n@c@bJean-Jacques Sarton\n@c( http://xwtools.automatix.de )");
   fl_add_browser_line(abMessage,"@cfor Testing, Bug-Reports, Corrections, Source-Codes, Ideas and his Program");
   fl_add_browser_line(abMessage,"@cxw_Tools. The very best printing Tools.\n");
   fl_add_browser_line(abMessage,"@c@c@bVasyl Garkusha\n@cfor Icon-Design and HTML-Programming.\n");
   fl_add_browser_line(abMessage,"@c@c@bKarl-Heinz Gnster\n@cfor German Documentation, Testing, Bug-Reports and Ideas.\n");
   fl_add_browser_line(abMessage,"@c@c@bAlberto Zanoni ( alberto.zanoni@tiscalinet.it )\n@cfor all italian translations.\n");

   fl_add_browser_line(abMessage,"@c@bThanks to\n@cT.C. Zhao & Mark Overmars\n@cfor the xforms library.\n");
   */
   
   strcpy(astr,"@cXForms Version: ");
   strcat(astr,IntStr(FL_VERSION));
   strcat(astr,".");
   strcat(astr,IntStr(FL_REVISION));
   strcat(astr,".");
   strcat(astr,IntStr(FL_FIXLEVEL));
   strcat(astr,"\n");
   fl_add_browser_line(abMessage,astr);
   
   fl_add_browser_line(abMessage,"@c---------------------------------------------------------------------------\n");
   fl_add_browser_line(abMessage,"@c@bLicense:\n@cGNU General Public License\n");
   fl_add_browser_line(abMessage,"@cxwGUI -- an X11-GUI for xw_print");
   fl_add_browser_line(abMessage,"@cCopyright (C) 1998,1999,2000,2001 Stefan Kraus\n");
   fl_add_browser_line(abMessage,"@cThis program is free software; you can redistribute it and/or modify");
   fl_add_browser_line(abMessage,"@cit under the terms of the GNU General Public License as published by");
   fl_add_browser_line(abMessage,"@cthe Free Software Foundation; either version 2 of the License, or");
   fl_add_browser_line(abMessage,"@c(at your option) any later version.\n");
   fl_add_browser_line(abMessage,"@cThis program is distributed in the hope that it will be useful,");
   fl_add_browser_line(abMessage,"@cbut WITHOUT ANY WARRANTY; without even the implied warranty of");
   fl_add_browser_line(abMessage,"@cMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
   fl_add_browser_line(abMessage,"@cGNU General Public License for more details.\n");
   fl_add_browser_line(abMessage,"@cYou should have received a copy of the GNU General Public License");
   fl_add_browser_line(abMessage,"@calong with this program; if not, write to the Free Software");
   fl_add_browser_line(abMessage,"@cFoundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.");

   abOK=fl_add_button(FL_NORMAL_BUTTON,215,505,100,20,xwGR(1,"abOK","OK"));
   
   fl_end_form();

   if (xwGetPrefValue(xwgWinPos)==0)
   {
      fl_prepare_form_window(abForm,FL_PLACE_MOUSE,FL_TRANSIENT,"Info");
   }
   else
   {
      fl_prepare_form_window(abForm,FL_PLACE_CENTER,FL_TRANSIENT,"Info");
   }

   fl_set_form_dblbuffer(abForm,0);
   fl_show_form_window(abForm);

   fl_set_app_mainform(abForm);

   /* Exit Handler */
   fl_set_form_atclose(abForm,nclose_cb,(void *) "1");

   abReady=0;
   while (abReady==0)
   {
      if (abOK==fl_do_forms()) abReady=1;   
   }

   fl_hide_form(abForm);
   fl_free_pixmapbutton_pixmap(abPixmap);
   fl_free_form(abForm);

   fl_set_app_mainform(xwGetMainGui());

   return;
}
