/* usb-ieee1284: Program for reading IEEE-1284 Plug'n'Play configuration
   interface from a USB parallel interface.

   Copyright 2000 Yggdrasil Computing, Inc.

   This program may be copied under the terms and conditions of version
   2 of the GNU General Public License, as published by the Free Software
   Foundation.

   Portions of this program are derived from usbutils, which was
   written by Thomas Sailer and Joannes Erdfelt, and is also copyable
   under the terms and conditions of version 2 of the GNU General Public
   License.

*/

#include <usb.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/file.h>

#include <linux/types.h>
#include <linux/ioctl.h>
#include <linux/version.h>

#define _GNU_SOURCE
#include <getopt.h>

#define USB_MAX_PACKET_SIZE	4096

#define USB_DIR_IN		0x80

#define USB_REQ_GET_DEVICE_ID	0

struct usb_proc_ctrltransfer {
        __u8 requesttype;
        __u8 request;
        __u16 value;
        __u16 index;
        __u16 length;
        __u32 timeout;  /* in milliseconds */
        void *data;
};

#define USB_PROC_CONTROL           _IOWR('U', 0, struct usb_proc_ctrltransfer)


static struct option long_options[] = {
	{ "alternate", 1, NULL, 'a'},
	{ "config", 1, NULL, 'c'},
	{ "interface", 1, NULL, 'i'},
};

static unsigned char result[USB_MAX_PACKET_SIZE];

static void
usage(void) {
	fprintf (stderr,
		 "Usage: usb-ieee [--alternate=nn] "
		 "[--config=nn] [--interface=nn]\n");
	fprintf (stderr, "Example: usb-ieee1284 /proc/usb/usb/001/002\n");
  	
}

int
main(int argc, char **argv) {
  	int fd;
        struct usb_proc_ctrltransfer ctrl;
	int optchar;
	int config = 0;
	int interface = 0;
	int altsetting = 0;
	int len;

	if (argc < 2) {
	  	usage();
		exit(1);
	}
	  

	for(;;) {
	  	int longindex;
		optchar = getopt_long_only(argc, argv, "",
					   long_options, &longindex);
		if (optchar == -1) break;
		switch(optchar) {
		case 'a': altsetting = atoi(optarg); break;
		case 'c': config = atoi(optarg); break;
		case 'i': interface = atoi(optarg); break;
		default:
			usage();
			exit(1);
			/*NOTREACHED*/
		}
	}
	argv += optind - 1;
	argc -= optind - 1;

	if (argc != 2) {
	  	usage();
		exit(1);
	}

	if ((fd = open (argv[1], O_RDWR)) < 0) {
	  	perror(argv[1]);
		exit(1);
	}

        ctrl.requesttype = USB_DIR_IN | USB_TYPE_CLASS | USB_RECIP_INTERFACE;
        ctrl.request = USB_REQ_GET_DEVICE_ID; /* 0 */
        ctrl.value = config;
        ctrl.index = (interface << 8) | altsetting;
        ctrl.length = sizeof(result);
        ctrl.data = &result;

        if (ioctl(fd, USB_PROC_CONTROL, &ctrl) < 0) {
	  	perror ("ioctl");
		exit(1);
	}
	len = (result[0] << 8) | result[1];
	if (len > 0 && len < sizeof(result) - 2) {
		result[len+2] = '\0';
		printf ("%s\n", result+2);
	}
	return 0;
}
