/*
** ~ppr/src/rpprd/rpprd_socket.c
** Copyright 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** This file was last modified 23 September 1996.
*/

#include "global_defines.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <string.h>
#include "rpprd.h"

/*
** Open the socket over which we receive connexions from remote systems.
*/
int open_socket(void)
    {
    int sockfd;
    struct sockaddr_in sin;
    int one = 1;
    
    DODEBUG(("open_socket()"));

    if( (sockfd=socket(AF_INET, SOCK_STREAM, 0)) == -1 )
    	fatal(0, "socket() failed, errno=%d (%s)", errno, strerror(errno));

    if( setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, (char*)&one, sizeof(one)) == -1 )
	fatal(0, "setsockopt() failed, errno=%d (%s)", errno, strerror(errno));
    
    memset(&sin, 0, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = htonl(INADDR_ANY);
    sin.sin_port = htons(RPPRD_PORT);
    
    if( bind(sockfd, (struct sockaddr *)&sin, sizeof(sin)) == -1 )
    	fatal(0, "bind() failed, errno=%d (%s)", errno, strerror(errno));

    if( listen(sockfd, 5) == -1 )
    	fatal(0, "listen() failed, errno=%d (%s)", errno, strerror(errno));

    DODEBUG(("open_socket(): done"));

    return sockfd;
    } /* end of open_socket() */

/* end of file */
