/*
** ~ppr/src/rpprd/rpprd_fifo.c
** Copyright 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
**
** This file was last modified 23 September 1996.
*/

#include "global_defines.h"
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include "rpprd.h"

int open_fifo(void)
    {
    int rfd, wfd;
    int flags;
    
    DODEBUG(("open_fifo()"));

    /* remove old FIFO */
    unlink(FIFO_NAME_RPPRD);

    /* make new one */
    if( mkfifo(FIFO_NAME_RPPRD, S_IRUSR | S_IWUSR) == -1 )
        fatal(0, "can't make FIFO, errno=%d (%s)", errno, strerror(errno) );

    /* Open the end which we will read from. */
    if( (rfd=open(FIFO_NAME_RPPRD, O_RDONLY | O_NONBLOCK)) == -1 )
	fatal(0, "can't open FIFO for read, errno=%d (%s)", errno, strerror(errno) );

    /* Open a write end when will prevent problems. */
    if( (wfd=open(FIFO_NAME_RPPRD, O_WRONLY)) == -1 )
	fatal(0,"can't open FIFO for write, errno=%d (%s)", errno, strerror(errno) );

    /* Clear the non-block flag for rfd. */
    flags = fcntl(rfd, F_GETFL);
    flags &= ~O_NONBLOCK;
    fcntl(rfd, F_SETFL, flags);

    /* Set the two FIFO descriptors to close on exec(). */
    flags = fcntl(rfd, F_GETFD);
    flags |= FD_CLOEXEC;
    fcntl(rfd, F_SETFD, flags);

    flags = fcntl(wfd, F_GETFD);
    flags |= FD_CLOEXEC;
    fcntl(wfd, F_SETFD, flags);

    DODEBUG(("open_fifo(): done"));

    return rfd;
    } /* end of open_fifo() */

static void fifo_read_handler(int fifo)
    {
    char command[256];
    int len;

    DODEBUG(("reading FIFO"));

    if( (len=read(fifo, command, sizeof(command))) == -1 )
	fatal(0, "read() on fifo failed, errno=%d (%s)", errno, strerror(errno) );

    DODEBUG(("command len = %d", len));

    if( len <= 0 )
	fatal(0, "read() returned %d", len);
	    
    if( command[len-1] != '\n' )
	{
	DODEBUG(("truncated command"));
	return;
	}

    command[len-1] = (char)NULL;

    DODEBUG(("command is \"%s\"", command));



    } /* end of fifo_read_handler() */

