#!/usr/bin/perl
#
# ~ppr/src/responders/pprpopup.perl
# Copyright 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
# 
# Last modified 26 February 1997.
#

#
# This program will send a response to the Tcl/Tk script "pprpopup" 
# which is likely running # on a MS-Windows 95 machine.
#
# This program requires Perl 5.0 or later.
#

# Filled in when script installed.
$HOMEDIR = "?";

# Pull in the list of values for the response code.
require 5.000;
unshift(@INC, "$HOMEDIR/lib");
require 'respond.ph';
require 'pprpopup.pl';

# Split the arguments out into individually named variables.
($for, $addr, $msg, $msg2, $options, $code, $jobid, $extra, $title, $time, $reason, $pages, $charge) = @ARGV;

# Uncomment this code if you don't understand the parameters.
#print "\$for = \"$for\"\n";
#print "\$addr = \"$addr\"\n";
#print "\$msg = \"$msg\"\n";
#print "\$code = $code\n";
#print "\$jobid = \"$jobid\"\n";
#print "\$extra = \"$extra\"\n";
#print "\$title = \"$title\"\n";
#print "\$time = $time\n";
#print "\$reason = \"$reason\"\n";
#print "\$pages = $pages\n";

# Undo the cryptic arrest reason encoding.
$reason =~ s/,/, /g;
$reason =~ s/[|]/ /g;

# Open a connexion to pprpopup
if( ! open_connexion(SEND, $addr) )
  { exit(1); }
SEND->autoflush(1);

# Send the message
print SEND "MESSAGE $for\n";

print SEND "$msg\n";

print SEND "$reason\n" if($reason ne "");

print SEND "The title of this job is \"$title\".\n" if($title ne "");

if($pages ne "?")
  {
  if($pages == 1)
     { print SEND "It is 1 page long.\n"; }
  else
     { print SEND "It is $pags pages long.\n"; }
  }

if($code == $RESP_ARRESTED || $code == $RESP_PRINTER_INCAPABLE || $code == $RESP_GROUP_INCAPABLE)
  {
  print SEND "\nYour job's log file follows:\n";
  print SEND "===================================================================\n";
  while($line=<STDIN>)
    {
    chomp $line;
    print SEND "$line\n";
    }
  }

print SEND ".\n";

# Wait for a reply to our command.
$result = <SEND>;
#print $result;

# Close the connexion to popup.
close(SEND);

# Say we did our job since there is no
# recourse of we didn't. :)
exit 0
