#!/usr/bin/perl
#
# ~ppr/src/responders/audio.perl
# Copyright 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 26 February 1997.
#

# Fool Perl so it will not complain about our already secure PATH and IFS.
$ENV{'PATH'} =~ /^(.*)$/;
$ENV{'PATH'}=$1;
$ENV{'IFS'} =~ /^(.*)$/;
$ENV{'IFS'}=$1;

# These will be filled in when this script is installed:
$HOMEDIR = "/usr/ppr";
$VAR_SPOOL_PPR = "/var/spool/ppr";

unshift(@INC, "$HOMEDIR/lib");
require 'pprpopup.pl';
require 'play_local.pl';
require 'speach.pl';
require 'respond.ph';

# If this is non-zero, then debugging messages will be sent to stdout.
# Such messages will either appear on the terminal from which ppr is run
# or in the pprd log file.
$DEBUG = 0;

# Options:
$OPTION_PRINTED = 1;
$OPTION_CANCELED = 1;
$OPTION_SILLY_SOUNDS = 0;

# The various job response messages:
$msg{$RESP_FINISHED} = ["has been printed on", "X"];
$msg{$RESP_ARRESTED} = ["has been arrested"];
$msg{$RESP_CANCELED} = ["has been canceled"];
$msg{$RESP_CANCELED_PRINTING} = ["was canceled while printing on", "X"];
$msg{$RESP_CANCELED_BADDEST} = ["has been discarded", "because", "the destination", "X", "does not exist"];
$msg{$RESP_CANCELED_REJECTING} = ["has been discarded", "because", "the destination", "X", "is not accepting jobs at this time"];
$msg{$RESP_CANCELED_NOTAUTH} = ["has been discarded", "because", "you are not authorized to print on", "X"];
$msg{$RESP_CANCELED_BADAUTH} = ["has been discarded", "because", "your password was wrong"];
$msg{$RESP_CANCELED_OVERDRAWN} = ["has been discarded", "because", "your account is overdrawn"];
$msg{$RESP_PRINTER_INCAPABLE} = ["has been arrested", "because", "the printer", "X", "is incapable of printing it"];
$msg{$RESP_GROUP_INCAPABLE} = ["has been arrested", "because", "none of the printers in the group", "X", "is capable of printing it"];
$msg{$RESP_CANCELED_NONCONFORMING} = ["has been discarded", "because", "it does not conform to the document structuring convention"];
$msg{$RESP_NOFILTER} = ["has been discarded", "because", "no filter is available to convert it to postscript"];
$msg{$RESP_FATAL} = ["has been discarded", "because", "of a fatal ppr error"];
$msg{$RESP_NOSPOOLER} = ["has been discarded", "because", "the spooler is not running"];
$msg{$RESP_NORSPOOLER} = ["has been discarded", "because", "the remote printing spooler is not running"];
$msg{$RESP_BADMEDIA} = ["has been discarded", "because", "the media you have requested is not recognized"];
$msg{$RESP_BADPJLLANG} = ["has been discarded", "because", "the pjl header requests an unrecognized printer language"];
$msg{$RESP_FATAL_SYNTAX} = ["has been discarded", "because", "there is an error in the ppr command line"];

# Assign names to our arguments:
my($USER, $ADDRESS, $MESSAGE, $MESSAGE2, $OPTIONS, $CODE, $JOBID, $EXTRA, $TITLE, $TIME, $WHY_ARRESTED, $PAGES, $CHARGE) = @ARGV;
my($destnode, $destname, $id, $subid, $homenode) = split(/ /, $JOBID);

# Debugging code:
if($DEBUG)
  {
  $| = 1;
  print "\$USER=\"$USER\", \$ADDRESS=\"$ADDRESS\"\n";
  print "\$MESSAGE=\"$MESSAGE\"\n";
  print "\$CODE=$CODE, \$JOBID=$JOBID, \$EXTRA=\"$EXTRA\"\n";
  print "\$TITLE=\"$TITLE\", \$TIME=\"$TIME\", \$WHY_ARRESTED=\"$WHY_ARRESTED\", \$PAGES=\"$PAGES\"\n";
  print "\$OPTIONS=\"$OPTIONS\"\n"
  }

# Parse the options parameter which is a series of name=value pairs.
my $option;
foreach $option (split(/[\s]+/, $OPTIONS))
  {
  my($name, $value) = split(/=/, $option);

  if($name eq "printed")
    {
    if($value =~ /^[1-9ty]/io)
    	{ $OPTION_PRINTED = 1 }
    else
    	{ $OPTION_PRINTED = 0 }
    }
  if($name eq "canceled")
    {
    if($value =~ /^[1-9ty]/io)
    	{ $OPTION_CANCELED = 1 }
    else
    	{ $OPTION_CANCELED = 0 }
    }
  elsif($name eq "voice")
    {
    speach_voice($value);
    }
  elsif($name eq "silly_sounds")
    {
    if($value =~ /^[ty1-9]/io)
	{ $OPTION_SILLY_SOUNDS = 1 }
    else
	{ $OPTION_SILLY_SOUNDS = 0 }
    }
  }

# If we should not play job done messages and this is one of them, bail out now.
if( ! $OPTION_PRINTED && $CODE == $RESP_FINISHED )
  { exit(0) }

# Same for job canceled messages.
if( ! $OPTION_CANCELED && ($CODE == $RESP_CANCELED || $CODE == $RESP_CANCELED_PRINTING) )
  { exit(0) }

# Start to build a list of words and phrases to be played.
my @playlist;
  
if($id != 0)				# if job had an id assigned,
  {
  # Start with an almost empty playlist:
  @playlist = ('your print job');

  # Add the print job name:
  spellout(\@playlist, $destname);
  spellout(\@playlist, $id);		# say the digits
  #speak_number(\@playlist, $id);	# or pronounce it in high style
  if($subid != 0)
    {
    push(@playlist, "part");
    speak_number(\@playlist, $subid);
    }
  }
else					# if no id assigned,
  {
  @playlist = ('your new print job for');
  spellout(\@playlist, $destname);
  }
  
# Add a parenthetical statement about when it was submitted:
push(@playlist, "which you submitted");
speak_time_interval(\@playlist, time() - $TIME);
push(@playlist, "ago");

# Add the main part of the message:
if( defined($message = $msg{$CODE}) )
  { push(@playlist, @$message); }
else
  { print "audio responder: missing message $CODE\n"; }

# See if we can add to it:
if( $CODE == $RESP_FINISHED && $PAGES ne "?" )
  {
  push(@playlist, "(pause)");
  push(@playlist, "the document is");

  if( $PAGES == 1 )
    {
    push(@playlist, "one page long");
    }
  else
    {
    speak_number(\@playlist, $PAGES);
    push(@playlist, "pages long");
    }
  }

# Replace "X" in the playlist with the spelled out extra parameter:
for($x=0; $x <= $#playlist; $x++)
  {
  if( $playlist[$x] eq "X" )
     {
     @extra = ();
     spellout(\@extra, $EXTRA);
     splice(@playlist, $x, 1, @extra);
     }
  }

#
# Play the selected sound files.
#
if($DEBUG) { print join(' ', @playlist), "\n"; }
play_many_au($ADDRESS, @playlist);

# We are done.
if($DEBUG) { print "Done\n\n"; }
exit(0);
