/*
** ~ppr/src/pprdrv/pprdrv_patch.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 16 December 1996.
*/

#include "global_defines.h"
#include "pprdrv.h"
#include "interface.h"

static int querying = FALSE;
static int result;

/*
** This is called by pprdrv_feedback.c whenever it gets a message.
** If we return TRUE, it will not go into the log file. 
*/
int patchfile_query_callback(char *message)
    {
    if(!querying)
    	return FALSE;

    #ifdef DEBUG_QUERY
    debug("response: %4.4s",message);
    #endif    	

    result = torf(message);
    
    return TRUE;
    } /* end of patchfile_query_callback() */

/*
** Download any *PatchFile if it is not already downloaded.
** Return TRUE if we use ExitServer.
*/
void patchfile(void)
    {
    char *code;
    char *qcode;
    int patch_needed=TRUE;
    char *excode;
    
    #ifdef DEBUG_QUERY
    debug("patchfile()");
    #endif

    /* If there is a patch for this printer. */
    if( (code=find_feature("*PatchFile",(char*)NULL)) != (char*)NULL )
    	{
  	if(printer.feedback)  		/* if queries possible */
	    {
	    #ifdef DEBUG_QUERY
	    debug("Querying for *PatchFile");
	    #endif

	    if( (qcode=find_feature("*?PatchFile", (char*)NULL)) == (char*)NULL )
		fatal(EXIT_PRNERR_NORETRY,"PPD file has *PatchFile but no *?PatchFile");
		
	    printer_putline("%!PS-Adobe-3.0 Query");
	    printer_putline("%%?BeginQuery: PatchFile");
	    printer_puts(qcode);
	    printer_putline("\n%%EndQuery: True");
	    printer_putline("%%EOF");
	    
	    result = ANSWER_UNKNOWN;
	    querying = TRUE;
	    jobbreak();
	    querying = FALSE;
	    
	    /* If no response or uninteligible response, */
	    if(result==ANSWER_UNKNOWN)
		fatal(EXIT_PRNERR_NORETRY,"Printer did not respond to *?PatchFile query");

	    /* If patch is in place, */
	    /* turn off the flag which calls for */
	    /* it to be downloaded. */
	    else if(result==ANSWER_TRUE)
	    	{
		#ifdef DEBUG_QUERY
		debug("Patch is not needed");
		#endif
		patch_needed=FALSE;
		}

	    #ifdef DEBUG_QUERY
	    else
	    	debug("Patch is needed");
	    #endif
	    }

	#ifdef DEBUG_QUERY
	else
	    debug("Queries are not possible, assuming patch is needed");
	#endif

	/* If we decided above that the patch should be */
	/* downloaded. */
	if(patch_needed)
	    {
	    #ifdef DEBUG_QUERY
	    debug("Downloading *PatchFile");
	    #endif

	    if( (excode=find_feature("*ExitServer",(char*)NULL)) == (char*)NULL )
		fatal(EXIT_PRNERR_NORETRY,"PPD file does not have *ExitServer");
		    
	    printer_putline("%!PS-Adobe-3.0 ExitServer");
	    printer_putline("%%Title: PatchFile");
	    printer_putline("%%EndComments");
	    printer_putc('\n');
	    printer_putline("%%BeginExitServer: 000000");
	    printer_putline("000000");				/* password */
	    printer_puts(excode);				/* insert exitserver code */
	    printer_putline("\n%%EndExitServer");
	    printer_puts(code);
	    printer_putline("\n%%EOF");

	    #ifdef DEBUG_QUERY
	    debug("done");
	    #endif
	    }
    	} /* end of if patch exists */
    
    } /* end of patchfile() */
    
/*
** Download all the *JobPatchFile sections.
*/
void jobpatchfile(void)
    {
    int x;
    char *code;
    char numstr[3];
    
    /* Download *JobPatchFile instances until one is missing. */    
    for(x=1; x < 10; x++)
    	{
	sprintf(numstr, "%d", x);
	if( (code=find_feature("*JobPatchFile", numstr)) == (char*)NULL )
	    break;
	    
	printer_printf("%% start of *JobPatchFile %d\n", x);
	printer_puts(code);
	printer_printf("\n%% end of *JobPatchFile %d\n", x);	    
    	}

    } /* end of jobpatchfile() */
    
/* end of file */
