/*
** ~ppr/src/pprd/pprd_nag.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 25 November 1996.
*/

#include "global_defines.h"
#include <stdio.h>
#include <signal.h>		/* for pprd.auto_h */
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>		/* for abs() */
#include "pprd.h"
#include "pprd.auto_h"

void nag(void)
    {
    int _stdin[2];		/* pipe to sendmail */
    int fd;			/* used to open /dev/null in child */
    FILE *sendmail;
    int x;
    int status, next_error_retry, next_engaged_retry, interval;

    /* See if there is anything we should nag about. */
    x=0;
    while(1)
    	{
	status = printers[x].status;
	next_error_retry = printers[x].next_error_retry;
	next_engaged_retry = printers[x].next_engaged_retry;
	interval = abs(printers[x].alert_interval);

	if( (status==PRNSTATUS_FAULT && (next_engaged_retry > interval || next_error_retry == 0))
		|| (status==PRNSTATUS_ENGAGED && (next_engaged_retry * ENGAGED_RETRY / 60) > 20) )
	    break;    	

	if(++x == printer_count)	/* If we hit end of list, */
	     return;			/* there is nothing to do. */
    	}
	
    if(pipe(_stdin))			/* open a pipe to sendmail */
        {
        error("pipe() failed in nag(), errno=%d",errno);
        return;
        }

    switch(fork())			/* duplicate this process */
        {            
        case -1:                        /* case: fork failed */
	    error("nag(): fork() failed");
	    break;
	    
        case 0:                         /* case: we are child */
            setsid();                   /* make sendmail proc group leader */
            close(_stdin[1]);
            if(_stdin[1] != 0)
            	{
            	dup2(_stdin[0],0);
            	close(_stdin[0]);
            	}
           
            fd=open("/dev/null", O_WRONLY);	/* open /dev/null */
            if(fd!=1) dup2(fd, 1);		/* as stdout */
            if(fd!=2) dup2(fd, 2);		/* and stderr */
            if(fd>2) close(fd);
            execl(MAILPATH, "SendMail", USER_PPR, (char*)NULL);
            _exit(242);

        default:                        /* case: we are parent */
            close(_stdin[0]);           /* close our copy of read end */   
            if( (sendmail=fdopen(_stdin[1], "w")) == (FILE*)NULL )
            	{
            	error("nag(): fdopen() failed");
		return;
            	}
            
	    fprintf(sendmail, "To: "USER_PPR"\n");
	    fprintf(sendmail, "Subject: Remaining printer problems\n");
	    fprintf(sendmail, "\n");

	    for(x=0; x<printer_count; x++)
		{
		status = printers[x].status;
		next_error_retry = printers[x].next_error_retry;
		next_engaged_retry = printers[x].next_engaged_retry;
		interval = abs(printers[x].alert_interval);

		/*
		** If it is a fault which has persisted long enough to have
		** merited a notice to an operator,
		*/
		if(status==PRNSTATUS_FAULT 
			&& (next_error_retry==0 || next_error_retry > interval) )
		    {
		    if(next_error_retry > 0)
			{
			fprintf(sendmail, "The printer \"%s\" has suffered %d faults.\n\n",
				printers[x].name, next_error_retry);
			}
		    else
			{
			fprintf(sendmail, "The printer \"%s\" has suffered a fault from\n"
				 "which it can not recover on its own.\n\n", printers[x].name);
			}
		    }
		/*
		** If it has been otherwise engaged or off line for at least 
		** ENGAGED_NAG_TIME minutes,
		*/
		else if( (status==PRNSTATUS_ENGAGED)
			&& ((next_engaged_retry*ENGAGED_RETRY/60) > ENGAGED_NAG_TIME) )
		    {
		    fprintf(sendmail,"The printer \"%s\" has been otherwise engaged or off line for %d minutes.\n\n",
			printers[x].name,
		    	next_engaged_retry*ENGAGED_RETRY/60);		    
		    }
		
		} /* end of second loop thru printer list */

	    fclose(sendmail);
	    break;
        } /* end of switch */
    } /* end of nag() */
    
/* end of file */
