/*
** ~ppr/src/ppr/ppr_req.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 20 January 1997.
*/

/*
** Requirement comment routines.
*/

#include "global_defines.h"
#include "global_structs.h"
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "ppr.h"

/*
** This is called for each "%%Requirements:"
** or "%%PageRequirements:" comment. 
**
** The parameter "reftype" is either REQ_DOC or REQ_PAGE.
*/
void requirement(int reftype, char *req_name)
    {
    int x;
    char *sptr;

    #ifdef DEBUG_REQUIREMENTS
    printf("Requirement: %s, reftype=%d\n",req_name,reftype);
    #endif

    if(strcmp(req_name,"collate")==0)   /* If it is collated copies */
        {                               /* and we should pay attention */
        if(read_copies)                 /* to copies data, */
            qentry.opts.collate=TRUE;   /* Then, set collate to true */
        return;
        }

    if(strncmp(req_name,"numcopies(",10)==0)
        {
        if(read_copies)
            if((qentry.opts.copies=atoi(&req_name[10]))<1)
                warning(WARNING_SEVERE,"unreasonable numcopies() requirement");
        return;
        }

    for(x=0;x<thing_count;x++)      /* look for this one */
        {
        if( things[x].th_type != TH_REQUIREMENT )
            continue;

        sptr=(char*)things[x].th_ptr;
        if( strcmp(sptr,req_name) == 0 )
            break;
        }

    if(x == thing_count)		/* if not found */
        {                                                
	things_space_check();		/* make room in the array */

	things[x].th_type = TH_REQUIREMENT;
        things[x].R_Flags = reftype;
        things[x].th_ptr = (void*)mystrdup(req_name);

	thing_count++;
        }

    else                            /* if already present, */
        {                           /* add this reference to ref flags */
        things[x].R_Flags |= reftype;
        }

    if(reftype == REQ_PAGE)	    /* If it was in a %%PageRequirement: comment, */
	set_thing_bit(x);	    /* set the bit for this page. */

    } /* end of requirement() */

/*
** Delete a requirement we don't need after all.
** This deletes all requirements of the specified type.
*/
void delete_requirement(char *req_name)
    {
    int x;
    char *sptr;                     
    char *nptr;

    for(x=0;x<thing_count;x++)      /* look for this one */
        {
        if( things[x].th_type != TH_REQUIREMENT )
            continue;

        sptr=(char*)things[x].th_ptr;   /* pointer to requirement */
        nptr=req_name;                  /* name of what deleteing */

        while(*sptr)                    /* compare */
            {
            if(*(sptr++) != *(nptr++))  /* is mis-match, stop here */
                break;
            }

        if(*sptr == (char)NULL && (*nptr=='(' || *nptr==(char)NULL) )
            things[x].R_Flags|=REQ_DELETED; /* if all matched, delete */

        }

    } /* end of delete_requirement() */

/*
** Dump PostScript requirements for the current page.
*/
void dump_page_requirements(void)
    {
    int x;
    int started=FALSE;

    for(x=0;x<thing_count;x++)                      /* try each thing */
        {
        if(things[x].th_type != TH_REQUIREMENT)     /* only interested in */
            continue;                               /* requirements */

        if( things[x].R_Flags & REQ_DELETED )       /* ignore those reqs */
            continue;                               /* we have deleted */

        if( ! (things[x].R_Flags & REQ_PAGE) )      /* only if in this page */
            continue;

        if(started)                                 /* if 2nd or subsequent */
            {                                       /* then use cont line */
            fprintf(page_comments,"%%%%+ %s\n",(char*)things[x].th_ptr);
            }
        else                                        /* otherwise, use 1st */
            {                                       /* line format */
            fprintf(page_comments,"%%%%PageRequirements: %s\n",
                (char*)things[x].th_ptr);
            started=TRUE;
            }

        things[x].R_Flags &= ~ REQ_PAGE;            /* clear for next page */
        }
    } /* end of dump_page_requirements() */

/*
** Write one "Req:" lines for each requirement.
*/
void write_requirement_lines(FILE *out, int fragment)
    {
    int x;

    for(x=0;x<thing_count;x++)
        {
        if( things[x].th_type != TH_REQUIREMENT )
            continue;

	if( ! is_thing_in_current_fragment(x, fragment) )
	    continue;

        fprintf(out,"Req: %s\n",(char*)things[x].th_ptr);
        }

    } /* end of write_requirement_lines() */

/* end of file */

