/*
** ~ppr/src/ppr/ppr_outfile.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Output file routines.
**
** This file last modified 7 February 1996.
*/

#include "global_defines.h"
#include "global_structs.h"
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "ppr.h"
#include "ppr_exits.h"

/*
** Return the next id number.  The string "file" is the full path and
** name of the file to use.  The file is locked, the last id is read,
** and incremented making the new id, and the new id is written back 
** to the file, the file is closed, and the new id is returned.  
*/
int get_next_id(char *file)
    {
    int idfilefd;                   /* file descriptor of id file */
    FILE *idfile;
    int tid;                        /* for holding id */

    idfilefd=open(file, O_RDWR, S_IRUSR | S_IWUSR); /* Open the id file */
					/* for read and write. */
    if(idfilefd != -1)		    	/* If open worked, */
        {          			/* lock the file. */
	if(lock_exclusive(idfilefd,TRUE))
	    fatal(PPREXIT_OTHERERR,"can't lock \"%s\"",file);
	    
        idfile=fdopen(idfilefd,"r+");	/* read and update */

        fscanf(idfile,"%d",&tid);	/* get last value used */
        tid++;				/* add one to it */
        if( (tid<1) || (tid>9999) )	/* if resulting id unreasonable or too large */
            tid=1;                  	/* force it to one */
        rewind(idfile);             	/* move to start of file for write */
        }
    else                            	/* Open failed, assume file does not exist */
        {
        tid=1;                      	/* start id's at 1 */
        idfile=fopen(file,"w");     	/* create a new file */
        if(idfile==(FILE*)NULL)
            fatal(PPREXIT_OTHERERR,"can't create new id file \"%s\"",file);
        }

    fprintf(idfile,"%d\n",tid);     	/* Write the new id */
    fclose(idfile);                 	/* and close the id file. */
    return tid;
    } /* end of get_next_id() */

/*
** Open the output files.
** These are three in number:  one for the text, one for the header
** and trailer comments, and one for the page level comments. 
*/
void open_output(void)
    {
    char temp[MAX_PATH];

    /* file for header and trailer comments */
    sprintf(temp,"%s/%s:%s-%d.0(%s)-comments",
    		DATADIR,
    		qentry.destnode,qentry.destname,qentry.id,qentry.homenode);
    if( (comments=fopen(temp,"w")) == (FILE*)NULL )
        fatal(PPREXIT_OTHERERR,"can't open \"-comments\" file, errno=%d",errno);

    /* file for page comments */
    sprintf(temp,"%s/%s:%s-%d.0(%s)-pages",
		DATADIR,
		qentry.destnode,qentry.destname,qentry.id,qentry.homenode);
    if( (page_comments=fopen(temp,"w")) == (FILE*)NULL )
        fatal(PPREXIT_OTHERERR,"can't open \"-pages\" file, errno=%d",errno);

    /* file for the PostScript text */
    sprintf(temp,"%s/%s:%s-%d.0(%s)-text",
    		DATADIR,
    		qentry.destnode,qentry.destname,qentry.id,qentry.homenode);
    if( (text=fopen(temp,"w")) == (FILE*)NULL )
        fatal(PPREXIT_OTHERERR,"can't open \"-text\" file, errno=%d",errno);
    } /* end of open_output() */

/* end of file */

