/*
** ~ppr/src/ppr/ppr_old2new.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 7 March 1997.
*/

/*
** Routines to convert old format DSC comments (pre-3.0) to new format 
** comments.  These routines include a higher level getline() routine 
** called clean_getline(). 
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <ctype.h>
#include "global_defines.h"
#include "global_structs.h"
#include "ppr.h"

int logical_eof = FALSE;		/* non-zero for end of input file */
int cont;				/* TRUE if this comment is continuation */

static char lastDSC[MAX_CONT+1] = {0};	/* for %%+ */

/*
** A subroutine which is used when replacing earlier version comments
** with DSC 3.0 comments.  Sets line[] to "%%comment tail".
*/
void fixcomment(char *comment, char *tail)
     {
     char tempstr[256];
     int x;

     x=0;
     while( tail[x]==' ' && tail[x]!=(char)NULL ) 
        x++;                    /* eat whitespace leading to tail */

     strcpy(tempstr,&tail[x]);
     line_len = sprintf(line, "%%%%%s %s", comment, tempstr);

     tokenize();                /* re-tokenize */
     } /* end of fixcomment() */

/* 
** Translate pre-DSC 3.0 comments to the equivelent DSC 3.0
** comments.  This routine is for comments which may occur 
** anywhere in the file.  There are seperate routines for 
** comments which occur only in the header and trailer or 
** only in pages.
**
** This is called from clean_getline().  It is necessary tokenize() 
** be called before calling this function.  If this function alters
** the line it will call tokenize() again to update the tokens list.
*/
void old_to_new(void)
    {
    switch(line[2])
        {
        case 'B':
            if(strncmp(line, "%%BeginBinary:", 14) == 0)
                {
		if(tokens[1] == (char*)NULL)
		    {
		    warning(WARNING_SEVERE, "\"%%%%BeginBinary:\" line has not argument");
		    }
		else
		    {
                    line_len=sprintf(line,"%%%%BeginData: %s Binary Bytes",tokens[1]);
                    tokenize();         /* re-tokenize */
                    return;
                    }
                }
            if(strncmp(line,"%%BeginFile:",12)==0)
                {
                if(tokens[1]==(char*)NULL)
                    {
                    warning(WARNING_SEVERE,"\"%%%%BeginFile:\" line has not argument");
                    }
                else
                    {
                    line_len=sprintf(line,"%%%%BeginResource: file %s",tokens[1]);
                    tokenize();         /* re-tokenize */
                    return;
                    }
                }
            if(strncmp(line,"%%BeginFont:",12)==0)
                {
		if(tokens[1]==(char*)NULL)
		    {
		    warning(WARNING_SEVERE,"\"%%%%BeginFont:\" line has not argument");
		    }
		else
		    {
                    line_len=sprintf(line,"%%%%BeginResource: font %s",tokens[1]);
                    tokenize();		/* re-tokenize */
                    return;
                    }
                }
            if(strncmp(line, "%%BeginProcSet:", 15) == 0)
                {
                fixcomment("BeginResource: procset", line+15);
                return;
                }
            if(strcmp(line,"%%BeginDocumentSetup")==0)
                {
                warning(WARNING_PEEVE, "%%%%BeginDocumentSetup should be %%%%BeginSetup");
                strcpy(line,"%%BeginSetup");
                line_len = 12;
                tokenize();         /* re-tokenize */
                return;
                }
            return;

        case 'E':
            if( strcmp(line,"%%EndBinary")==0 )
                {		/* convert to new style */
                strcpy(line,"%%EndData");
                line_len = 9;
                tokenize();	/* re-tokenize */
                return;
                }
            if(strcmp(line, "%%EndFile") == 0
                || strcmp(line, "%%EndFont") == 0
                || strncmp(line, "%%EndProcSet", 12) == 0	/* rather lax!  (Due to "%%EndProcSet: name") */
		|| strcmp(line, "%%EndProcset") == 0		/* For buggy QuickDraw GX */
                )
                {
                strcpy(line,"%%EndResource");
                line_len = 13;
                tokenize();         /* re-tokenize */
                return;
                }
            if(strcmp(line, "%%EndDocumentSetup") == 0)
                {
                warning(WARNING_PEEVE, "%%%%EndDocumentSetup should be %%%%EndSetup");
                strcpy(line, "%%EndSetup");
                line_len = 10;
                tokenize();         /* re-tokenize */
                return;
                }
	    if(strncmp(line, "%%ExecuteFile:", 14) == 0)
	    	{
	    	fixcomment("IncludeDocument:", line+14);
		return;
	    	}
            return;

	case 'F':
	    if(strncmp(line, "%%Feature:", 10) == 0)
		{
		fixcomment("IncludeFeature:", line+10);
		return;
		}
	    return;

        case 'I':
            if(strncmp(line, "%%IncludeFont:", 14) == 0)
                {
		if(tokens[1]==(char*)NULL)
		    {
		    warning(WARNING_SEVERE,"\"%%%%IncludeFont:\" line has not argument");
		    }
		else
		    {
                    line_len=sprintf(line,"%%%%IncludeResource: font %s",tokens[1]);
                    tokenize();         /* re-tokenize */
                    return;
                    }
                }
            if(strncmp(line, "%%IncludeFile:", 14) == 0)
                {
		if(tokens[1]==(char*)NULL)
		    {
		    warning(WARNING_SEVERE,"\"%%%%IncludeFile:\" line has no argument");
		    }
		else
		    {
                    line_len=sprintf(line,"%%%%IncludeResource: file %s",tokens[1]);
                    tokenize();         /* re-tokenize */
                    return;
                    }
                }
            if(strncmp(line, "%%IncludeProcSet:", 17) == 0)
                {
                fixcomment("IncludeResource: procset",line+17);
                return;         /* must allow version and revision */
                }
            return;
        default:
            return;
        }       
    } /* end of old_to_new() */

/*
** Get a line, handling included documents and data such 
** as binary.  Also, do resource extraction here.  This 
** is implemented in two functions.
*/
static void _clean_getline(void)
    {
    getline();

    again:
    
    /*
    ** Is this a comment line?
    ** (This once tested for only one % "because of %TCHCT comments.")
    */
    if( line[0]=='%' && (line[1]=='%' || line[1]=='!') && (line_len <= MAX_TOKENIZED) )  
        {                               /* If DSC comment line, */
        int len;                        /* eat up trailing space. */
        len=strlen(line);		/* (strlen(line) may differ from line_len due to %%+) */
        while(len--)
            {
            if( ! isspace( line[len] ) )
                break;
	    line[len] = (char)NULL;
            }

	/*
	** Handle comment continuation.  (Lines begining with "%%+".)
	*/
        if( line[2] == '+' && lastDSC[0] != (char)NULL )
            {						/* if comment continuation */
            char tempstr[MAX_TOKENIZED+MAX_CONT+1];	/* and previous comment present, */
            int x=3;
            while(line[x]==' ' || line[x]=='\t')	/* eat up space after %%+ */
                x++;
            line_len=sprintf(tempstr,"%%%%%s %s", lastDSC, &line[x]);
            strcpy(line,tempstr);       /* then expand to full comment */
            cont = TRUE;
            }
        else                            /* else, is not a continuation */
            {
            cont = FALSE;
            }

	/*
	** Now, stash this one away
	** in case _it_ is continued.
	*/
        len = strcspn(&line[2], " \t");
        if(len < MAX_CONT)
            {
            strncpy(lastDSC, &line[2], len);
            lastDSC[len] = (char)NULL;
            }
        else
            {
            lastDSC[0] = (char)NULL;
            }

        tokenize();			/* break line into ``words'' */

        old_to_new();                   /* upgrade to DSC 3.0 */

	/*
	This switch statment will act on certain comments which
	have global significance.

	If a document is marked by comments, simple increment the
	nesting level at the start and decrement it at the end.

	In the case of resources, we must operate the cache
	machinery and we must make notes of those resources
	which appear in the document.
        */
	switch(line[2])
	    {
	    case 'B':
	    	if( strncmp(line, "%%BeginDocument:", 16) == 0 )
            	    {					/* begin document */
            	    nest_push(NEST_DOC, tokens[1]);	/* raises our parsing level */
            	    break;
            	    }
        	if( strncmp(line,"%%BeginData:",12) == 0 )
            	    {				/* Just copy enclosed */
            	    copy_data(text);		/* data and get */
		    getline();			/* something else for our caller. */
		    if( line[0] == '%' )
		    	{
		    	tokenize();
		    	old_to_new();
			if( strncmp(line, "%%EndData", 9) == 0 )
		    	    return;
		    	}
		    warning(WARNING_SEVERE, "Incorrect size in \"%%%%BeginData:\"");
            	    goto again;					/* something */ 
            	    }						/* else for our caller. */
	        if( strncmp(line,"%%BeginResource:", 16) == 0 )
        	    {						/* Note the resource in the table */
	            resource(REREF_REALLY_SUPPLIED,tokens[1],2);
								/* (resource() must be ready for NULL resources) */
	            nest_push(NEST_RES, tokens[2]);		/* this is a new level */
	            if( nest_level() == 1 )			/* if 1st level resource, */
	                start_resource();			/* tell the cache machinery */
		    break;
	            }
		break;
		
	    case 'I':
	        if( strncmp(line, "%%IncludeResource:", 18) == 0 )
	            {
	            resource(REREF_INCLUDE, tokens[1], 2); 
	            break;
	            }
	        break;

	    case 'P':
	    	if( strncmp(line, "%!PS-Adobe-", 11) == 0
			&& tokens[1] != (char*)NULL
	    		&& strncmp(tokens[1], "EPSF-", 5) == 0 
	    		&& nest_level() == 0
	    		&& outermost_current() != OUTERMOST_HEADER_COMMENTS )
		    {
		    if( qentry.opts.hacks & HACK_BADEPS )
	    	    	{
		    	char temp[80];

			warning(WARNING_PEEVE, "Unenclosed EPS file, applying badeps hack");
			line[79] = (char)NULL;
		    	strcpy(temp, line);
		    	strcpy(line, "%%BeginDocument:\n");
		    	strcat(line, temp);
		    	nest_push(NEST_BADEPS, tokens[1]);
			}
		    else
		    	{
		    	warning(WARNING_SEVERE, "Unenclosed EPS file, try -H badeps");
		    	}
	    	    }
		break;

	    case 'E':
        	if( strcmp(line, "%%EndDocument") == 0 )
	            {                           /* end document lowers it */
	            if( nest_level() == 0 )
	                warning(WARNING_SEVERE, "\"%%%%EndDocument\" without \"%%%%BeginDocument:\"");
	            else
	                nest_pop(NEST_DOC);	/* assuming it was raised by */
	            break;			/* BeginDocument */
	            }
        	if( strcmp(line, "%%EndResource") == 0 )
	            {				/* If end of resource, */
	            if( nest_level() == 0 )	/* If no level to end, */
	                {			/* get very angry. */
	                warning(WARNING_SEVERE, "\"%%%%EndResource\" without \"%%%%BeginResource\"");
	                }
	            else
	                {
	                if( nest_level() == 1 )	/* If first level resource, */
	                    end_resource();	/* tell cache machinery. */
			nest_pop(NEST_RES);	/* Drop down a level. */
	                }
	            break;
	            }
		if( strcmp(line, "%%EOF") == 0 )
		    {
		    if( nest_level() == 0 )		/* If it is the one which */
		    	{				/* ends the document, */
			eof_comment_present = TRUE;	/* set flag for -Z switch. */
			break;
			}
		    if( (qentry.opts.hacks & HACK_BADEPS) && nest_inermost_type() == NEST_BADEPS )
		    	{
			nest_pop(NEST_BADEPS);
			strcat(line, "\n%%EndDocument");
			break;
		    	}
		    break;
		    }
		break;

	    } /* end of switch */
	
        } /* end of if line begins with "%%" or "%!" */

    } /* end of clean_getline() */

void clean_getline(void)
    {
    _clean_getline();		/* Call lower level part. */

    if(rgrab)			/* If stashing in resource cache, */
        {
        if(rgrab==2)	/* If 2nd or subsequent line, */
            {		/* (1st line is "%%BeginResource:".) */
			/* then write it to the cache file. */  
            fwrite(line, sizeof(unsigned char), line_len, cache_file);

	    if(!line_overflow)		/* If that was a whole line, */
	    	fputc('\n',cache_file);	/* then terminate it. */
            }
        else				/* first line, */
            {
            rgrab = 2;			/* just note that we saw the 1st line */
            }
        }

    } /* end of clean_getline() */

/*
** Convert old style header and trailer comments to DSC 3.0.
** In other words, if we recognize the line in the global
** variable "line", we will replace it with a modern equivelent.
*/
void old_to_new_headertrailer(void)
    {
    if(strncmp(line,"%%Document",10)==0)
        {
        switch(line[10])
            {
            case 'N':
                if( strncmp(line,"%%DocumentNeededFiles:",22) == 0 )
                    {
                    fixcomment("DocumentNeededResources: file",line+22);
                    return;
                    }
                if( strncmp(line,"%%DocumentNeededFonts:",22) == 0 )
                    {
                    fixcomment("DocumentNeededResources: font",line+22);
                    return;  
                    }
                if( strncmp(line,"%%DocumentNeededProcSets:",25) == 0 )
                    {
                    fixcomment("DocumentNeededResources: procset",line+25);
                    return;
                    }
                return;
            case 'S':
                if( strncmp(line,"%%DocumentSuppliedFiles:",24) == 0 )
                    {
                    fixcomment("DocumentSuppliedResources: file",line+24);
                    return;
                    }
                if( strncmp(line,"%%DocumentSuppliedFonts:",24) == 0 )
                    {
                    fixcomment("DocumentSuppliedResources: font",line+24);
                    return;
                    }
                if( strncmp(line,"%%DocumentSuppliedProcSets:",27) == 0 )
                    {
                    fixcomment("DocumentSuppliedResources: procset",line+27);
                    return;
                    }
                return;
            default:
                return;
            }
        }
    } /* end of old_to_new_headertrailer() */

/*
** Convert old style page comments to DSC 3.0.
** In other words, if we recognize the line in the global
** variable "line", we will replace it with a modern equivelent.
*/
void old_to_new_page(void)
    {
    if(strncmp(line,"%%Page",6)==0)
        {
        switch(line[6])
            {
            case 'F':
                if(strncmp(line,"%%PageFonts:",12)==0)
                    {
                    fixcomment("PageResources: font",&line[12]);       
                    return;
                    } 
                if(strncmp(line,"%%PageFiles:",12)==0)
                    {
                    fixcomment("PageResources: file",&line[12]);
                    return;
                    } 
            default:
                return;
            }
        }
    } /* end of old_to_new_page() */
    
/* end of file */
