/*
** ~ppr/src/ppr/ppr_conffile.c
** Copyright 1995, Trinity College Computing Center.
** Written by David Chappell
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Find and parse the group or printer configuration file.  The first
** time this is called we will cache the information so that we 
** do not have to perform expensive disk accesses to get other
** lines from the file.
**
** This file was last modified 19 June 1995.
*/

#include "global_defines.h"
#include "global_structs.h"
#include <stdio.h>
#include <string.h>
#include "ppr.h"

int information_cached=FALSE;
char *switchset=(char*)NULL;
char *deffiltopts=(char*)NULL;

/*
** First, we have a routine which finds the file and extracts
** the information.
*/
void cache_info(void)
    {
    char fname[MAX_PATH];
    FILE *conffile;
    
    /* Try a group first. */
    sprintf(fname,"%s/%s", GRCONF, qentry.destname);
    if( (conffile=fopen(fname, "r")) == (FILE*)NULL )
    	{			/* if not, then try a printer */
        sprintf(fname,"%s/%s", PRCONF, qentry.destname);
	conffile=fopen(fname, "r");
	}    	

    /* If a file was found, use it.  Here is not the place */
    /* to worry about groups and printers which do not exist. */
    if( conffile!=(FILE*)NULL )
	{
	char temp[MAX_CONFLINE+2];

	while( (switchset==(char*)NULL || deffiltopts==(char*)NULL)
		&& fgets(temp,sizeof(temp),conffile) != (char*)NULL )
	    {
	    if( ppr_sscanf(temp,"Switchset: %Z",&switchset) == 1 )
	    	continue;
	    if( ppr_sscanf(temp,"DefFiltOpts: %Z",&deffiltopts) == 1 )
	    	continue;
	    }

	fclose(conffile);
	}    	
        
    information_cached=TRUE;
    } /* end of cache_info() */

/*
** Extract the "Switchset:" line.
*/
char *extract_switchset(void)
    {
    if( ! information_cached )
    	cache_info();
    	
    return switchset;
    } /* end of extract_switchset() */

/*
** Extract the "DefFileOpts:" line.
** If we find none, we will return a zero length string
** rather than the NULL character pointer which extract_switchset()
** returns.
*/
char *extract_deffiltopts(void)
    {
    if( ! information_cached )
	cache_info();
	
    if( deffiltopts != (char*)NULL )
	return deffiltopts;
    else
        return "";
    } /* end of extract_deffiltopts() */

/* end of file */
