#!/bin/sh
#
# ~ppr/src/ppd/makepatches
# Copyright 1995, Trinity College Computing Center.
# Written by David Chappell.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# The purpose of this script is to compare the origional versions of the 
# PPD files to the versions which were patched for PPR and produce a
# differences file.
#
# A patching mechanism is used since some vendors do not allow their 
# PPD files to be destributed after having been modified.
#
# This file was last modified 14 March 1995.
#

# Do this for each of the patched files
if [ `ls patched | wc -l` -ne 0 ]
    then
    for new in patched/*
	do
	echo -n "Making patch file to produce \"$new\" from "
	
	name=`echo "$new" | cut -d'/' -f2`

	old=""
	for dir in adobe apple hp
		do
		if [ -z "$old" -a -r "$dir/$name" ]
			then
			old="$dir/$name"
			fi
		done

	if [ -z "$old" ]
		then
		echo
		echo "Error: can't find old \"$name\"."
		exit 1
		fi

	echo "\"$old\"."
	
	diff -c "$old" "$new" >"patches/$name"

	done
    fi

exit 0
