#!/bin/sh
#
# ~ppr/src/ppd/dopatches
# Copyright 1995, 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# This file was last modified 4 October 1996.
#

#
# The purpose of this script is to apply patches to vendor provided PPD
# files to produce versions with changes which correct errors, provide
# work-arounds for printer bugs, or support additional features.
#
# A patching mechanism is used since some vendors do not allow their 
# PPD files to be destributed after having been modified.
#

# Do this for each of the patches.
for patchfile in patches/*
	do
	
	# Get the basename of the patchfile.
	name=`echo "$patchfile" | cut -d'/' -f2`

	echo -n "Making \"patched/$name\" from "
	
	# Find the original file by looking in subdirectories
	# until we find it.
	old=""
	for dir in adobe apple hp
		do
		if [ -z "$old" -a -r "$dir/$name" ]
			then
			old="$dir/$name"
			fi
		done

	# If we can't find it, that is bad.
	if [ -z "$old" ]
		then
		echo
		echo "Error: can't find old \"$name\"."
		exit 1
		fi

	# Complete the statement we started to make above.
	echo "\"$old\"."
	
	# Patch the file, putting the finished product in 
	# the "patched" directory.
	rm -f "patched/$name"
	patch "$old" -o "patched/$name" <"patches/$name"
	exval=$?

	# If the patch program failed, pass the exit 
	# code on to our parent.
	if [ $exval -ne 0 ]
		then
		exit $exval
		fi

	done

# Normal termination.
exit 0
