#!/bin/sh
#
# ~ppr/src/misc/media.sh
# Copyright 1995, Trinity College Computing Center.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# This script initializes the PPR media database.
# Last modified 3 August 1995.
#

# white paper in various sizes and weights
ppad media put "letter" "612.0 pt" "792.0 pt" 75.0 "white" "" 7
ppad media put "master" "612.0 pt" "792.0 pt" 300.0 "white" "" 2
ppad media put "legal" "612.0 pt" "1008.0 pt" 75.0 "white" "" 5

# Junk for banner pages
# Stupid colour field value may be important.  We don't want
# it every selected as a match for some real media requirement.
ppad media put "banner" "612.0 pt" "792.0 pt" 0 "VARIES" "" 10

# other stuff
ppad media put "3hole" "612.0 pt" "792.0 pt" 0.0 "white" "3Hole" 6
ppad media put "labels" "612.0 pt" "792.0 pt" 0.0 "white" "Labels" 1

# envelopes
ppad media put "comm10" "297.0 pt" "684.0 pt" 0.0 "white" "Envelope" 1
ppad media put "monarch" "540.0 pt" "279.0 pt" 0.0 "white" "Envelope" 1

# normal paper of different colours
ppad media put "yellow" "612.0 pt" "792.0 pt" 75.0 "yellow" "" 5
ppad media put "red" "612.0 pt" "792.0 pt" 75.0 "yellow" "" 5
ppad media put "blue" "612.0 pt" "792.0 pt" 75.0 "yellow" "" 5
ppad media put "green" "612.0 pt" "792.0 pt" 75.0 "yellow" "" 5
ppad media put "pink" "612.0 pt" "792.0 pt" 75.0 "yellow" "" 5

# various kinds of letterhead
ppad media put "letterhead" "612.0 pt" "792.0 pt" 0.0 "white" "DeptLetterHead" 3
ppad media put "custletterhead" "612.0 pt" "792.0 pt" 0.0 "white" "CustLetterHead" 3
ppad media put "userletterhead" "612.0 pt" "792.0 pt" 0.0 "white" "UserLetterHead" 3
ppad media put "halfletterhead" "396.0 pt" "612.0 pt" 0.0 "white" "CustLetterHead" 3
ppad media put "executivelethead" "522.0 pt" "756.0 pt" 0.0 "white" "DeptLetterHead" 3

# end of file
