%{
/*
** ~ppr/src/papsrv/papsrv_ppd_parse.l
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This code last modified 10 December 1996.
*/

/*
** This code is the lexer which the AppleTalk PAP server uses
** to parse an Adobe PPD file.
*/

#include "global_defines.h"
#include <stdlib.h>		/* for exit() and atoi() */
#ifdef FLEX_SCANNER
#include <unistd.h>		/* for read() (flex uses it) */
#include <sys/uio.h>		/* for read() (flex uses it) */
#endif
#include <string.h>
#include <errno.h>
#include "papsrv.h"		/* for printer structure */

extern struct ADV *printer;
void add_font(char *fontname);

/* This is where we save the original input file while we
   are reading from an include file. */
extern char *ppd_fname[MAX_PPD_NEST];
extern FILE *ppd_f[MAX_PPD_NEST];
extern int ppd_nest_level;

/* Some Lex implementations define yywrap as a macro,
   if that has been done, get rid of it. */
#undef yywrap

/* Here is a yywrap() which switches back to the original file
   when the include file ends. */
int yywrap(void)
    {
    if(ppd_nest_level > 0)
	{
	DODEBUG_PPD(("end of include file"));
	fclose(yyin);				/* close include file */
	myfree(ppd_fname[ppd_nest_level]);	/* don't need file name anymove */
	ppd_nest_level--;
	yyin = ppd_f[ppd_nest_level];		/* restore current input file */
	return 0;			/* Tell parser that we have opened another file. */
	}				/* (Which is sort of what we have done.) */

    return 1;
    }

%}

%s FAX
%s LANGLEV
%s PSVER
%s PRODUCT
%s FREEVM
%s VMOPT
%s VMOPT2
%s VMOPT3
%s RES
%s FONT
%s FONTJUNK
%s TTRAS
%s INCLUDE

%%

<INITIAL>^\*FaxSupport:[ \t]* { BEGIN FAX; }
<FAX>.+                 { if(printer->FaxSupport == (char*)NULL) /* 1st one only */
				printer->FaxSupport = mystrdup(yytext); }
<FAX>\n                 { BEGIN INITIAL; }

<INITIAL>^\*LanguageLevel:[ \t*]["] { BEGIN LANGLEV; }
<LANGLEV>[0-9]+         { if(printer->LanguageLevel == 0)	/* 1st one only */
				printer->LanguageLevel = atoi(yytext); }
<LANGLEV>["]            { BEGIN INITIAL; }

<INITIAL>^\*Product:[ \t]*["] { BEGIN PRODUCT; }
<PRODUCT>[^"]+          { if(printer->Product == (char*)NULL) /* 1st one */ 
                            printer->Product = mystrdup(yytext); }
<PRODUCT>["]            { BEGIN INITIAL; }

<INITIAL>^\*PSVersion:[ \t]*["] { BEGIN PSVER; }
<PSVER>[^"]+            { if(printer->PSVersion == (char*)NULL) /* 1st one */ 
                            printer->PSVersion = mystrdup(yytext); }
<PSVER>["]              { BEGIN INITIAL; }

<INITIAL>^\*FreeVM:[ \t]*["] { BEGIN FREEVM; }
<FREEVM>[0-9]+          { if(printer->FreeVM == 0)		/* 1st one only */
			    printer->FreeVM = atoi(yytext); }
<FREEVM>["]             { BEGIN INITIAL; }

<INITIAL>^\*VMOption[ \t]+ { BEGIN VMOPT; }
<VMOPT>[^ \t/:]+	{
			/* If there was a PPDOpt: line in the printer
			   configuration file for *InstalledMemory and it
			   matches this *VMOption line, */
			if( printer->InstalledMemory != (char*)NULL && strcmp(printer->InstalledMemory, yytext) == 0)
				{ BEGIN VMOPT2; }
			else
				{ BEGIN INITIAL; }
			}
<VMOPT2>[^"]+["]	{ BEGIN VMOPT3; }
<VMOPT3>[0-9]+		{ if( printer->VMOptionFreeVM == 0 )
				printer->VMOptionFreeVM = atoi(yytext); }

<INITIAL>^\*DefaultResolution:[ \t]* { BEGIN RES; }
<RES>.+                 { if(printer->Resolution==(char*)NULL)
			    printer->Resolution=mystrdup(yytext); }

<INITIAL>^\*Font[ \t]+	{ BEGIN FONT; }
<FONT>[^:]+		{ BEGIN FONTJUNK;
			add_font(yytext); }
<FONTJUNK>.*		{ /* discard it */ }

<INITIAL>^\*TTRasterizer:[ \t]* { BEGIN TTRAS; }
<TTRAS>.+		{ if(printer->TTRasterizer==(char*)NULL)
			    printer->TTRasterizer=mystrdup(yytext); }

<INITIAL>^\*Include:[ \t]*["]	{ BEGIN INCLUDE; }
<INCLUDE>[^"\n]*		{ char *ifname;		/* include file name */

				if(++ppd_nest_level == MAX_PPD_NEST)
				    fatal(1, "Too many levels of \"*Include:\" in PPD file");

				if(yytext[0] == '/')
				    {
				    ifname = mystrdup(yytext);
				    }
				else
				    {
				    char *pathend;
				    int len;

				    if( (pathend = strrchr(ppd_fname[ppd_nest_level-1], '/')) == (char*)NULL )
					fatal(1, "papsrv_ppd_parse.l: internal error: no /");

				    len = pathend - ppd_fname[ppd_nest_level-1];

				    ifname = (char*)myalloc(len + 1 + strlen(yytext) + 1, sizeof(char));

				    sprintf(ifname, "%.*s/%s", len, ppd_fname[ppd_nest_level-1], yytext);
				    }

				DODEBUG_PPD(("opening include file \"%s\"", ifname));

				if( (yyin=fopen(ifname,"r")) == (FILE*)NULL ) 
					fatal(1, "PPD include file \"%s\" can't be opened, errno=%d (%s)", ifname, errno, strerror(errno));

				ppd_fname[ppd_nest_level] = ifname;
				ppd_f[ppd_nest_level] = yyin;
				}
<INCLUDE>["]			{ BEGIN INITIAL; }

.|\n         { BEGIN INITIAL; /* discard unmatched stuff */ }

%%
