#!/bin/sh
#
# ~ppr/src/papsrv/papsrv_kill.sh
# Copyright 1995, 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software and documentation are provided "as is" without
# express or implied warranty.
#
# This file was last modified 5 December 1996.
#

HOMEDIR="/usr/ppr"
VAR_SPOOL_PPR="/var/spool/ppr"

if [ ! -f $VAR_SPOOL_PPR/papsrv.pid ]
	then
	echo "papsrv_kill: papsrv is not running"
	exit 1
	fi

echo "Killing papsrv"
kill `cat $VAR_SPOOL_PPR/papsrv.pid` || exit 1

while [ -f $VAR_SPOOL_PPR/papsrv.pid ]
	do
	echo "Waiting while papsrv shuts down..."
	sleep 1
	done

echo "Shutdown complete."

exit 0
