#!/bin/sh
#
# ~ppr/src/misc_filters/xbm.sh
# Copyright 1995, Trinity College Computing Center
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# /usr/ppr/install/setup_filters passes this program thru a sed
# script before installing it.
#
# This file last modified 22 March 1995.
#

# Paths of filters
XBMTOPBM=""
PNMTOPS=""

# Assign names to the parameters
OPTIONS="$1"
PRINTER="$2"
TITLE="$3"

# Set the RESOLUTION option to use the default.
RESOLUTION=""

# Look for parameters we should pay attention to
for pair in $OPTIONS
    do
    case "$pair" in
	resolution=* )
	    RESOLUTION="-dpi `echo $pair | cut -d'=' -f2`"
	    ;;
    esac
    done

$XBMTOPBM | $PNMTOPS $RESOLUTION

# Exit with the errorlevel left by
# the last program.
exit $?

# end of file
