#!/bin/sh
#
# ~ppr/src/misc_filters/pr.sh
# Copyright 1995, Trinity College Computing Center.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# PR filter for the PPR spooling system.
# Run pr and filter_lp to make a PostScript pr.
#
# $1 is the options
# $2 is the name of the printer or group
# $3 is the title
# $4 is the directory ppr was invoked in
#
# This file was last modified 11 September 1995.
#

PATH=/usr/bin:/bin

width="132"
length="66"

tempfile=/tmp/ppr_pspr$$

# Process the options
for option in $1
	do
	case $option in
		width=*)
			width=`echo $option | cut -f2 -d'='`
			;;
		length=*)
			length=`echo $option | cut -f2 -d'='`
			;;
		*)
			;;
	esac
	done

# Now, run pr.
pr -f -h "$3" -w$width -l$length >$tempfile
if [ $? != 0 ]; then rm -f $tempfile; exit 1; fi

# Now, run filter_lp and remove the temporary file
lib/filter_lp "$1" "$2" "$3" "$4" <$tempfile
exval=$?

# We can remove the temporary file now.
rm -f $tempfile

# Make non-zero exit if filter_lp did.
if [ $exval != 0 ]; then exit 2; fi

# We are done, we were sucessfull.
exit 0
