/*
** ~ppr/src/misc_filters/hexdump.c
** Copyright 1995, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software and documentation are provided "as is" without
** express or implied warranty.
** 
** Hex Dump Filter for the PPR spooling system.
**
** Usage: filter_hexdump _options_ _printer_name_ _file_type_description_
**
** This program does not have a running comentary because it is
** so short and simple.
**
** One point should be noted though, this program reads the entire
** input file on stdin even though it only prints the first 60 or
** so hex lines.
**
** This file last modified 20 September 1995.
*/

#include <stdio.h>
#include <ctype.h>

/* The size we will format the page for. */
#ifndef A4			/* US Letter */
#define MAX_LINES 60
#else				/* A4 */
#define MAX_LINES 62
#endif

void emmit_header(void)
	{
	puts("%!PS-Adobe-3.0");
	puts("%%DocumentData: Clean7Bit");
	puts("%%Title: Hex Dump of Bad Job");
	puts("%%Creator: PPR hex dump filter");
	puts("%%Pages: 1");
	puts("%%DocumentNeededResources: font Courier Helvetica");
	puts("%%ProofMode: TrustMe");	
	puts("%%EndComments\n");

	puts("%%BeginProlog");
	puts("/inch{72 mul}def");
	puts("/mm{2.835 mul}def");
	#ifndef A4
	puts("/PH 11.0 inch def");		/* US letter */
	#else
	puts("/PH 297.0 mm def");		/* A4 */
	#endif
	puts("/bp{save 0.5 inch PH 0.5 inch sub moveto}def");
	puts("/nl{currentpoint exch pop 12 sub 0.5 inch exch moveto}def");
	puts("/p{show nl}def");
	puts("/ep{showpage restore}def");
	puts("%%EndProlog\n");
	
	puts("%%BeginSetup");
	puts("%%IncludeResource: font Courier");
	puts("%%IncludeResource: font Helvetica");
	puts("/C /Courier findfont 10 scalefont def");
	puts("/H /Helvetica findfont 10 scalefont def");
	puts("%%EndSetup\n");
	} /* end of emmit_header() */
	
void emmit_trailer(void)
	{
	puts("%%Trailer");
	puts("%%EOF");
	}

void begin_page(void)
	{
	puts("%%Page: 1 1");
	puts("bp");
	}
	
void end_page(void)
	{
	puts("ep\n");
	}

void hexline(unsigned char *segment, int len)
	{
	int x;
	int c;

	/* First, print as characters */		
	fputc('(',stdout);

	for(x=0; x < len; x++)		/* do each character in line */
		{
		c=segment[x];
		
		if(!isprint(c))		/* if unprintable, use dot */
			{
			fputc('.',stdout);	
			}
		else			/* if printable, print */
			{
			switch(c)
				{
				case '(':
				case ')':
				case 0x5C:
					printf("\\%c",c);
					break;
				default:
					fputc(c,stdout);
					break;
				}
			}		
		}

	/* Padd out to 16 characters */
	for( ; x < 16; x++)
		{
		fputc(' ',stdout);
		}

	/* print in hexadecimal */
	for(x=0; x < len; x++)
		{
		printf(" %2.2X",segment[x]);
		}
	
	puts(")p");
	} /* end of hexline() */

int main(int argc, char *argv[])
	{
	unsigned char buffer[16];
	int len;
	int line=0;

	emmit_header();
	begin_page();

	if(argc >= 4)
		{
		puts("H setfont");
		printf("(Can't print %s.  Here is a sample)p\n",argv[3]);
		puts("(of the contents of your job:)p");
		puts("nl");
		}

	puts("C setfont");

	while( (len=fread(buffer,sizeof(unsigned char),16,stdin)) )
		{
		if(line++ < MAX_LINES)
			hexline(buffer,len);
		}
	
	end_page();
	emmit_trailer();
	return 0;
	} /* end of main() */

/* end of file */
