#!/bin/sh
#
# ~ppr/src/misc/xppr.sh
# Copyright 1995, 1996, Trinity College Computing Center.
# Written by David Chappell
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 4 October 1996.
#

#
# This shell script is intended to be invoked from an X-Windows file
# manager.  The first parameter is the name of the printer to print on,
# the second and subsequent parameters are the names of the files to print.
#
# If ppr reports an error, the entire output of ppr is displayed using
# xmessage if it is available and xterm, sh, and echo if it is not.
#

# Save the printer name in a variable sinche we
# will use shift which will destroy the origional $1.
PRINTER="$1"

# If we do not have at least two paramters, 
# pop up an xterm with an error message in it.
if [ -z "$PRINTER" -o -z "$2" ]
    then
    xterm -e /bin/sh -c 'echo "Usage: xppr printer files...";
		echo;
		echo "Please press RETURN to clear this message.";
		read x'
    exit 0
    fi

# In this loop, we process each file.
while [ -n "$2" ]
    do
    # Run ppr on this file, capturing the output.
    OUTPUT=`ppr -d $PRINTER -C $2 -m xwin -r "$DISPLAY" -w log -I $2 2>&1`;

    # If there was an error, print it using xmessage if we have it,
    # if not, pass a shell script to xterm.
    if [ $? -ne 0 ]
	then
	if [ -x /usr/bin/X11/xmessage ]
	    then
	    echo "$OUTPUT" \
		| xmessage -geometry +100+100 \
			-title "Printing Errors For \"$2\""\
			-default okay -file -
	    else
	    xterm \
		-geometry 80x10+100+100 -sb \
		-title "Printing Errors for \"$2\"" \
		-e /bin/sh -c "echo \"$OUTPUT\"; echo; echo 'Please press RETURN to clear this message.'; read x"
	    fi
	fi
    shift 1	# shift to the next file
    done

exit 0
