#!/usr/bin/perl
#
# ~ppr/src/www/wwwppop.perl
# Copyright 1995, 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.
#
# Last modified 15 October 1996.
#

# PPR home directory
$HOMEDIR="/usr/ppr";

# PPR configuration file directory
$CONFDIR="/etc/ppr";

# Directory where ppr, ppop, etc. reside
$PPRBIN="$HOMEDIR/bin";

# The authorization file
$CONF="$CONFDIR/www.conf";

# Directory containing test files we can print
#$TESTDIR="/usr/local/lib/ghostscript/3.33/examples";
$TESTDIR="/usr/local/share/ghostscript/4.00/examples";

#==========================================
# A popup error message box.
#==========================================
sub error
{
print <<"EndOfData";
content-type: text/html

<HTML>
<HEAD>
<TITLE>PPR -- Error</TITLE>
</HEAD>
<BODY>
<FORM ACTION="http://$ENV{SERVER_NAME}/cgi-bin/wwwppop" METHOD=POST>
<INPUT TYPE=hidden NAME=window VALUE=$WINDOW>
<INPUT TYPE=hidden NAME=queue VALUE="$QUEUE">
<INPUT TYPE=hidden NAME=job VALUE="$JOB">
<PRE>
EndOfData

print join('',@_);

print <<"EndOfData";
</PRE>
<P>
<INPUT TYPE=submit NAME=submit VALUE=Dismiss>
</FORM>
</BODY>
</HTML>
EndOfData

exit 0;
}

#==========================================
# Spawn a process and print an error
# message if an error occurs.
#==========================================
sub spawn
    {
    pipe(READHANDLE,WRITEHANDLE) || die;

    $pid=fork();

    if($pid == -1)			# error
	{
	&error("Fork() failed\n");
	}
    elsif($pid == 0)			# child
	{
	close(READHANDLE);
	open(STDOUT,">&WRITEHANDLE") || die;
	open(STDERR,">&WRITEHANDLE") || die;
	exec(@_);
	exit(242);
	}
    else				# parent
	{
	close(WRITEHANDLE);

	$output="";
	while(<READHANDLE>)
	    {
	    $output="$output$_";
	    }

	close(READHANDLE);

	if($output ne "" && $? != 0)
	    {
	    &error("Executing the command \"",
		join(' ',@_),
		"\"\ngenerated the following output:\n\n$output");
	    }
	}    

    } # end of spawn()

#==========================================
# Return true (non-zero) if the user is
# allowed to make changes.
#==========================================
sub priveledged
    {
    local($host) = $ENV{'REMOTE_HOST'};
    local($thishost);

    $host =~ tr/[A-Z]/[a-z]/;		# translate remote host name to lower case

    open(C,"< $CONF") || return 0;	# open configuration file

    while(<C>)				# read lines
	{
	$_ =~ s/\s*#.*$//;		# delete comments

	if( $_ =~ /^(\S+)/ )		# look for initial word
	    {
	    $thishost = $1;			# extract it
	    $thishost =~ tr/[A-Z]/[a-z]/;	# and convert to lower case

	    if( $thishost eq $host )	# if it matches host name,
		{
		close(C);
		return 1;		# host is authorized
		}
	    }
	}

    close(C);				# if loop ends without match,
    return 0;				# host is not authorized
    }

#==========================================
# First, we read the data on stdin or in
# the environment variable QUERY_STRING
# into an associative array.
#==========================================
undef %data;

if($ENV{'REQUEST_METHOD'} eq "POST")
    { read(STDIN,$line,$ENV{'CONTENT_LENGTH'}); }
elsif($ENV{'REQUEST_METHOD'} eq "GET")
    { $line=$ENV{'QUERY_STRING'}; }
else
    { $line=""; }

# Undo the & + and hex encoding
foreach $item (split(/&/,$line))
    {
    $item =~ s/\+/ /g;
    ($name,$value)=split(/=/,$item);
    $value =~ s/%([0-9A-Z][0-9A-Z])/sprintf("%c",hex($1))/ge;
    $value =~ s/\s+$//;		# remove trailing spaces
    $data{$name}=$value;
    }

#==========================================
# Now, we pull out some things we want.
#==========================================

# The name of the queue to show
if( defined($data{'queue'}) )
	{ $QUEUE = $data{'queue'}; }
else
	{ $QUEUE = "all" }

# The name of the job to show
if( defined($data{'job'}) )
	{ ($JOB,$junk) = split(/\s/,$data{'job'}); }
else
	{ $JOB = "none"; }

# Retrive the last button pressed field
$SUBMIT=$data{'submit'};

# The field which holds the name of the window current window
$WINDOW=$data{'window'};

#==============================================================================
# Handler for the "testjob" window.
#==============================================================================
if( ($WINDOW eq "testjob" && $SUBMIT ne "Dismiss" && $SUBMIT ne "Cancel")
	 || $SUBMIT eq "Test Job" )
{
if( ! &priveledged() ) { &error("You are not allowed to submit test jobs."); }

print <<"EndOfData";
content-type: text/html

<HTML>
<HEAD>
<TITLE>PPR -- Print Test Job</TITLE>
</HEAD>
<BODY>
<FORM ACTION="http://$ENV{SERVER_NAME}/cgi-bin/wwwppop" METHOD=POST>
<INPUT TYPE=hidden NAME=window VALUE=testjob>
<INPUT TYPE=hidden NAME=queue VALUE="$QUEUE">
<INPUT TYPE=hidden NAME=job VALUE="$JOB">
EndOfData

if($QUEUE eq "all")
    {
    print "You must first select a queue to send the job to.\n";
    print "<P>\n<INPUT TYPE=submit NAME=submit VALUE=Dismiss>\n";
    print "</FORM></BODY></HTML>\n";
    exit 0;
    }
elsif($SUBMIT eq "Print")
    {
    if($QUEUE ne "all")
	{
	system("$PPRBIN/ppr -d $QUEUE -C 'Test Job' -f $ENV{REMOTE_HOST} $TESTDIR/$data{file}");
	}
    # fall thru to first level window
    }
else
    {
    print "Please select a file to print:\n<BR>\n";
    $x=0;
    print "<SELECT NAME=file SIZE=10>\n";
    opendir(TESTFILES,$TESTDIR) || die;
    while($file=readdir(TESTFILES))
	{
	next if($file =~ /^\./);
	print " <OPTION ";
	print("SELECTED ") if($x == 0);
	print ">$file\n";
	$x++;
	}
    closedir(TESTFILES);
    print "</SELECT>";

    print "<P>\n";
    print "<INPUT TYPE=submit NAME=submit VALUE=Cancel>\n";
    print "<INPUT TYPE=submit NAME=submit VALUE=Print>\n";
    print "</FORM>\n</BODY>\n</HTML>\n";
    exit 0;
    }
}

#================================================================================
# Handler for the "prncontrol" window.
#================================================================================
if($WINDOW eq "prncontrol" || $SUBMIT eq "Printer Control")
{
if( ! &priveledged() )
    { &error("You are not allowed to control printers."); }

if( $QUEUE eq "all" ) 
    { &error("You must first select a queue to control"); }

print <<"EndOfData";
content-type: text/html

<HTML>
<HEAD>
<TITLE>PPR -- Printer Control</TITLE>
</HEAD>
<BODY>
<FORM ACTION="http://$ENV{SERVER_NAME}/cgi-bin/wwwppop" METHOD=POST>
<INPUT TYPE=hidden NAME=window VALUE=prncontrol>
<INPUT TYPE=hidden NAME=queue VALUE="$QUEUE">
<INPUT TYPE=hidden NAME=job VALUE="$JOB">
EndOfData

print "Not yet implemented.<P>\n";

print "</FORM>\n</BODY>\n</HTML>\n";
exit 0;
}

#================================================================================
# Handle the button which invokes the 
# details window from the first level window
#================================================================================
elsif($SUBMIT eq "Details")	# If the details button has been pressed
{				# we must be in the first window, give details

if($JOB eq "none")	
    { &error("You must first select the job for which you wish to see details."); }

# Start with an empty reason list
$REASON="";

# Start with an empty media list
$MEDIA="";

#
# Run the "ppop details" command to get what we want
#
open(DETAILS,"$PPRBIN/ppop details $JOB |") || die;
while(<DETAILS>)
	{
	chop;
	($key,$value)=split(/:/,$_,2);	# split at colon
	$value =~ s/^\s+//;		# remove leading space from value
	if($key eq "Reason")		# if it is a reason,
	    {				# add to the reason list
	    if($REASON eq "")
		{
		$REASON=$value;
		}
	    }
	elsif($key eq "Media")		# if it is a media name,
	    {
	    $value =~ /^(\S+)/;		# add first word
	    $MEDIA="$MEDIA$1 ";		# to the media list
	    }
	else				# other things, 
	    {
	    $data{$key}=$value;		# store in associative array
	    }
	}
close(DETAILS);

print <<"EndOfData";
content-type: text/html

<HTML>
<HEAD>
<TITLE>PPR -- Job Details</TITLE>
</HEAD>
<BODY>
<FORM ACTION="http://$ENV{SERVER_NAME}/cgi-bin/wwwppop" METHOD=POST>
<INPUT TYPE=hidden NAME=window VALUE=details>
<INPUT TYPE=hidden NAME=queue VALUE="$QUEUE">
<INPUT TYPE=hidden NAME=job VALUE="$JOB">
Job: <INPUT TYPE=text SIZE=15 VALUE="$data{'Job ID'}">
In queue since: <INPUT TYPE=text SIZE=20 VALUE="$data{'Submission Time'}">
<BR>
Current priority: <INPUT TYPE=text SIZE=3 VALUE="$data{'Current Priority'}">
Origional priority: <INPUT TYPE=text SIZE=3 VALUE="$data{'Origional Priority'}">
<P>
For: <INPUT TYPE=text SIZE=60 VALUE="$data{For}">
<BR>
Title: <INPUT TYPE=text SIZE=59 VALUE="$data{Title}">
<BR>
Creator: <INPUT TYPE=text SIZE=56 VALUE="$data{Creator}">
<P>
Pages: <INPUT TYPE=text SIZE=4 VALUE="$data{Pages}">
Pages per sheet: <INPUT TYPE=text SIZE=2 VALUE="$data{'Pages Per Sheet'}">
Copies: <INPUT TYPE=text SIZE=3 VALUE="$data{Copies}">
Collated: <INPUT TYPE=text SIZE=6 VALUE="$data{Collate}">
<BR>
N-Up: <INPUT TYPE=text SIZE=2 VALUE="$data{'N-Up N'}">
Borders: <INPUT TYPE=text SIZE=5 VALUE="$data{'N-Up Borders'}">
Sheets per signiture: <INPUT TYPE=text SIZE=4 VALUE="$data{'Signiture Sheets'}">
Signiture Sides: <INPUT TYPE=text SIZE=8 VALUE="$data{'Signiture Part'}">
<P>
Media: <INPUT TYPE=text SIZE=40 VALUE="$MEDIA">
<BR>
Status: <INPUT TYPE=text SIZE=16 VALUE="$data{'Status'}">
<INPUT TYPE=text SIZE=30 VALUE="$REASON">
<TEXTAREA NAME=log COLS=80 ROWS=4>
EndOfData

open(LOG,"$PPRBIN/ppop log $JOB |") || die;
while(<LOG>)
    { print; }
close(LOG);

print <<"EndOfData";
</TEXTAREA>
<P>
<INPUT TYPE=submit NAME=submit VALUE="Dismiss">
</FORM>
</BODY>
</HTML>
EndOfData
exit 0;
}

#===============================================================================
# Actions for the first level window
# which don't cause a window switch.
#===============================================================================
if($SUBMIT eq "Delete")
    {
    if( ! &priveledged() ) { &error("You are not allowed to delete print jobs."); }

    if($JOB ne "none")
	{
	&spawn("$PPRBIN/ppop","cancel",$JOB);
	}
    else
	{
	&error("You must first select a job to delete.");
	}
    }
elsif($SUBMIT eq "Rush")
    {
    if( ! &priveledged() ) { &error("You are not allowed to rush print jobs."); }

    if($JOB ne "none")
	{
	&spawn("$PPRBIN/ppop","rush",$JOB);
	}
    else
	{
	&error("You must first select a job to rush.");
	}
    }
elsif($SUBMIT eq "Hold")
    {
    if( ! &priveledged() ) { &error("You are not allowed to hold print jobs."); }

    if($JOB ne "none")
	{
	&spawn("$PPRBIN/ppop","hold",$JOB);
	}
    else
	{
	&error("You must first select a job to hold.");
	}
    }
elsif($SUBMIT eq "Release")
    {
    if( ! &priveledged() ) { &error("You are not allowed to release print jobs."); }

    if($JOB ne "none")
	{
	&spawn("$PPRBIN/ppop","release",$JOB);
	}
    else
	{
	&error("You must first select a job to release.");
	}
    }

#===============================================================================
# If we get this far, we emmit the form for the first 
# level window.
#===============================================================================

# Header
print <<"EndOfData";
content-type: text/html

<HTML>
<HEAD>
<TITLE>PPR -- Print Queue Managment</TITLE>
</HEAD>
<BODY>
EndOfData

# debuging
print "<PRE>\n";
#foreach (keys %ENV) { print "$_=\"$ENV{$_}\"\n"; }
#foreach (keys %data) { print "$_=\"$data{$_}\"\n"; }
#print "line=\"$line\"\n";
print "</PRE>\n";

# The start of the form
print "<FORM ACTION=\"http://$ENV{SERVER_NAME}/cgi-bin/wwwppop\" METHOD=POST>\n";
print "<INPUT TYPE=hidden NAME=window VALUE=first>\n";
print "<PRE>Print Queue    Jobs        For\n";

# The print queue selector
print "<SELECT NAME=queue SIZE=10>\n";

print " <OPTION";
if( $QUEUE eq "all" ) {print " SELECTED";}
print ">all\n";

open(QLIST,"$PPRBIN/ppop dest all |") || die;
$junk=<QLIST>;
$junk=<QLIST>;
while(<QLIST>)
	{
	($name,$type,$status,$accepting) = split;
	print " <OPTION";
	if($name eq $QUEUE) { print " SELECTED"; }
	print ">$name\n";
	}
close(QLIST);

print "</SELECT>  ";		# no cr!

# The job selector
print "<SELECT NAME=job SIZE=10>\n";

open(QLIST,"$PPRBIN/ppop list $QUEUE |") || die;
$junk=<QLIST>;		# discard column headings
$junk=<QLIST>;		# discard divider
$x=0;
while(<QLIST>)
	{
	next if($_ =~ /^ /);	# skip continuation lines
	chop;			# remove line feed
	($name,$owner,$time,$pages,$status) = split(/[ \t\n]+/,$_,5);
	print " <OPTION"; if($name eq $JOB) {print " SELECTED";} print ">";
	$status = "($status)";
	$status="" if($status =~ /waiting for printer/);
	print "$name $owner $status";
	$x++;
	}
close(QLIST);

if($x == 0)
    {
    print " <OPTION SELECTED>none\n";
    }

print "</SELECT>\n";

# The buttons at the bottom.
print "\n";
print "<INPUT TYPE=submit NAME=submit VALUE=\"Get Queue\"> ";
print "<INPUT TYPE=submit NAME=submit VALUE=Delete> ";
print "<INPUT TYPE=submit NAME=submit VALUE=Rush> ";
print "<INPUT TYPE=submit NAME=submit VALUE=Hold> ";
print "<INPUT TYPE=submit NAME=submit VALUE=Release> ";
print "<INPUT TYPE=submit NAME=submit VALUE=Details>\n";
print "<P>\n";
print "<INPUT TYPE=submit NAME=submit VALUE=\"Test Job\"> ";
# print "<INPUT TYPE=submit NAME=submit VALUE=\"Printer Control\">\n";

# Close everything
print <<"EndOfData";
</FORM>
</PRE>
</BODY>
</HTML>
EndOfData

exit 0;

# end of file
