#!/usr/bin/perl -w
#
# ~ppr/src/misc/samba_submitter.perl
# Copyright 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software and documentation are provided "as is" without
# express or implied warranty.
#
# This file was last modified 10 December 1996.
#

$HOMEDIR = "?";
$PPR = "$HOMEDIR/bin/ppr";
$TEMPDIR = "?";

# Turning this on can cause incorrect operation.
#$DEBUG = 1;

use FileHandle;
use Socket;
$SOCKADDR = "S n a4 x8";

sub make_connexion
  {
  my($file, $hostname, $port) = @_;

  print "make_connexion(file=$file, hostname=\"$hostname\", port=$port\n" if($DEBUG);

  # Connect to the client's pprpopup program
  $proto = (getprotobyname('tcp'))[2];

  # Look up the client's IP address.
  if( ! defined($address = (gethostbyname($hostname))[4]) )
    {
    print "Host \"$hostname\" is not known\n" if($DEBUG);
    return -1;
    }

  # Create a TCP/IP socket.
  socket($file, AF_INET, SOCK_STREAM, $proto)
     || die "socket() failed: $!\n";

  # Open the TCP/IP connexion.
  if( ! connect($file, pack($SOCKADDR, AF_INET, $port, $address)) )
    {
    print "connect() failed: $!\n" if($DEBUG);
    return -1;
    }

  $file->autoflush(1);
  return 0;
  }

# Assign names to our arguments.
($CLIENT, $CLIENT_IP, $CLIENT_PORT, $USER, $PRINTER, $FILE) = @ARGV;

if($DEBUG)
  {
  open(STDOUT, ">> $TEMPDIR/samba_submitter.log") || die;
  chmod(0666, "$TEMPDIR/samba_submitter.log") || die;
  open(STDIN, "< /dev/null") || die;
  open(STDERR, ">&STDOUT") || die;
  select(STDERR);
  $| = 1;
  select(STDOUT);
  $| = 1;
  print "CLIENT = \"$CLIENT\", CLIENT_IP=\"$CLIENT_IP\", CLIENT_PORT=$CLIENT_PORT, USER = \"$USER\", PRINTER = \"$PRINTER\", FILE = \"$FILE\"\n";
  }

# Make a connexion to the client's pprpopup.
if( make_connexion(CLIENTCON, $CLIENT_IP, $CLIENT_PORT) != -1 )
    {
    # Demand a user name.
    print "Sending request for user name...\n" if($DEBUG);
    sleep(1);
    print CLIENTCON "USER\r\n";

    # Wait for an answer.
    my $answer = <CLIENTCON>;
    $answer =~ s/\s+$//;
    print "\$answer = \"$answer\"\n" if($DEBUG);

    close(CLIENTCON);

    # If we got a user name,
    if( $answer =~ /^\+OK (.+)$/ )
	{
	$username = $1;
	}

    # If the user canceled the job, dump it.
    elsif( $answer =~ /^-ERR/ )
	{
	print "Discarding job\n" if($DEBUG);
	unlink($FILE);
	exit(0);
	}

    else
	{
	print "Received null answer!\n";
	}

    print "Running ppr for user \"$username\".\n";

    exec($PPR, '-d', $PRINTER, '-e', 'responder', '-w', 'log',
	'-m', 'pprpopup', '-r', "$CLIENT_IP:$CLIENT_PORT",
	'-X', "$CLIENT\@samba",
	'-f', $username, '-C', '', '-U', '-I', $FILE);

    }

# Since pprpopup is not running on the client computer, we will
# so this best we can.  This includes instructing PPR to use
# the "samba" responder.
else
    {
    print "pprpopup not running on client, will use samba responder\n";

    exec($PPR, '-d', $PRINTER, '-e', 'responder', '-w', 'log',
	'-m', 'samba', '-r', "$CLIENT-$CLIENT_IP",
	'-X', "$CLIENT\@samba",
	'-f', $USER, '-C', '', '-U', '-I', $FILE);
    }

exit(0);
