#!/usr/bin/perl -w
#
# ~ppr/src/misc/ppdconf.perl
# Copyright 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software and documentation are provided "as is" without
# express or implied warranty.
#
# This file was last modified 6 January 1997.
#

#
# This program creates two directories in the current directory, one called
# "mswin", the other "macos".  It then goes thru the list of PPD files
# which PPR has and asks you if you want each one.  If you want it, it
# converts to to MS-Windows and MacOS format and deposits it in each of
# the directories.  Conversion involves changing the line termination and
# giving the file the proper name for the operating system in question.
#

$PPDDIR = "/usr/ppr/PPDFiles";
$MSWINDIR = "mswin";
$MACOSDIR = "macos";

$| = 1;

if( ! -d $MSWINDIR ) { mkdir($MSWINDIR,0755) || die; }

if( ! -d $MACOSDIR ) { mkdir($MACOSDIR,0755) || die; }

opendir(DIR,$PPDDIR) || die;

while( $file = readdir(DIR) )
  {
  next if($file =~ /\./);

  print "$file? ";

  $answer = <STDIN>;

  if($answer =~ /^y/i)
    {
    undef $mswin_name;
    undef $macos_name;

    open(IN,"<$PPDDIR/$file") || die;
    open(MSWIN,">$MSWINDIR/new") || die;
    open(MACOS,">$MACOSDIR/new") || die;

    while(<IN>)
	{
	chop;

	# For MACOS we just translate the line ending
	print MACOS "$_\r";

	# for MS-Windows we also chop off any
	# translation strings since they confuse.
	if($_ !~ /\*Option/) { s/\/.+:/:/; }
	print MSWIN "$_\r\n";

	if( ! defined($mswin_name) && $_ =~ /^\*PCFileName:\s+"([^"]+)"/ )
	    {
	    $mswin_name = $1;
	    $mswin_name =~ tr/A-Z/a-z/;
	    }

	if( ! defined($macos_name) && $_ =~ /^\*Product:\s+"\(([^)]+)\)"/ )
	    {
	    $macos_name = $1;
	    }
	}

    close(IN) || die;
    close(MSWIN) || die;
    close(MACOS) || die;

    if( ! defined($mswin_name) ) { print "No *PCFileName: line\n"; exit(1); }
    if( ! defined($macos_name) ) { print "No *Product: line\n"; exit(1); }

    rename("$MSWINDIR/new","$MSWINDIR/$mswin_name") || die;
    rename("$MACOSDIR/new","$MACOSDIR/$macos_name") || die;
    }

  }

closedir(DIR);

exit(0);
