/*
** ~ppr/src/libpprdb/dbmod.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Make modifications to the user database.
**
** This file was last modified 4 October 1996.
*/

#include "global_defines.h"
#include "userdb.h"

/*
** Add a user to the database.  Return non-zero if 
** the operation fails for any reason.
*/
int db_add_user(const char *username, struct userdb *user)
    {
    error("db_add_user(): user database support not compiled in");
    return USER_ERROR;
    } /* end of db_add_user() */

/* 
** Delete a user from the database.  Return non-zero if
** the operation fails for any reason.
*/
int db_delete_user(const char *username)
    {
    error("db_delete_user(): user database support not compiled in");
    return USER_ERROR;
    } /* en dof db_delete_user() */

/*
** Change a user's authcode.
*/
int db_new_authcode(const char *username, const char *newauthcode)
    {
    error("db_new_authcode(): user database support not compiled in");
    return USER_ERROR;
    } /* end of db_new_authcode() */

/* end of file */
