/*
** ~ppr/src/libpprdb/dbstrlower.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 20 February 1997.
*/

/*
** Make a new copy of a string which copy has been converted to 
** lower case.
*/

#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <string.h>
#include "global_defines.h"

char *dbstrlower(const char *s)
    {
    char *ns;           /* new string */
    char *ptr;          /* pointer into new string */
    
    ptr = ns = mystrdup(s);

    while(*s)
        *(ptr++) = tolower(*(s++));

    return ns;
    } /* end of strlower() */

/* end of file */

