/*
** ~ppr/src/libppr/unreadqfile.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 20 February 1997.
*/

#include "global_defines.h"
#include "global_structs.h"

/* Define a version of myfree() which can free const stuff: */
#define myfree_const(a) myfree((void*)a)

/*
** depopulate the structure 
*/
void destroy_struct_QFileEntry(struct QFileEntry *job)
    {
    if(job->username != (char*)NULL)
    	myfree_const(job->username);
    if(job->proxy_for != (char*)NULL)
    	myfree_const(job->proxy_for);
    if(job->ForLine != (char*)NULL)
        myfree_const(job->ForLine);
    if(job->charge_to != (char*)NULL)
        myfree_const(job->charge_to);
    if(job->Creator != (char*)NULL)
        myfree_const(job->Creator);
    if(job->Title != (char*)NULL)
        myfree_const(job->Title);
    if(job->lpqFileName != (char*)NULL)
    	myfree_const(job->lpqFileName);
    if(job->Draft != (char*)NULL)
	myfree_const(job->Draft);
    if(job->response_method != (char*)NULL)
        myfree_const(job->response_method);
    if(job->response_address != (char*)NULL)
        myfree_const(job->response_address);
    if(job->responder_options != (char*)NULL)
    	myfree_const(job->responder_options);
    if(job->destnode != (char*)NULL)
    	myfree_const(job->destnode);
    if(job->destname != (char*)NULL)
    	myfree_const(job->destname);
    if(job->homenode != (char*)NULL)
    	myfree_const(job->homenode);
    } /* end of destroy_struct_QFileEntry() */
    
/* end of file */
