/*
** ~ppr/src/libppr/torf.c
** Copyright 1995, Trinity College Computing Center.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Read a True or False answer and return ANSWER_TRUE, ANSWER_FALSE,
** or ANSWER_UNKNOWN.
**
** This file was last modified 2 August 1995.
*/                                                              

#include "global_defines.h"

int torf(const char *s)
    {
    while( *s == ' ' || *s == '\t' )    /* eat up */
        s++;                            /* leading white space */

    switch(*s)
        {
        case 'y':
        case 'Y':
        case 't':
        case 'T':
            return ANSWER_TRUE;
        case 'n':
        case 'N':
        case 'f':
        case 'F':
            return ANSWER_FALSE;
        default:                
            return ANSWER_UNKNOWN;
        }
    } /* end of torf() */
                                                           
/* end of file */
