#
# ~ppr/src/libppr/speach.pl
# Copyright 1996, 1997, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software and documentation are provided "as is" without
# express or implied warranty.
#
# Last modified 17 January 1997.
#

#
# This module contains routines needed to assemble spoken messages 
# from recorded components and play the assembled messages.
# 

# These should be defined before we are included:
die if( !defined($HOMEDIR) || !defined($VAR_SPOOL_PPR) );

# Directory with the sound files:
$SOUNDS_ROOT_DIR = "$HOMEDIR/speach";
$SOUNDS_DIR = "$SOUNDS_ROOT_DIR/male1";
$FALLBACK_SOUNDS_DIR = "$SOUNDS_ROOT_DIR/male1";

# The SMB server name of this computer.  If you have Samba
# set up to user a different name, you will have to change this.
$THIS_SERVER = `uname -n`;
chomp $THIS_SERVER;

# The PPR client spooling area:
$CLISPOOL_UNIX = "$VAR_SPOOL_PPR/pprclipr";
$CLISPOOL_LANMAN = "\\\\$THIS_SERVER\\pprclipr";

$srand_called = 0;

#
# Change the voice that is speaking:
#
sub speach_voice
  {
  my $voice = $_[0];

  $SOUNDS_DIR = "$SOUNDS_ROOT_DIR/$voice";
  }

#
# Play the indicated .au files.
#
sub play_many_au
  {
  my $ADDRESS = shift;
  my @filelist = @_;

  # Temporary file to hold output.
  my $TEMP_AU = $ADDRESS;
  $TEMP_AU =~ s/[^a-z0-9]/_/ig;		# slashes and colons would be poision
  $TEMP_AU .= "-$$.au";

  # Suppress spurios warnings
  my $header = "";
  my $data = "";

  # Open a temporary file to hold it.
  open(OUT, "> $CLISPOOL_UNIX/$TEMP_AU") || die;

  # Do each file:
  my $infile;
  foreach $infile (@filelist)
    {
    if(ref($infile) eq "ARRAY")
	{
	# Seed the random number generator if it has
	# not been seeded yet.
	if(! $srand_called)
	    {
	    srand();
	    $srand_called = 1;
	    }

	# Pick a random number between 0 and 99.
	my $r = int(rand(100));
	my $x;

	# Try each sound in turn, using it if the value is
	# within its range.
	for($x = 0; $x < $#{$infile}; $r-=$infile->[$x], $x+=2)
	    {
	    #print "r = $r, sound = $infile->[$x]\n";
	    last if($r < $infile->[$x]);
	    }

	# If we have run out of sound, don't play one.
	next if( ! ($x < $#{$infile}) );

	# Assign the selected sound to $infile so
	# it will get played.
	$infile = $infile->[$x + 1];
	}

    # Open this sound file.  If its name begins
    # with "*" then it is a silly sound. 
    if($infile =~ /^\*/o)
	{
	my $file = substr($infile, 1);
	if( ! open(IN, "< $SOUNDS_ROOT_DIR/silly_sounds/$file.au") )
	    {
	    print "Missing sound: \"$infile\"\n";
	    next;
	    }
	}

    # If it doesn't begin with "*", look for it in
    # the directory for the selected voice.
    elsif( ! open(IN, "< $SOUNDS_DIR/$infile.au") )
	{
	# Try to fall back to another voice
	if( ! open(IN, "< $FALLBACK_SOUNDS_DIR/$infile.au") )
	    {
	    print "Missing sound: \"$infile\"\n";
	    open(IN, "< $SOUNDS_ROOT_DIR/silly_sounds/bounce.au") || die;
	    }
	}

    # Read the header
    if( read(IN, $header, 24) != 24 ) { die; }

    # Unpack the header
    my($magic, $hdr_size, $data_size, $encoding, $sample_rate, $channels) =
	unpack("a4NNNNN", $header);

    # Make sure this is a bit endian .au file.
    die if($magic ne ".snd");

    # Repack the header with extra bytes removed and 
    # the data_size unspecified
    $data_size = ~0;
    if( ! $header_emmited )
      {
      print OUT pack(a4NNNNN, ".snd", 24, $data_size, $encoding, $sample_rate, $channels);
      $header_emmited = 1;
      }

    seek(IN, $hdr_size - 24, 1) || die;

    my $data = "";
    while( read(IN, $data, 4096) )
      { print OUT $data; }

    close(IN);
    }

  close(OUT);

  if($ADDRESS =~ /\//)
    { local_play_au($ADDRESS, "$CLISPOOL_UNIX/$TEMP_AU"); }
  else
    { remote_play_au($ADDRESS, "$CLISPOOL_LANMAN\\$TEMP_AU"); }

  unlink("$CLISPOOL_UNIX/$TEMP_AU") || die;
  } # play_many_au()

#
# Spell out the indicated word by pushing the individual letters
# onto the indicated playlist.
#
sub spellout
    {
    my($playlist, $word) = @_;
    my $letter;

    $word =~ tr/[A-Z]/[a-z]/;

    foreach $letter (split(//,$word))
	{
	push(@$playlist, $letter);
	}
    }

#
# Push the words for the indicated number onto the playlist.
#
sub speak_number_99
    {
    my($playlist, $number) = @_;
    my $tens;
    my $ones_place;

    if($number <= 20)
	{
	push(@$playlist, $number);
	}
    else
	{
	if( ($tens = int($number/10)*10) )
	    { push(@$playlist, $tens); }
	if( ($ones_place = $number % 10) )
	    { push(@$playlist, $ones_place); }
	}
    }

sub speak_number_999
    {
    my($playlist, $number) = @_;
    my $hundreds_place;

    if( ($hundreds_place = int($number / 100)) )
	{
	push(@$playlist, $hundreds_place);
	push(@$playlist, "hundred");
	}

    speak_number_99($playlist, ($number % 100) );
    }

sub speak_number_999999
    {
    my($playlist, $number) = @_;
    my $thousands;

    if( ($thousands = int($number/1000)) )
	{
	speak_number_999($playlist, $thousands);
	push(@$playlist, "thousand");
	}

    speak_number_999($playlist, ($number % 1000));
    }

sub speak_number_999999999
    {
    my($playlist, $number) = @_;
    my $millions;

    if( ($millions = int($number/1000000)) )
	{
	speak_number_999999($playlist, );
	push(@$playlist, "million");
	}

    speak_number_999999($playlist, ($number % 1000000));
    }

sub speak_number_999999999999
    {
    my($playlist, $number) = @_;
    my $thousand_millions;

    if( ($thousand_millions = int($number/1000000000)) )
	{
	speak_number_999999999($playlist, );
	push(@$playlist, "thousand million");
	}

    speak_number_999999999($playlist, ($number % 1000000000));
    }

sub speak_number
    {
    my($playlist, $number) = @_;

    if( $number > 999999999999 )
	{
	push(@$playlist, "number too big to pronounce");
	}
    else
	{
	speak_number_999999999999($playlist, $number);
	}
    }

#
# Push the words for the indicated time interval onto the playlist
#
sub speak_time_interval_division
    {
    my($playlist, $division, $n) = @_;

    if($n == 1)
	{
	push(@$playlist, "one $division");
	}
    elsif( $n > 0 )
	{
	speak_number_99($playlist, $n);
	push(@$playlist, "${division}s");
	}
    }

sub speak_time_interval
    {
    my($playlist, $interval) = @_;

    my $seconds = $interval % 60;
    $interval = int($interval / 60);

    my $minutes = $interval % 60;
    $interval = int($interval / 60);

    my $hours = $interval % 24;
    $interval = int($interval / 24);

    my $days = $interval;

    speak_time_interval_division($playlist, "day", $days);
    speak_time_interval_division($playlist, "hour", $hours);
    speak_time_interval_division($playlist, "minute", $minutes);
    speak_time_interval_division($playlist, "second", $seconds);
    }

1;
