/*
** ~ppr/src/libppr/readqfile.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 21 February 1997.
*/

#include "global_defines.h"
#include "global_structs.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <setjmp.h>

/*
** Internal function to read a single line from the queue file. 
*/
static void _getl(jmp_buf env, char *line, int maxlen, FILE *in)
    {
    int len;

    if(fgets(line,maxlen,in)==(char*)NULL)
        {                           /* if end of file */
        error("Unexpected end of file in read_queue_file().");
        longjmp(env,1);             /* error, get out */
        }

    len=strlen(line);               /* remove trailing newline */
    if( (--len>=0) && (line[len]=='\n') )
        line[len]=(char)NULL;
    } /* end of _getl() */

/*
** Read the queue file up to but not including the first "Media:" line.
** Return 0 if all goes well, -1 if there is an error in the queue file.
*/
#define GETLINE _getl(env,tempstr,sizeof(tempstr),qfile)

int read_struct_QFileEntry(FILE *qfile, struct QFileEntry *job)
    {
    char tempstr[MAX_QFLINE+2];
    jmp_buf env;

    if(setjmp(env))             /* set place for GETLINE to jump back */
        return -1;              /* to to register an error */

    /* Clear these things because we won't read them. */
    job->destnode = (char*)NULL;
    job->destname = (char*)NULL;
    job->homenode = (char*)NULL;

    /* Clear these things in case we can't read them. */
    job->username = (char*)NULL;
    job->proxy_for = (char*)NULL;
    job->Title = (char*)NULL;
    job->charge_to = (char*)NULL;
    job->ForLine = (char*)NULL;
    job->Creator = (char*)NULL;
    job->Routing = (char*)NULL;
    job->lpqFileName = (char*)NULL;
    job->response_method = (char*)NULL;
    job->response_address = (char*)NULL;
    job->responder_options = (char*)NULL;
    job->Draft = (char*)NULL;

    GETLINE;		/* discard "PPRVersion: x.xx" */

    GETLINE;

    if( ppr_sscanf(tempstr, "Time: %ld", &job->time) == 1 )
	{
	GETLINE;
	}
    else
    	{
    	error("read_queue_file(): bad or missing \"Time:\" line.");
    	return -1;
    	}
    	
    if( ppr_sscanf(tempstr, "User: %ld %S %S", &job->user, &job->username, &job->proxy_for) >= 2 )
	{
        GETLINE;
        }
    else
        {
        error("read_queue_file(): bad or missing \"User:\" line.");
        return -1;
        }

    if( ppr_sscanf(tempstr, "Priority: %d", &job->priority) )		/* required */
	{
        GETLINE;
        }
    else
        {
        error("read_queue_file(): bad or missing \"Priority:\" line.");
        return -1;
        }

    if(ppr_sscanf(tempstr, "For: %Z", &job->ForLine) == 1)
	{
        GETLINE;
        }
    else
        {
        error("read_queue_file(): missing \"For:\" line.");
        return -1;
        }

    if(ppr_sscanf(tempstr, "Charge-To: %Z", &job->charge_to) == 1)
    	{
    	GETLINE;
    	}

    if(ppr_sscanf(tempstr, "Title: %Z", &job->Title) == 1)		/* optional */
    	{
        GETLINE;
	}
	
    if(ppr_sscanf(tempstr, "Draft-Notice: %Z", &job->Draft) == 1)
	{
	GETLINE;
	}

    if(ppr_sscanf(tempstr, "Creator: %Z", &job->Creator) == 1)		/* optional */
	{
	GETLINE;
	}

    if(ppr_sscanf(tempstr, "Routing: %Z", &job->Routing) == 1)		/* optional */
	{
	GETLINE;
	}

    if(ppr_sscanf(tempstr, "lpqFileName: %Z", &job->lpqFileName) == 1)	/* optional */
	{
	GETLINE;
	}

    if(ppr_sscanf(tempstr, "Banners: %d %d", &job->do_banner, &job->do_trailer) == 2)
	{
	GETLINE;
	}
    else
	{
	error("read_queue_file(): missing \"Banners:\" line.");
	return -1;
	}

    if(ppr_sscanf(tempstr, "Response: %S %S %Z", &job->response_method,
		&job->response_address, &job->responder_options) >= 2)
        {
        GETLINE;
        }
    else
        {
        error("read_queue_file(): missing or defective \"Response:\" line.");
        return -1;
        }

    if(sscanf(tempstr, "Attr: %d %f %d %d %d %d %d %d %d %d %d %ld %ld %d",
                &job->attr.langlevel,
                &job->attr.DSClevel,
                &job->attr.pages,
                &job->attr.pageorder,
                &job->attr.prolog,
                &job->attr.docsetup,
                &job->attr.script,
                &job->attr.extensions,
                &job->attr.pagefactor,
                &job->attr.orientation,
                &job->attr.proofmode,
                &job->attr.input_bytes,
                &job->attr.postscript_bytes,
                &job->attr.parts
                ) == 14)
        {
        GETLINE;
        }
    else
        {
        error("read_queue_file(): missing or defective \"Attr:\" line.");
        return -1;
        }

    if( sscanf(tempstr, "Opts: %d %d %d %d %u",
    		&job->opts.binselect,
            	&job->opts.copies,
            	&job->opts.collate,
            	&job->opts.keep_badfeatures,
            	&job->opts.hacks) == 5)
        {
        GETLINE;
        }
    else
        {
        error("read_queue_file(): missing of defective \"Opts:\" line.");
        return -1;
        }

    if( ppr_sscanf(tempstr, "N_Up: %d %d %d %d",
    		&job->N_Up.N,			/* virtual pages per sheet side */
    		&job->N_Up.borders,		/* TRUE or FALSE, should we have borders? */
    		&job->N_Up.sigsheets,		/* sheets per signiture */
    		&job->N_Up.sigpart) == 4)	/* part of signiture */
	{
	GETLINE;
	}
    else
        {
        error("read_queue_file(): missing or defective \"N_Up:\" line.");
        return -1;
        }

    if( ppr_sscanf(tempstr, "Portion: %d %d %d %d",
    		&job->portion.odd,
    		&job->portion.even,
    		&job->portion.start,
    		&job->portion.stop) != 4)
    	{
    	error("read_queue_file(): missing or defective \"Portion:\" line.");
    	return -1;
    	}

    return 0;				/* no error */
    } /* end of read_struct_QFileEntry() */

/* end of file */
