/*
** ~ppr/src/libppr/protected.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This module determines if print destinations are "protected".
**
** This file was last modified 19 May 1996.
*/

#include "global_defines.h"
#include <sys/stat.h>

/*
** Return true if we must verify that the user is in the users database.
*/
int destination_protected(const char *destnode, const char *destname)
    {
    char fname[MAX_PATH];
    struct stat statbuf;

    /*
    ** For the time being we will asume that remote
    ** printers are not protected.
    */
    if( strcmp(destnode, ppr_get_nodename()) != 0 )
    	return FALSE;

    sprintf(fname, "%s/%s", GRCONF, destname);	/* try group */
    if( stat(fname, &statbuf) == 0 )		/* if file found, */
        {                                   
        if(statbuf.st_mode & S_IXOTH)		/* if ``other'' execute bit set, */
            return TRUE;			/* it is protected */
        }
    else                                        /* if not printer, */
        {
        sprintf(fname, "%s/%s", PRCONF, destname);	/* try printer */
        if( stat(fname, &statbuf) == 0 )		/* if it exists, */
            {						/* and other execute set, */
            if(statbuf.st_mode & S_IXOTH)                               
                return TRUE;				/* it is protected */
            }
        }

    return FALSE;   /* if it doen't exist, sombody else will notice */     
    } /* end of destination_protected() */

/* end of file */
