#
# ~ppr/src/libppr/pprpopup.pl
# Copyright 1996, Trinity College Computing Center.
# Written by David Chappell.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software and documentation are provided "as is" without
# express or implied warranty.
#
# Last modified 3 December 1996.
#

#
# Routines needed for communicating with pprpopup.
# 

# Stuff needed for TCP/IP:
use FileHandle;
use Socket;
$SOCKADDR="S n a4 x8";

#==============================================================
# Open a TCP/IP connexion to the indicated port and address.
#==============================================================
sub open_connexion
  {
  my($handle, $ADDRESS) = @_;
  my($HOST, $PORT) = split(/:/, $ADDRESS);

  my $proto = (getprotobyname("tcp"))[2];

  if( ! socket($handle, AF_INET, SOCK_STREAM, $proto) )
    {
    print "open_connexion(): socket() failed, $!\n";
    return 0;
    }

  if( ! defined($address = (gethostbyname($HOST))[4]) )
    {
    print "open_connexion($handle, \"$ADDRESS\"): gethostbyname() failed, $!\n";
    return 0;
    }

  if( ! connect($handle, pack($SOCKADDR, AF_INET, $PORT, $address)) )
    {
    print "open_connexion($handle, \"$ADDRESS\"): connect() failed, $!\n";
    close($handle);
    return 0;
    }

  return 1;
  }

#==============================================================
# Direct the remote computer to play an audio file which we 
# have deposited in the client spooling area.  This function
# is passed the LANMAN share name of the file.
#==============================================================
sub remote_play_au
  {
  my ($address, $file) = @_;

  if($DEBUG) { print "Playing \"$file\"\n"; }

  # Make a connexion to the remote machine:
  if( ! open_connexion(CON, $address) )
    { return 0; }
  CON->autoflush(1);

  # Tell the other end to expect a file of a certain size.
  print CON "SMBPLAY $file\n";

  my $result = <CON>;
  if($DEBUG) { print "result = $result\n"; }

  close(CON);

  return 1;
  }

1;
