/*
** ~ppr/src/libppr/ppr_sscanf.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This file was last modified 6 January 1997.
*/

/*
** This module constains a limited version of sscanf()
** which allows the maximum width of string arguments
** to be specified as an additional argument.  It also defines
** a format called %z which is a string which extends to the end
** of the string which is fed for ppr_sscanf().
*/

#include "global_defines.h"
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>

int ppr_sscanf(const char *string, const char *format, ...)
    {
    va_list va;
    int count=0;		/* Number of things extracted so far. */
    int maxextlen;		/* Maximum characters to extract, including NULL. */
    int len;			/* Actual length */
    int sign;			/* 1 or -1 */
    const char *pattern=format;	/* Current position in the format. */
    int islong;			/* True if ell encountered. */
    int isshort;		/* True if aich encountered. */
    char *extptr;		/* Pointer to string we are extracting into. */

    va_start(va, format);

    while(*pattern && *string)			/* Work until we run out of */
	{					/* pattern or input string. */
        if(*pattern=='%')			/* If special sequence begins, */
	    {
	    pattern++;				
            
            maxextlen = 0;			/* Get "precision" */
            while( isdigit(*pattern) )		/* from any digits in */
                {				/* the format. */
                maxextlen *= 10;
                maxextlen += ( *(pattern++) - '0' );
                }
            if(*pattern=='#')			/* Get "precision" from */
                {
                maxextlen = va_arg(va, int);	/* the next parameter. */
                pattern++;
                }

	    if(*pattern=='l')			/* Will this be a long? */
	    	{ islong=TRUE; pattern++; }
	    else
	    	{ islong=FALSE; }

	    if(*pattern=='h')
	    	{ isshort=TRUE; pattern++; }
	    else
	    	{ isshort=FALSE; }

            switch(*(pattern++))		/* Act on the type id char. */
                {
		case '%':
		    if( *(string++) != '%' )
		    	goto break_break;
		    break;

                case NULL:                      /* Nothing following '%', */
                    pattern--;
                    break;
		/*
		 * Decimal integer.
		 */
                case 'd':
                case 'i':
                    if(*string=='-')		    /* if a minus sign is found, */
                        {
                        string++;
                        sign = -1;		    /* set a flag */
                        }
		    else
		    	{
		    	sign = 1;
		    	}
		    if(islong)
		    	{
			long int templong = 0;
                    	while(isdigit(*string))	    /* convert digits */
                            {
                            templong *= 10;
                            templong += (*(string++)-'0');
                            }        
                        *(va_arg(va, long int *)) = (templong * sign);
                        }
		    else if(isshort)
			{
			short int tempshort = 0;
                    	while(isdigit(*string))	    /* convert digits */
                            {
                            tempshort*=10;
                            tempshort+=(*(string++)-'0');
                            }        
                        *(va_arg(va, short int *))=tempshort*sign; /* store it */
			}
		    else
		    	{
			int tempint = 0;
                    	while(isdigit(*string))	    /* convert digits */
                            {
                            tempint*=10;
                            tempint+=(*(string++)-'0');
                            }        
                        *(va_arg(va, int *)) = (tempint*sign);
                        }
                    count++;			    /* increment count of values extracted */
                    break;
		/*
		 * Extract a string into the storage provided.
		 */
                case 's':
		    extptr = va_arg(va, char *);	/* get str to extract to */
                    while( *string && !isspace(*string) && --maxextlen )  
                        *(extptr++) = *(string++);
                    *extptr = (char)NULL;		/* terminate the string */
                    while( *string && !isspace(*string) )
                        string++;			/* eat extra */
                    count++;				/* one more item done */
                    break;
		/*
		 * Extract a string of any length 
		 * and allocate storage for it.
		 */
		case 'S':
		    len = strcspn(string," \t\n");
		    *(va_arg(va, char **)) = mystrndup(string, len);
		    string += len;
		    count++;
		    break;
		/*
		 * Extract a possibly quoted string of any length 
		 * and allocate storage for it.
		 */
		case 'Q':
		    switch(*string)
		    	{
			case 042:	/* ASCII double quote */
			    string++;
                            len = strcspn(string, "\"");
			    break;
			case 047:	/* ASCII single quote */
			    string++;
			    len = strcspn(string, "'");
			    break;
			default:
			    len = strcspn(string, " \t\n");
			    break;
		    	}
		    *(va_arg(va, char **)) = mystrndup(string, len);
		    string += len;
		    if(*string == 042 || *string == 047)
		    	string++;
		    count++;
		    break;
		/*
		 * Get rest of line as a string, extracting it
		 * into the storage provided.
		 */
		case 'z':
		    extptr = va_arg(va,char *);
		    while( *string && --maxextlen )
		    	*(extptr++) = *(string++);
		    *extptr = (char)NULL;
		    count++;
		    break;
		/*
		 * Get the rest of the line as a string and
		 * allocate storage for it.  Notice that
		 * we pay no attention to maxextlen.
		 */
		case 'Z':
		   len = strcspn(string,"\n");
		   *(va_arg(va,char **)) = mystrndup(string,len);
		   string += len;
		   while(*string)
		   	string++;
		   count++;
		   break;
		/*
		 * Catch unimplemented formats here
		 */
                default:
                    fatal(lib_misc_fatal,"ppr_sscanf(): unrecognized format: %s",format);
                }
            }

        else                                    /* Ordinary characters in */
            {                                   /* pattern must match themselves. */
            if(isspace(*pattern))               /* Whitespace */
                {                               /* matches any amount of */
                pattern++;                      /* whitespace. */
                while(isspace(*string))           
                    string++;
                }
            else                                /* everthing else */
                {                               /* must exactly match */
                if( *(pattern++) != *(string++) )   /* characters in string */
                    break;
                }
            }
        } /* end of loop that lasts as long as pattern and string both last */
	break_break:

    va_end(va);

    return count;
    } /* end of ppr_sscanf() */

/* end of file */
