/*
** ~ppr/src/libppr/pagesize.c
** Copyright 1995, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 2 August 1995.
*/

#include "global_defines.h"
#include <string.h>

/*
** Return the length and width of a page in PostScript units
** as well as a flag indicating if it is an envelope size.
** Return -1 if we fail to find a match, return 0 if we find one.
**
** This routine is meant to interpret the arguments to the
** DSC comments which contain page size names.  This is usesful
** for deducing the media requirements of documents which do
** not contain "%%Media:" comments but do have "%%PageSize:"
** comments.
*/
int pagesize(const char *keyword, int *width, int *length, int *envelope)
    {
    *envelope=FALSE;

    /* there are no keywords less than two characters */
    if( (keyword[0]==(char)NULL) || (keyword[1]==(char)NULL) )
    	return -1;

    switch(keyword[0])
    	{
	case 'A':			/* ISO "A" sizes */
	    if(keyword[2]==(char)NULL)	/* if one character follows "A" */
	    	{
	    	switch(keyword[1])
	    	    {
	    	    case '0':
	    	    	*width=2384;
	    	    	*length=1189;
	    	    	return 0;
	    	    case '1':
			*width=1684;
			*length=2384;
			return 0;
		    case '2':
		    	*width=1191;
		    	*length=1684;
		    	return 0;
		    case '3':
		    	*width=842;
		    	*length=1191;
		    	return 0;
		    case '4':
		    	*width=595;
		    	*length=842;
		    	return 0;
		    case '5':
		    	*width=420;
		    	*length=595;
		    	return 0;
		    case '6':
		    	*width=297;
		    	*length=420;
		    	return 0;
		    case '7':
		    	*width=210;
		    	*length=297;
		    	return 0;
		    case '8':
		    	*width=148;
		    	*length=210;
		    	return 0;
		    case '9':
		    	*width=105;
		    	*length=148;
		    	return 0;			
		    default:
		    	return -1;
    		    }
		}
	    if(strcmp(keyword,"A10")==0)
	    	{
	    	*width=73;
	    	*length=105;
	    	return 0;
	    	}
	    if(strcmp(keyword,"A4Small")==0)
	    	{
	    	*width=595; *length=842;
	    	return 0;
	    	}
    	    return -1;

	case 'B':			/* JIS "B" sizes */
	    if(keyword[2]==(char)NULL)	/* if one character follows "B" */
	    	{
	    	switch(keyword[1])
	    	    {
	    	    case '0':
	    	    	*width=2920;
	    	    	*length=4127;
	    	    	return 0;
	    	    case '1':
			*width=2064;
			*length=2920;
			return 0;
		    case '2':
		    	*width=1460;
		    	*length=2064;
		    	return 0;
		    case '3':
		    	*width=1032;
		    	*length=1460;
		    	return 0;
		    case '4':
		    	*width=728;
		    	*length=1032;
		    	return 0;
		    case '5':
		    	*width=516;
		    	*length=729;
		    	return 0;
		    case '6':
		    	*width=363;
		    	*length=516;
		    	return 0;
		    case '7':
		    	*width=258;
		    	*length=363;
		    	return 0;
		    case '8':
		    	*width=181;
		    	*length=258;
		    	return 0;
		    case '9':
		    	*width=127;
		    	*length=181;
		    	return 0;			
		    default:
		    	return -1;
    		    }
		}
	    if(strcmp(keyword,"B10")==0)
	    	{
	    	*width=91;
	    	*length=127;
	    	return 0;
	    	}
    	    return -1;

	case 'C':			/* ISO "C" sizes */
	    if(keyword[2]==(char)NULL)
	    	{
		switch(keyword[1])
		    {
		    case '0':
		    	*width=2599; *length=3676;
		    	return 0;
		    case '1':
		    	*width=1837; *length=2599;
		    	return 0;
		    case '2':
		    	*width=1298; *length=1837;
		    	return 0;
		    case '3':
		    	*width=918; *length=1296;
		    	return 0;
		    case '4':
		    	*width=649; *length=918;
		    	return 0;
		    case '5':
		    	*width=459; *length=649;
		    	return 0;
		    case '6':
		    	*width=323; *length=459;
		    	return 0;
		    case '7':
		    	*width=230; *length=323;
		    	return 0;
	    	    default:
	    	    	return -1;
	    	    }
	    	}
	    if(strcmp(keyword,"Comm10")==0)
	    	{
	    	*width=297; *length=684;
	    	*envelope=TRUE;
	    	return 0;
	    	}
	    return -1;

	case 'D':		/* ISO "DL" */
	    if(strcmp(keyword,"DL")==0)
	    	{
	    	*width=312; *length=624;
	    	return 0;
	    	}
	    return -1;

	case 'E':		/* Executive */
	    if(strcmp(keyword,"Executive")==0)
	    	{
	    	*width=522; *length=756;	/* one possible set of values */
	    	return 0;			/* also, 540x720, and others */
	    	}
	    return -1;

	case 'F':		/* Folio */
	    if(strcmp(keyword,"Folio")==0)
	    	{
	    	*width=595; *length=936;
	    	return 0;
	    	}
	    return -1;

	case 'I':		/* ISO "ISOB" sizes */
	    if(strncmp(&keyword[1],"SOB",2)==0)
	    	{
		if(keyword[5]==(char)NULL)
		    {
		    switch(keyword[4])
			{
			case '0':
			    *width=2835; *length=4008;
			    return 0;
			case '1':
			    *width=2004; *length=2835;
			    return 0;
			case '2':
			    *width=1417; *length=2004;
			    return 0;
			case '3':
			    *width=1001; *length=1417;
			    return 0;
			case '4':
			    *width=709; *length=1001;
			    return 0;
			case '5':
			    *width=499; *length=709;
			    return 0;
			case '6':
			    *width=354; *length=499;
			    return 0;
			case '7':
			    *width=249; *length=354;
			    return 0;
			case '8':
			    *width=176; *length=249;
			    return 0;
			case '9':
			    *width=125; *length=176;
			    return 0;
			default:
			    return -1;
			}
	    	    }
		if(strcmp(keyword,"ISOB10")==0)
		    {
		    *width=88; *length=125;
		    return 0;
		    }
		return -1;
	    	}
	    return -1;

	case 'L':		/* Letter, Legal, Ledger, LetterSmall */
	    if(strcmp(keyword,"Letter")==0)
	    	{
	    	*width=612; *length=792;
	    	return 0;
	    	}
	    if(strcmp(keyword,"Legal")==0)
	    	{
	    	*width=612; *length=1008;
	    	return 0;
	    	}
	    if(strcmp(keyword,"Ledger")==0)
	    	{
	    	*width=1224; *length=792;
	    	return 0;
	    	}
	    if(strcmp(keyword,"LetterSmall")==0)
	    	{
	    	*width=612; *length=792;
	    	return 0;
	    	}
	    return -1;    	

	case 'M':		/* Monarch */
	    if(strcmp(keyword,"Monarch")==0)
	    	{
	    	*width=279; *length=540;
	    	*envelope=TRUE;
	    	return 0;
	    	}
	    return -1;

	case 'Q':		/* Quarto */
	    if(strcmp(keyword,"Quarto")==0)
	    	{
	    	*width=567; *length=744;
	    	return 0;
	    	}
	    return -1;

	case 'S':		/* Statement */
	    if(strcmp(keyword,"Statement")==0)
	    	{
	    	*width=396; *length=612;
	    	return 0;
	    	}
	    return -1;
	    
	case 'T':		/* Tabloid */
	    if(strcmp(keyword,"Tabloid")==0)
	    	{
	    	*width=792; *length=1224;
	    	return 0;
	    	}
	    return -1;
	    
	case '1':
	    if(strcmp(keyword,"10x13")==0)
	    	{
	    	*width=720; *length=936;
	    	return 0;
	    	}
	    if(strcmp(keyword,"10x14")==0)
	    	{
	    	*width=720; *length=1008;
	    	return 0;
	    	}
	    return -1;

	case '7':
	    if(strcmp(keyword,"7x9")==0)
	    	{
	    	*width=504; *length=648;
	    	return 0;
	    	}
	    return -1;
	    
	case '9':
	    if(strcmp(keyword,"9x11")==0)
	    	{
	    	*width=648; *length=792;
	    	return 0;
	    	}
	    if(strcmp(keyword,"9x12")==0)
	    	{
	    	*width=648; *length=864;
	    	return 0;
	    	}
	    return -1;
	    
	default:
	    return -1;    	
    	}
    } /* end of pagesize() */

/* end of file */
