/*
** ~ppr/src/libppr/padded.c
** Copyright 1995, 1996, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** This file last modified 14 February 1996.
*/

#include <stdio.h>		/* for definition of NULL */

/*
** Copy an ASCIIZ string into a blank padded string
** and vice versa.
*/
void ASCIIZ_to_padded(char *padded, const char *asciiz, int len)
    {
    while( *asciiz && len-- )
        *(padded++)=*(asciiz++);

    while( len-- > 0 )			/* the "> 0" is important! */
        *(padded++)=' ';
    }

void padded_to_ASCIIZ(char *asciiz, const char *padded, int len)
    {
    while(len!=-1 && padded[--len]==' ');       /* clip trailing spaces */
    len++;                                      /* we overshot */
    while(len--)                                /* copy what is left */
        *(asciiz++)=*(padded++);
    *asciiz=(char)NULL;
    }

/*
** Return TRUE if the padded strings are 
** identical.
*/
int padded_cmp(const char *padded1, const char *padded2, int len)
    {
    while(len--)
        {
        if(*(padded1++) != *(padded2++))        /* on 1st mismatch, */
            return 0;                           /* we know they differ */
        }

    return -1;              /* return TRUE */
    }

/* end of file */
