/*
** ~ppr/src/libppr/money.c
** Copyright 1995, 1996, 1997, Trinity College Computing Center.
** Written by David Chappell.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** Last modified 27 February 1997.
*/

#include "global_defines.h"
#include <string.h>

/*
** Return a string representing the amount of money indicated 
** in the argument which is the basic unit times 100.
**
** Notice that this may include parentheses, so ppost()
** should be used to write the result.
*/
char *money(int amount)
    {
    static char temp[32];
    char *ptr;
    int negative = FALSE;

    ptr = temp;

    if(amount<0)
        {
        *(ptr++) = '(';
        negative = TRUE;
        amount *= -1;
        }

    *(ptr++)='$';

    sprintf(ptr,"%d",amount/100);   /* add the whole part */
    ptr += strlen(ptr);

    *(ptr++) = '.';

    amount %= 100;
    *(ptr++) = (amount/10)+'0';
    *(ptr++) = (amount%10)+'0';

    if(negative)
        *(ptr++) = ')';

    *ptr = (char)NULL;		    /* terminate it */
    return temp;                    /* and return a pointer to it */
    } /* end of money() */

/* end of file */
