/*
** ~ppr/src/libppr/lock.c
** Copyright 1994, Trinity College Computing Center.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
** An operating system independent function for obtaining an 
** exclusive lock on a file.
** Last modified 29 November 1994.
*/

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

/*
** Obtain an exclusive lock on an entire file.
** Return -1 if we fail.
** If waitmode is TRUE, block until lock is obtained.
*/
int lock_exclusive(int filenum, int waitmode)
    {
    struct flock lock;
    int retval;

    lock.l_type=F_WRLCK;                    /* exclusive lock */
    lock.l_whence=SEEK_SET;                 /* absolute offset */
    lock.l_start=(off_t)0;                  /* from begining */
    lock.l_len=(off_t)0;                    /* to future end */

    if(waitmode)
	retval=fcntl(filenum,F_SETLKW,&lock);
    else
	retval=fcntl(filenum,F_SETLK,&lock);

    if(retval==-1)
        return -1;
    else
        return 0;
    } /* end of lock_exclusive() */
    
/* end of file */
